/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.Keep;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.utils.MethodReferenceUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Keep
public class AssumeNoSideEffectsRuleForObjectMembersDiagnostic
implements Diagnostic {
    private final List<MethodReference> methods;
    private final Origin origin;
    private final Position position;

    private AssumeNoSideEffectsRuleForObjectMembersDiagnostic(List<MethodReference> methods, Origin origin, Position position) {
        this.methods = methods;
        this.origin = origin;
        this.position = position;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getDiagnosticMessage() {
        Iterator<MethodReference> iterator2 = this.methods.iterator();
        StringBuilder message = new StringBuilder("The -assumenosideeffects rule matches the following method(s) ").append("on java.lang.Object: ").append(MethodReferenceUtils.toSourceStringWithoutHolderAndReturnType(iterator2.next()));
        while (iterator2.hasNext()) {
            MethodReference method = iterator2.next();
            message.append(iterator2.hasNext() ? ", " : " and ").append(MethodReferenceUtils.toSourceStringWithoutHolderAndReturnType(method));
        }
        return message.append(". ").append("This is most likely not intended. ").append("Consider specifying the methods more precisely.").toString();
    }

    public static class Builder {
        private final List<MethodReference> methods = new ArrayList<MethodReference>();
        private Origin origin;
        private Position position;

        public Builder addMatchedMethods(Set<DexMethod> methods) {
            for (DexMethod method : methods) {
                this.methods.add(method.asMethodReference());
            }
            return this;
        }

        public Builder setOrigin(Origin origin) {
            this.origin = origin;
            return this;
        }

        public Builder setPosition(Position position) {
            this.position = position;
            return this;
        }

        public AssumeNoSideEffectsRuleForObjectMembersDiagnostic build() {
            return new AssumeNoSideEffectsRuleForObjectMembersDiagnostic(this.methods, this.origin, this.position);
        }
    }
}

