/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.Keep;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.GraphReporter;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;

@Keep
public class CheckDiscardDiagnostic
implements Diagnostic {
    private final List<String> messages;

    private CheckDiscardDiagnostic(List<String> messages) {
        this.messages = messages;
    }

    @Override
    public Origin getOrigin() {
        return Origin.unknown();
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        StringBuilder builder = new StringBuilder("Discard checks failed.");
        if (this.messages.size() > 0) {
            builder.append(System.lineSeparator());
            builder.append("The following items where not discarded");
            this.messages.forEach(message -> {
                builder.append(System.lineSeparator());
                builder.append((String)message);
            });
        }
        return builder.toString();
    }

    public static class Builder {
        private ImmutableList.Builder<String> messagesBuilder = ImmutableList.builder();

        public Builder addFailedItems(List<ProgramDefinition> failed, GraphReporter graphReporter, WhyAreYouKeepingConsumer whyAreYouKeepingConsumer) {
            for (ProgramDefinition definition : failed) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                whyAreYouKeepingConsumer.printWhyAreYouKeeping(graphReporter.getGraphNode(definition.getReference()), new PrintStream(baos));
                this.messagesBuilder.add((Object)("Item " + definition.getReference().toSourceString() + " was not discarded.\n" + baos.toString()));
            }
            return this;
        }

        public CheckDiscardDiagnostic build() {
            return new CheckDiscardDiagnostic((List)((Object)this.messagesBuilder.build()));
        }
    }
}

