/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors.dontwarn;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.dontwarn.DontWarnConfiguration;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NonEmptyDontWarnConfiguration
extends DontWarnConfiguration {
    private final List<ProguardClassNameList> dontWarnPatterns;
    private final Map<ProguardClassNameList, Set<DexType>> matchedDontWarnPatterns = new IdentityHashMap<ProguardClassNameList, Set<DexType>>();

    NonEmptyDontWarnConfiguration(ProguardClassFilter dontWarnPatterns) {
        assert (dontWarnPatterns != null);
        assert (!dontWarnPatterns.isEmpty());
        this.dontWarnPatterns = dontWarnPatterns.getPatterns();
    }

    private void recordMatch(ProguardClassNameList dontWarnPattern, DexType type) {
        if (InternalOptions.assertionsEnabled()) {
            this.matchedDontWarnPatterns.computeIfAbsent(dontWarnPattern, ignore -> Sets.newIdentityHashSet()).add(type);
        }
    }

    @Override
    public boolean matches(DexType type) {
        for (ProguardClassNameList dontWarnPattern : this.dontWarnPatterns) {
            if (!dontWarnPattern.matches(type)) continue;
            this.recordMatch(dontWarnPattern, type);
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(InternalOptions options) {
        assert (options.testing.allowUnnecessaryDontWarnWildcards || this.validateNoUnnecessaryDontWarnWildcards());
        assert (options.testing.allowUnusedDontWarnRules || this.validateNoUnusedDontWarnPatterns(options));
        return true;
    }

    public boolean validateNoUnnecessaryDontWarnWildcards() {
        for (ProguardClassNameList dontWarnPattern : this.dontWarnPatterns) {
            assert (!dontWarnPattern.hasWildcards() || this.matchedDontWarnPatterns.getOrDefault(dontWarnPattern, Collections.emptySet()).size() != 1) : "Unexpected unnecessary wildcard in -dontwarn " + dontWarnPattern.toString() + " (only matches " + this.matchedDontWarnPatterns.get(dontWarnPattern).iterator().next().getTypeName() + ")";
        }
        return true;
    }

    public boolean validateNoUnusedDontWarnPatterns(InternalOptions options) {
        for (ProguardClassNameList dontWarnPattern : this.dontWarnPatterns) {
            assert (this.matchedDontWarnPatterns.containsKey(dontWarnPattern) || options.testing.allowedUnusedDontWarnPatterns.contains(dontWarnPattern.toString())) : "Unexpected unused rule -dontwarn " + dontWarnPattern.toString();
        }
        return true;
    }
}

