/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.features;

import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.experimental.startup.StartupConfiguration;
import com.android.tools.r8.features.FeatureSplitConfiguration;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ClassToFeatureSplitMap {
    private final FeatureSplit baseStartup;
    private final Map<DexType, FeatureSplit> classToFeatureSplitMap;
    private final Map<FeatureSplit, String> representativeStringsForFeatureSplit;

    private ClassToFeatureSplitMap(FeatureSplit baseStartup, Map<DexType, FeatureSplit> classToFeatureSplitMap, Map<FeatureSplit, String> representativeStringsForFeatureSplit) {
        this.baseStartup = baseStartup;
        this.classToFeatureSplitMap = classToFeatureSplitMap;
        this.representativeStringsForFeatureSplit = representativeStringsForFeatureSplit;
    }

    public static ClassToFeatureSplitMap createEmptyClassToFeatureSplitMap() {
        return new ClassToFeatureSplitMap(FeatureSplit.BASE, new IdentityHashMap<DexType, FeatureSplit>(), null);
    }

    public static ClassToFeatureSplitMap createInitialClassToFeatureSplitMap(InternalOptions options) {
        return ClassToFeatureSplitMap.createInitialClassToFeatureSplitMap(options.dexItemFactory(), options.featureSplitConfiguration, options.startupConfiguration, options.reporter);
    }

    public static ClassToFeatureSplitMap createInitialClassToFeatureSplitMap(DexItemFactory dexItemFactory, FeatureSplitConfiguration featureSplitConfiguration, StartupConfiguration startupConfiguration, Reporter reporter) {
        FeatureSplit baseStartup;
        if (featureSplitConfiguration == null && startupConfiguration == null) {
            return ClassToFeatureSplitMap.createEmptyClassToFeatureSplitMap();
        }
        IdentityHashMap<DexType, FeatureSplit> classToFeatureSplitMap = new IdentityHashMap<DexType, FeatureSplit>();
        IdentityHashMap<FeatureSplit, String> representativeStringsForFeatureSplit = new IdentityHashMap<FeatureSplit, String>();
        if (featureSplitConfiguration != null) {
            for (FeatureSplit featureSplit : featureSplitConfiguration.getFeatureSplits()) {
                String representativeType = null;
                for (ProgramResourceProvider programResourceProvider : featureSplit.getProgramResourceProviders()) {
                    try {
                        for (ProgramResource programResource : programResourceProvider.getProgramResources()) {
                            for (String classDescriptor : programResource.getClassDescriptors()) {
                                DexType type = dexItemFactory.createType(classDescriptor);
                                classToFeatureSplitMap.put(type, featureSplit);
                                if (representativeType != null && classDescriptor.compareTo(representativeType) <= 0) continue;
                                representativeType = classDescriptor;
                            }
                        }
                    }
                    catch (ResourceException e) {
                        throw reporter.fatalError(e.getMessage());
                    }
                }
                if (representativeType == null) continue;
                representativeStringsForFeatureSplit.put(featureSplit, representativeType);
            }
        }
        if (startupConfiguration != null && startupConfiguration.hasStartupClasses()) {
            DexType representativeType = null;
            for (DexType startupClass : startupConfiguration.getStartupClasses()) {
                if (classToFeatureSplitMap.containsKey(startupClass)) continue;
                classToFeatureSplitMap.put(startupClass, FeatureSplit.BASE_STARTUP);
                if (representativeType != null && startupClass.getDescriptor().compareTo(representativeType.getDescriptor()) <= 0) continue;
                representativeType = startupClass;
            }
            baseStartup = FeatureSplit.BASE_STARTUP;
            representativeStringsForFeatureSplit.put(baseStartup, representativeType.toDescriptorString());
        } else {
            baseStartup = FeatureSplit.BASE;
        }
        return new ClassToFeatureSplitMap(baseStartup, classToFeatureSplitMap, representativeStringsForFeatureSplit);
    }

    private static ClassToFeatureSplitMap getMap(AppView<AppInfoWithLiveness> appView) {
        return appView.appInfo().getClassToFeatureSplitMap();
    }

    public static boolean isInFeature(DexProgramClass clazz, AppView<AppInfoWithLiveness> appView) {
        return ClassToFeatureSplitMap.getMap(appView).isInFeature(clazz, appView.getSyntheticItems());
    }

    public int compareFeatureSplits(FeatureSplit featureSplitA, FeatureSplit featureSplitB) {
        assert (featureSplitA != null);
        assert (featureSplitB != null);
        if (featureSplitA == featureSplitB) {
            return 0;
        }
        if (featureSplitA.isBase()) {
            return 1;
        }
        if (featureSplitB.isBase()) {
            return -1;
        }
        return this.representativeStringsForFeatureSplit.get(featureSplitA).compareTo(this.representativeStringsForFeatureSplit.get(featureSplitB));
    }

    public FeatureSplit getBaseStartup() {
        return this.baseStartup;
    }

    public Map<FeatureSplit, Set<DexProgramClass>> getFeatureSplitClasses(Set<DexProgramClass> classes, SyntheticItems syntheticItems) {
        IdentityHashMap<FeatureSplit, Set<DexProgramClass>> result = new IdentityHashMap<FeatureSplit, Set<DexProgramClass>>();
        for (DexProgramClass clazz : classes) {
            FeatureSplit featureSplit = this.getFeatureSplit(clazz, syntheticItems);
            if (featureSplit == null || featureSplit.isBase()) continue;
            result.computeIfAbsent(featureSplit, ignore -> Sets.newIdentityHashSet()).add(clazz);
        }
        return result;
    }

    public FeatureSplit getFeatureSplit(ProgramDefinition clazz, SyntheticItems syntheticItems) {
        return this.getFeatureSplit(clazz.getContextType(), syntheticItems);
    }

    public FeatureSplit getFeatureSplit(DexType type, SyntheticItems syntheticItems) {
        FeatureSplit feature = this.classToFeatureSplitMap.get(type);
        if (feature != null) {
            return feature;
        }
        feature = syntheticItems.getContextualFeatureSplit(type, this);
        if (feature != null) {
            return feature;
        }
        return FeatureSplit.BASE;
    }

    public boolean isEmpty() {
        return this.classToFeatureSplitMap.isEmpty();
    }

    public boolean isInBase(DexProgramClass clazz, SyntheticItems syntheticItems) {
        return this.getFeatureSplit(clazz, syntheticItems).isBase();
    }

    public boolean isInBaseOrSameFeatureAs(DexProgramClass clazz, ProgramDefinition context, SyntheticItems syntheticItems) {
        return this.isInBaseOrSameFeatureAs(clazz.getContextType(), context, syntheticItems);
    }

    public boolean isInBaseOrSameFeatureAs(DexType clazz, ProgramDefinition context, SyntheticItems syntheticItems) {
        FeatureSplit split = this.getFeatureSplit(clazz, syntheticItems);
        return split.isBase() || split == this.getFeatureSplit(context, syntheticItems);
    }

    public boolean isInFeature(DexProgramClass clazz, SyntheticItems syntheticItems) {
        return !this.isInBase(clazz, syntheticItems);
    }

    public boolean isInSameFeatureOrBothInSameBase(ProgramMethod a, ProgramMethod b, SyntheticItems syntheticItems) {
        return this.isInSameFeatureOrBothInSameBase(a.getHolder(), b.getHolder(), syntheticItems);
    }

    public boolean isInSameFeatureOrBothInSameBase(DexProgramClass a, DexProgramClass b, SyntheticItems syntheticItems) {
        return this.getFeatureSplit(a, syntheticItems) == this.getFeatureSplit(b, syntheticItems);
    }

    public ClassToFeatureSplitMap rewrittenWithLens(GraphLens lens) {
        IdentityHashMap<DexType, FeatureSplit> rewrittenClassToFeatureSplitMap = new IdentityHashMap<DexType, FeatureSplit>();
        this.classToFeatureSplitMap.forEach((type, featureSplit) -> {
            DexType rewrittenType = lens.lookupType((DexType)type);
            if (rewrittenType.isIntType()) {
                return;
            }
            FeatureSplit existing = rewrittenClassToFeatureSplitMap.put(rewrittenType, (FeatureSplit)featureSplit);
            assert (existing == null || existing == featureSplit);
        });
        return new ClassToFeatureSplitMap(this.baseStartup, rewrittenClassToFeatureSplitMap, this.representativeStringsForFeatureSplit);
    }

    public ClassToFeatureSplitMap withoutPrunedItems(PrunedItems prunedItems) {
        IdentityHashMap<DexType, FeatureSplit> rewrittenClassToFeatureSplitMap = new IdentityHashMap<DexType, FeatureSplit>();
        this.classToFeatureSplitMap.forEach((type, featureSplit) -> {
            if (!prunedItems.getRemovedClasses().contains(type)) {
                rewrittenClassToFeatureSplitMap.put((DexType)type, (FeatureSplit)featureSplit);
            }
        });
        return new ClassToFeatureSplitMap(this.baseStartup, rewrittenClassToFeatureSplitMap, this.representativeStringsForFeatureSplit);
    }
}

