/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.features;

import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.ProgramResourceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FeatureSplitConfiguration {
    private final List<FeatureSplit> featureSplits;

    public FeatureSplitConfiguration(List<FeatureSplit> featureSplits) {
        this.featureSplits = featureSplits;
    }

    public Collection<DataResourceProvidersAndConsumer> getDataResourceProvidersAndConsumers() {
        ArrayList<DataResourceProvidersAndConsumer> result = new ArrayList<DataResourceProvidersAndConsumer>();
        for (FeatureSplit featureSplit : this.featureSplits) {
            DataResourceConsumer dataResourceConsumer = featureSplit.getProgramConsumer().getDataResourceConsumer();
            if (dataResourceConsumer == null) continue;
            HashSet<DataResourceProvider> dataResourceProviders = new HashSet<DataResourceProvider>();
            for (ProgramResourceProvider programResourceProvider : featureSplit.getProgramResourceProviders()) {
                DataResourceProvider dataResourceProvider = programResourceProvider.getDataResourceProvider();
                if (dataResourceProvider == null) continue;
                dataResourceProviders.add(dataResourceProvider);
            }
            if (dataResourceProviders.isEmpty()) continue;
            result.add(new DataResourceProvidersAndConsumer(dataResourceProviders, dataResourceConsumer));
        }
        return result;
    }

    public List<FeatureSplit> getFeatureSplits() {
        return this.featureSplits;
    }

    public static class DataResourceProvidersAndConsumer {
        private final Set<DataResourceProvider> providers;
        private final DataResourceConsumer consumer;

        public DataResourceProvidersAndConsumer(Set<DataResourceProvider> providers, DataResourceConsumer consumer) {
            this.providers = providers;
            this.consumer = consumer;
        }

        public Set<DataResourceProvider> getProviders() {
            return this.providers;
        }

        public DataResourceConsumer getConsumer() {
            return this.consumer;
        }
    }
}

