/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class AbstractAccessContexts {
    public static EmptyAccessContexts empty() {
        return EmptyAccessContexts.getInstance();
    }

    public static UnknownAccessContexts unknown() {
        return UnknownAccessContexts.getInstance();
    }

    abstract void flattenAccessContexts(DexField var1);

    abstract void forEachAccessContext(Consumer<ProgramMethod> var1);

    abstract boolean isAccessedInMethodSatisfying(Predicate<ProgramMethod> var1);

    abstract boolean isAccessedOnlyInMethodSatisfying(Predicate<ProgramMethod> var1);

    abstract boolean isAccessedOutside(DexEncodedMethod var1);

    abstract int getNumberOfAccessContexts();

    public boolean isBottom() {
        return false;
    }

    public boolean isConcrete() {
        return false;
    }

    abstract boolean isEmpty();

    public ConcreteAccessContexts asConcrete() {
        return null;
    }

    public boolean isTop() {
        return false;
    }

    abstract AbstractAccessContexts rewrittenWithLens(DexDefinitionSupplier var1, GraphLens var2);

    public abstract AbstractAccessContexts join(AbstractAccessContexts var1);

    public static class UnknownAccessContexts
    extends AbstractAccessContexts {
        public static UnknownAccessContexts INSTANCE = new UnknownAccessContexts();

        private UnknownAccessContexts() {
        }

        public static UnknownAccessContexts getInstance() {
            return INSTANCE;
        }

        @Override
        void flattenAccessContexts(DexField field) {
        }

        @Override
        void forEachAccessContext(Consumer<ProgramMethod> consumer) {
            throw new Unreachable("Should never be iterating the access contexts when they are unknown");
        }

        @Override
        boolean isAccessedInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            return true;
        }

        @Override
        boolean isAccessedOnlyInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            return false;
        }

        @Override
        boolean isAccessedOutside(DexEncodedMethod method) {
            return true;
        }

        @Override
        int getNumberOfAccessContexts() {
            throw new Unreachable("Should never be querying the number of access contexts when they are unknown");
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isTop() {
            return true;
        }

        @Override
        AbstractAccessContexts rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
            return this;
        }

        @Override
        public AbstractAccessContexts join(AbstractAccessContexts contexts) {
            return this;
        }
    }

    public static class ConcreteAccessContexts
    extends AbstractAccessContexts {
        private final Map<DexField, ProgramMethodSet> accessesWithContexts;

        public ConcreteAccessContexts() {
            this(new IdentityHashMap<DexField, ProgramMethodSet>());
        }

        public ConcreteAccessContexts(Map<DexField, ProgramMethodSet> accessesWithContexts) {
            this.accessesWithContexts = accessesWithContexts;
        }

        void forEachAccess(Consumer<DexField> consumer, Predicate<DexField> predicate) {
            if (this.accessesWithContexts != null) {
                this.accessesWithContexts.forEach((access, contexts) -> {
                    if (predicate.test((DexField)access)) {
                        consumer.accept((DexField)access);
                    }
                });
            }
        }

        @Override
        void forEachAccessContext(Consumer<ProgramMethod> consumer) {
            ProgramMethodSet visited = ProgramMethodSet.create();
            if (this.accessesWithContexts != null) {
                for (ProgramMethodSet encodedAccessContexts : this.accessesWithContexts.values()) {
                    for (ProgramMethod encodedAccessContext : encodedAccessContexts) {
                        if (!visited.add(encodedAccessContext)) continue;
                        consumer.accept(encodedAccessContext);
                    }
                }
            }
        }

        public Map<DexField, ProgramMethodSet> getAccessesWithContexts() {
            return this.accessesWithContexts;
        }

        @Override
        int getNumberOfAccessContexts() {
            if (this.accessesWithContexts.size() == 1) {
                return this.accessesWithContexts.values().iterator().next().size();
            }
            throw new Unreachable("Should only be querying the number of access contexts after flattening");
        }

        ProgramMethod getUniqueAccessContext() {
            ProgramMethodSet contexts;
            if (this.accessesWithContexts != null && this.accessesWithContexts.size() == 1 && (contexts = this.accessesWithContexts.values().iterator().next()).size() == 1) {
                return (ProgramMethod)contexts.iterator().next();
            }
            return null;
        }

        @Override
        void flattenAccessContexts(DexField field) {
            if (this.accessesWithContexts != null) {
                ProgramMethodSet flattenedAccessContexts = this.accessesWithContexts.computeIfAbsent(field, ignore -> ProgramMethodSet.create());
                this.accessesWithContexts.forEach((access, contexts) -> {
                    if (access != field) {
                        flattenedAccessContexts.addAll((ProgramMethodSet)contexts);
                    }
                });
                this.accessesWithContexts.clear();
                if (!flattenedAccessContexts.isEmpty()) {
                    this.accessesWithContexts.put(field, flattenedAccessContexts);
                }
                assert (this.accessesWithContexts.size() <= 1);
            }
        }

        @Override
        public boolean isAccessedInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            for (ProgramMethodSet encodedWriteContexts : this.accessesWithContexts.values()) {
                for (ProgramMethod encodedWriteContext : encodedWriteContexts) {
                    if (!predicate.test(encodedWriteContext)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isAccessedOnlyInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            for (ProgramMethodSet encodedWriteContexts : this.accessesWithContexts.values()) {
                for (ProgramMethod encodedWriteContext : encodedWriteContexts) {
                    if (predicate.test(encodedWriteContext)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isAccessedOutside(DexEncodedMethod method) {
            for (ProgramMethodSet encodedWriteContexts : this.accessesWithContexts.values()) {
                for (ProgramMethod encodedWriteContext : encodedWriteContexts) {
                    if (encodedWriteContext.getDefinition() == method) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isConcrete() {
            return true;
        }

        @Override
        public ConcreteAccessContexts asConcrete() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.accessesWithContexts.isEmpty();
        }

        public boolean recordAccess(DexField access, ProgramMethod context) {
            return this.accessesWithContexts.computeIfAbsent(access, ignore -> ProgramMethodSet.create()).add(context);
        }

        @Override
        ConcreteAccessContexts rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
            IdentityHashMap<DexField, ProgramMethodSet> newAccessesWithContexts = new IdentityHashMap<DexField, ProgramMethodSet>();
            this.accessesWithContexts.forEach((access, contexts) -> {
                ProgramMethodSet newContexts = newAccessesWithContexts.computeIfAbsent(lens.lookupField((DexField)access), ignore -> ProgramMethodSet.create());
                for (ProgramMethod context : contexts) {
                    ProgramMethod newContext = lens.mapProgramMethod(context, definitions);
                    assert (newContext != null) : "Unable to map context: " + context.toSourceString();
                    newContexts.add(newContext);
                }
            });
            return new ConcreteAccessContexts(newAccessesWithContexts);
        }

        @Override
        public AbstractAccessContexts join(AbstractAccessContexts contexts) {
            if (contexts.isEmpty()) {
                return this;
            }
            if (contexts.isTop()) {
                return contexts;
            }
            IdentityHashMap<DexField, ProgramMethodSet> newAccessesWithContexts = new IdentityHashMap<DexField, ProgramMethodSet>();
            this.accessesWithContexts.forEach((field, methodSet) -> newAccessesWithContexts.put((DexField)field, ProgramMethodSet.create(methodSet)));
            BiConsumer<DexField, ProgramMethodSet> addAllMethods = (field, methodSet) -> newAccessesWithContexts.computeIfAbsent((DexField)field, ignore -> ProgramMethodSet.create()).addAll((ProgramMethodSet)methodSet);
            contexts.asConcrete().accessesWithContexts.forEach(addAllMethods);
            return new ConcreteAccessContexts(newAccessesWithContexts);
        }
    }

    public static class EmptyAccessContexts
    extends AbstractAccessContexts {
        public static EmptyAccessContexts INSTANCE = new EmptyAccessContexts();

        private EmptyAccessContexts() {
        }

        public static EmptyAccessContexts getInstance() {
            return INSTANCE;
        }

        @Override
        void flattenAccessContexts(DexField field) {
        }

        @Override
        void forEachAccessContext(Consumer<ProgramMethod> consumer) {
        }

        @Override
        boolean isAccessedInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            return false;
        }

        @Override
        boolean isAccessedOnlyInMethodSatisfying(Predicate<ProgramMethod> predicate) {
            return true;
        }

        @Override
        boolean isAccessedOutside(DexEncodedMethod method) {
            return false;
        }

        @Override
        int getNumberOfAccessContexts() {
            return 0;
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        AbstractAccessContexts rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
            return this;
        }

        @Override
        public AbstractAccessContexts join(AbstractAccessContexts contexts) {
            return contexts;
        }
    }
}

