/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.InternalOptions;

public abstract class ApplicationReaderMap {
    public static ApplicationReaderMap INSTANCE;

    public static ApplicationReaderMap getInstance(InternalOptions options) {
        if (options.shouldDesugarRecords() && !options.testing.disableRecordApplicationReaderMap) {
            return new RecordMap(options.dexItemFactory());
        }
        return new EmptyMap();
    }

    public abstract String getDescriptor(String var1);

    public abstract DexType getType(DexType var1);

    public abstract DexType getInvertedType(DexType var1);

    public static class RecordMap
    extends ApplicationReaderMap {
        private final DexItemFactory factory;

        public RecordMap(DexItemFactory factory) {
            this.factory = factory;
        }

        @Override
        public String getDescriptor(String descriptor) {
            return descriptor.equals("Lcom/android/tools/r8/RecordTag;") ? "Ljava/lang/Record;" : descriptor;
        }

        @Override
        public DexType getType(DexType type) {
            return type == this.factory.recordTagType ? this.factory.recordType : type;
        }

        @Override
        public DexType getInvertedType(DexType type) {
            return type == this.factory.recordType ? this.factory.recordTagType : type;
        }
    }

    public static class EmptyMap
    extends ApplicationReaderMap {
        @Override
        public String getDescriptor(String descriptor) {
            return descriptor;
        }

        @Override
        public DexType getType(DexType type) {
            return type;
        }

        @Override
        public DexType getInvertedType(DexType type) {
            return type;
        }
    }
}

