/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public final class AppliedGraphLens
extends GraphLens.NonIdentityGraphLens {
    private final MutableBidirectionalManyToOneRepresentativeMap<DexType, DexType> renamedTypeNames = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
    private final BiMap<DexField, DexField> originalFieldSignatures = HashBiMap.create();
    private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();
    private final Map<DexMethod, DexMethod> extraOriginalMethodSignatures = new IdentityHashMap<DexMethod, DexMethod>();

    public AppliedGraphLens(AppView<? extends AppInfoWithClassHierarchy> appView) {
        super(appView.dexItemFactory(), GraphLens.getIdentityLens());
        for (DexProgramClass clazz : appView.appInfo().classes()) {
            DexMember existing;
            DexMember original;
            if (appView.graphLens().lookupType(clazz.getType()) != clazz.getType()) continue;
            this.recordOriginalTypeNames(clazz, appView);
            for (DexEncodedField encodedField : clazz.fields()) {
                DexField field = (DexField)encodedField.getReference();
                original = appView.graphLens().getOriginalFieldSignature(field);
                if (original == field) continue;
                existing = this.originalFieldSignatures.forcePut(field, (DexField)original);
                assert (existing == null);
            }
            for (DexEncodedMethod encodedMethod : clazz.methods()) {
                DexMethod method = (DexMethod)encodedMethod.getReference();
                original = appView.graphLens().getOriginalMethodSignature(method);
                existing = (DexMethod)this.originalMethodSignatures.inverse().get(original);
                if (existing == null) {
                    this.originalMethodSignatures.put(method, (DexMethod)original);
                    continue;
                }
                DexMethod renamed = appView.graphLens().getRenamedMethodSignature((DexMethod)original);
                if (renamed == existing) {
                    this.extraOriginalMethodSignatures.put(method, (DexMethod)original);
                    continue;
                }
                this.originalMethodSignatures.forcePut(method, (DexMethod)original);
                this.extraOriginalMethodSignatures.put((DexMethod)existing, (DexMethod)original);
            }
        }
        MapUtils.removeIdentityMappings(this.originalMethodSignatures);
        MapUtils.removeIdentityMappings(this.extraOriginalMethodSignatures);
    }

    private void recordOriginalTypeNames(DexProgramClass clazz, AppView<? extends AppInfoWithClassHierarchy> appView) {
        boolean isIdentity;
        DexType type = clazz.getType();
        ArrayList<DexType> originalTypes = Lists.newArrayList(appView.graphLens().getOriginalTypes(type));
        boolean bl = isIdentity = originalTypes.size() == 1 && originalTypes.get(0) == type;
        if (!isIdentity) {
            originalTypes.forEach(originalType -> {
                assert (!this.renamedTypeNames.containsKey((DexType)originalType));
                this.renamedTypeNames.put((DexType)originalType, type);
            });
            this.renamedTypeNames.setRepresentative(type, appView.graphLens().getOriginalType(type));
        }
    }

    @Override
    public boolean isAppliedLens() {
        return true;
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.renamedTypeNames.getRepresentativeKeyOrDefault(type, type);
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        Set originalTypes = this.renamedTypeNames.getKeys(type);
        return originalTypes.isEmpty() ? ImmutableList.of(type) : originalTypes;
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        return this.originalFieldSignatures.getOrDefault(field, field);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
        if (this == codeLens) {
            return originalField;
        }
        return this.originalFieldSignatures.inverse().getOrDefault(originalField, originalField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        return this != applied ? this.originalMethodSignatures.inverse().getOrDefault(originalMethod, originalMethod) : originalMethod;
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        return GraphLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
    }

    @Override
    public DexType internalDescribeLookupClassType(DexType previous) {
        return this.renamedTypeNames.getOrDefault(previous, previous);
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        return previous;
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        return previous;
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        if (this.extraOriginalMethodSignatures.containsKey(method)) {
            return this.extraOriginalMethodSignatures.get(method);
        }
        return this.originalMethodSignatures.getOrDefault(method, method);
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return this.originalMethodSignatures.inverse().getOrDefault(method, method);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return true;
    }

    @Override
    public boolean hasCodeRewritings() {
        return false;
    }
}

