/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassHierarchyTraversal;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.SubtypingInfo;
import java.util.function.Function;

public class BottomUpClassHierarchyTraversal<T extends DexClass>
extends ClassHierarchyTraversal<T, BottomUpClassHierarchyTraversal<T>> {
    private final Function<DexType, Iterable<DexType>> immediateSubtypesProvider;

    private BottomUpClassHierarchyTraversal(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, Iterable<DexType>> immediateSubtypesProvider, ClassHierarchyTraversal.Scope scope) {
        super(appView, scope);
        this.immediateSubtypesProvider = immediateSubtypesProvider;
    }

    public static BottomUpClassHierarchyTraversal<DexClass> forAllClasses(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo) {
        return new BottomUpClassHierarchyTraversal<DexClass>(appView, subtypingInfo::allImmediateSubtypes, ClassHierarchyTraversal.Scope.ALL_CLASSES);
    }

    public static BottomUpClassHierarchyTraversal<DexProgramClass> forProgramClasses(AppView<? extends AppInfoWithClassHierarchy> appView, SubtypingInfo subtypingInfo) {
        return BottomUpClassHierarchyTraversal.forProgramClasses(appView, subtypingInfo::allImmediateSubtypes);
    }

    public static BottomUpClassHierarchyTraversal<DexProgramClass> forProgramClasses(AppView<? extends AppInfoWithClassHierarchy> appView, Function<DexType, Iterable<DexType>> immediateSubtypesProvider) {
        return new BottomUpClassHierarchyTraversal<DexProgramClass>(appView, immediateSubtypesProvider, ClassHierarchyTraversal.Scope.ONLY_PROGRAM_CLASSES);
    }

    @Override
    BottomUpClassHierarchyTraversal<T> self() {
        return this;
    }

    @Override
    void addDependentsToWorklist(DexClass clazz) {
        DexClass clazzWithTypeT = clazz;
        if (this.excludeInterfaces && clazzWithTypeT.isInterface()) {
            return;
        }
        if (this.visited.contains(clazzWithTypeT)) {
            return;
        }
        this.worklist.addFirst(clazzWithTypeT);
        for (DexType subtype : this.immediateSubtypesProvider.apply(clazz.getType())) {
            DexClass definition = this.definitionSupplier.contextIndependentDefinitionFor(subtype);
            if (definition == null || this.scope == ClassHierarchyTraversal.Scope.ONLY_PROGRAM_CLASSES && !definition.isProgramClass()) continue;
            this.addDependentsToWorklist(definition);
        }
    }
}

