/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.graph.AccessFlags;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ClassAccessFlags
extends AccessFlags<ClassAccessFlags> {
    private static final int SHARED_FLAGS = 30239;
    private static final int DEX_FLAGS = 30239;
    private static final int CF_FLAGS = 95807;

    private ClassAccessFlags(int flags) {
        this(flags, flags);
    }

    private ClassAccessFlags(int originalFlags, int modifiedFlags) {
        super(originalFlags, modifiedFlags);
    }

    public static ClassAccessFlags createPublicFinalSynthetic() {
        return new ClassAccessFlags(4113);
    }

    public static ClassAccessFlags fromSharedAccessFlags(int access) {
        assert ((access & 0x761F) == access);
        return ClassAccessFlags.fromDexAccessFlags(access);
    }

    public static ClassAccessFlags fromDexAccessFlags(int access) {
        return new ClassAccessFlags(access & 0x761F);
    }

    public static ClassAccessFlags fromCfAccessFlags(int access) {
        return new ClassAccessFlags(access & 0x1763F);
    }

    private boolean isClass() {
        return !this.isInterface() && !this.isAnnotation() && !this.isEnum();
    }

    @Override
    protected List<String> getNames() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getNames())).add("interface")).add("abstract")).add("annotation")).add("enum")).add("super")).add("record")).build();
    }

    @Override
    protected List<BooleanSupplier> getPredicates() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getPredicates())).add(this::isInterface)).add(this::isAbstract)).add(this::isAnnotation)).add(this::isEnum)).add(this::isSuper)).add(this::isRecord)).build();
    }

    @Override
    public ClassAccessFlags copy() {
        return new ClassAccessFlags(this.originalFlags, this.modifiedFlags);
    }

    @Override
    public ClassAccessFlags self() {
        return this;
    }

    @Override
    public int getAsCfAccessFlags() {
        assert (!this.isInterface() || this.isAbstract());
        assert (!this.isInterface() || !this.isSuper());
        assert (!this.isInterface() || !this.isFinal());
        assert (!this.isInterface() || !this.isEnum());
        return this.materialize();
    }

    @Override
    public int getAsDexAccessFlags() {
        int flags = this.materialize() & 0xFFFFFFDF & 0xFFFEFFFF;
        if (this.isInterface()) {
            return flags | 0x400;
        }
        return flags;
    }

    @Override
    public ClassAccessFlags asClassAccessFlags() {
        return this;
    }

    public boolean areValid(CfVersion version, boolean isPackageInfo) {
        if (this.isInterface()) {
            if (version.isGreaterThanOrEqualTo(CfVersion.V9) && this.isSuper()) {
                return false;
            }
            if (version.isGreaterThan(Constants.CORRESPONDING_CLASS_FILE_VERSION) && !this.isAbstract() && !isPackageInfo) {
                return false;
            }
            return !this.isFinal() && !this.isEnum();
        }
        return !this.isAnnotation() && (!this.isFinal() || !this.isAbstract());
    }

    public boolean isInterface() {
        return this.isSet(512);
    }

    public void setInterface() {
        this.set(512);
    }

    public void unsetInterface() {
        this.unset(512);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void demoteFromAbstract() {
        this.demote(1024);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public void unsetAbstract() {
        this.unset(1024);
    }

    public boolean isAnnotation() {
        return this.isSet(8192);
    }

    public void setAnnotation() {
        this.set(8192);
    }

    public void unsetAnnotation() {
        this.unset(8192);
    }

    public boolean isEnum() {
        return this.isSet(16384);
    }

    public void setEnum() {
        this.set(16384);
    }

    public boolean isRecord() {
        return this.isSet(65536);
    }

    public void setRecord() {
        this.set(65536);
    }

    public void unsetRecord() {
        this.unset(65536);
    }

    public boolean isSuper() {
        return this.isSet(32);
    }

    public void setSuper() {
        this.set(32);
    }

    public void unsetSuper() {
        this.unset(32);
    }
}

