/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import java.util.ArrayList;
import java.util.List;

public class DexAnnotationDirectory
extends DexItem {
    private final DexProgramClass clazz;
    private final List<DexEncodedMethod> methodAnnotations;
    private final List<DexEncodedMethod> parameterAnnotations;
    private final List<DexEncodedField> fieldAnnotations;
    private final boolean classHasOnlyInternalizableAnnotations;

    public DexAnnotationDirectory(DexProgramClass clazz) {
        this.clazz = clazz;
        this.classHasOnlyInternalizableAnnotations = clazz.hasOnlyInternalizableAnnotations();
        this.methodAnnotations = new ArrayList<DexEncodedMethod>();
        this.parameterAnnotations = new ArrayList<DexEncodedMethod>();
        this.fieldAnnotations = new ArrayList<DexEncodedField>();
        clazz.getMethodCollection().forEachMethod(method -> {
            if (!method.annotations().isEmpty()) {
                this.methodAnnotations.add((DexEncodedMethod)method);
            }
            if (!method.parameterAnnotationsList.isEmpty()) {
                this.parameterAnnotations.add((DexEncodedMethod)method);
            }
        });
        for (DexEncodedField field : clazz.fields()) {
            if (field.annotations().isEmpty()) continue;
            this.fieldAnnotations.add(field);
        }
    }

    public DexAnnotationSet getClazzAnnotations() {
        return this.clazz.annotations();
    }

    public List<DexEncodedMethod> sortMethodAnnotations(CompareToVisitor visitor) {
        this.methodAnnotations.sort((a, b) -> ((DexMethod)a.getReference()).acceptCompareTo((DexMethod)b.getReference(), visitor));
        return this.methodAnnotations;
    }

    public List<DexEncodedMethod> sortParameterAnnotations(CompareToVisitor visitor) {
        this.parameterAnnotations.sort((a, b) -> ((DexMethod)a.getReference()).acceptCompareTo((DexMethod)b.getReference(), visitor));
        return this.parameterAnnotations;
    }

    public List<DexEncodedField> sortFieldAnnotations(CompareToVisitor visitor) {
        this.fieldAnnotations.sort((a, b) -> ((DexField)a.getReference()).acceptCompareTo((DexField)b.getReference(), visitor));
        return this.fieldAnnotations;
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof DexAnnotationDirectory)) {
            return false;
        }
        if (this.classHasOnlyInternalizableAnnotations) {
            DexAnnotationDirectory other = (DexAnnotationDirectory)obj;
            if (!other.clazz.hasOnlyInternalizableAnnotations()) {
                return false;
            }
            return this.clazz.annotations().equals(other.clazz.annotations());
        }
        return super.equals(obj);
    }

    public final int hashCode() {
        if (this.classHasOnlyInternalizableAnnotations) {
            return this.clazz.annotations().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection collection) {
        throw new Unreachable();
    }
}

