/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public abstract class DexByteCodeWriter {
    final DexApplication application;
    final InternalOptions options;

    DexByteCodeWriter(DexApplication application, InternalOptions options) {
        this.application = application;
        this.options = options;
    }

    private static void ensureParentExists(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static OutputStreamProvider oneFilePerClass(ClassNameMapper classNameMapper, Path path, String fileEnding) {
        return clazz -> {
            String className = DescriptorUtils.descriptorToJavaType(clazz.type.toDescriptorString(), classNameMapper);
            Path classOutput = path.resolve(className.replace('.', File.separatorChar) + fileEnding);
            DexByteCodeWriter.ensureParentExists(classOutput);
            return new PrintStream(Files.newOutputStream(classOutput, new OpenOption[0]));
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anyMethodMatches(DexClass clazz) {
        if (!this.options.hasMethodsFilter()) return true;
        if (!clazz.getMethodCollection().hasMethods(this.options::methodMatchesFilter)) return false;
        return true;
    }

    private void writeClass(DexProgramClass clazz, PrintStream ps) {
        this.writeClassHeader(clazz, ps);
        this.writeFieldsHeader(clazz, ps);
        clazz.forEachField(field -> this.writeField((DexEncodedField)field, ps));
        this.writeFieldsFooter(clazz, ps);
        this.writeMethodsHeader(clazz, ps);
        clazz.forEachProgramMethod(method -> this.writeMethod((ProgramMethod)method, ps));
        this.writeMethodsFooter(clazz, ps);
        this.writeClassFooter(clazz, ps);
    }

    public void writeMarkers(PrintStream output) {
        List<Marker> markers = this.application.dexItemFactory.extractMarkers();
        System.out.println("Number of markers: " + markers.size());
        for (Marker marker : markers) {
            output.println(marker.toString());
        }
    }

    public void write(PrintStream output) throws IOException {
        this.writeMarkers(output);
        this.write(x -> output, x -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStreamProvider outputStreamProvider, Consumer<PrintStream> closer) throws IOException {
        Collection<DexProgramClass> classes = this.application.classesWithDeterministicOrder();
        for (DexProgramClass clazz : classes) {
            if (!this.anyMethodMatches(clazz)) continue;
            PrintStream ps = outputStreamProvider.get(clazz);
            try {
                this.writeClass(clazz, ps);
            }
            finally {
                closer.accept(ps);
            }
        }
    }

    abstract void writeClassHeader(DexProgramClass var1, PrintStream var2);

    void writeFieldsHeader(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeField(DexEncodedField var1, PrintStream var2);

    void writeFieldsFooter(DexProgramClass clazz, PrintStream ps) {
    }

    void writeMethodsHeader(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeMethod(ProgramMethod var1, PrintStream var2);

    void writeMethodsFooter(DexProgramClass clazz, PrintStream ps) {
    }

    abstract void writeClassFooter(DexProgramClass var1, PrintStream var2);

    public static interface OutputStreamProvider {
        public PrintStream get(DexClass var1) throws IOException;
    }
}

