/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.MoreObjects;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.UnmodifiableIterator;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.ClassDefinition;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureUtils;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class DexClass
extends DexDefinition
implements ClassDefinition,
ClassResolutionResult {
    public final Origin origin;
    public final DexType type;
    public final ClassAccessFlags accessFlags;
    public DexType superType;
    public DexTypeList interfaces;
    public DexString sourceFile;
    private OptionalBool isResolvable = OptionalBool.unknown();
    protected DexEncodedField[] staticFields = DexEncodedField.EMPTY_ARRAY;
    protected DexEncodedField[] instanceFields = DexEncodedField.EMPTY_ARRAY;
    protected final MethodCollection methodCollection;
    private EnclosingMethodAttribute enclosingMethod;
    private List<InnerClassAttribute> innerClasses;
    private NestHostClassAttribute nestHost;
    private List<NestMemberClassAttribute> nestMembers;
    protected GenericSignature.ClassSignature classSignature;

    public DexClass(DexString sourceFile, DexTypeList interfaces, ClassAccessFlags accessFlags, DexType superType, DexType type, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, MethodCollection.MethodCollectionFactory methodCollectionFactory, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMethod, List<InnerClassAttribute> innerClasses, GenericSignature.ClassSignature classSignature, DexAnnotationSet annotations, Origin origin, boolean skipNameValidationForTesting) {
        super(annotations);
        assert (origin != null);
        this.origin = origin;
        this.sourceFile = sourceFile;
        this.interfaces = interfaces;
        this.accessFlags = accessFlags;
        this.superType = superType;
        this.type = type;
        this.setStaticFields(staticFields);
        this.setInstanceFields(instanceFields);
        this.methodCollection = methodCollectionFactory.create(this);
        this.nestHost = nestHost;
        this.nestMembers = nestMembers;
        assert (nestMembers != null);
        this.enclosingMethod = enclosingMethod;
        this.innerClasses = innerClasses;
        assert (classSignature != null);
        this.classSignature = classSignature;
        assert (GenericSignatureUtils.verifyNoDuplicateGenericDefinitions(classSignature, annotations));
        if (type == superType) {
            throw new CompilationError("Class " + type.toString() + " cannot extend itself");
        }
        for (DexType interfaceType : interfaces.values) {
            if (type != interfaceType) continue;
            throw new CompilationError("Interface " + type.toString() + " cannot implement itself");
        }
        if (!skipNameValidationForTesting && !type.descriptor.isValidClassDescriptor()) {
            throw new CompilationError("Class descriptor '" + type.descriptor.toString() + "' cannot be represented in dex format.");
        }
    }

    private boolean verifyNoAbstractMethodsOnNonAbstractClasses(Iterable<DexEncodedMethod> methods, InternalOptions options) {
        if (options.canHaveDalvikAbstractMethodOnNonAbstractClassVerificationBug() && !this.isAbstract()) {
            for (DexEncodedMethod method : methods) {
                assert (!method.isAbstract()) : "Non-abstract method on abstract class: `" + ((DexMethod)method.getReference()).toSourceString() + "`";
            }
        }
        return true;
    }

    private boolean verifyCorrectnessOfFieldHolder(DexEncodedField field) {
        assert (field.getHolderType() == this.type) : "Expected field `" + ((DexField)field.getReference()).toSourceString() + "` to have holder `" + this.type.toSourceString() + "`";
        return true;
    }

    private boolean verifyCorrectnessOfFieldHolders(Iterable<DexEncodedField> fields) {
        for (DexEncodedField field : fields) {
            assert (this.verifyCorrectnessOfFieldHolder(field));
        }
        return true;
    }

    private boolean verifyNoDuplicateFields() {
        Set<DexField> unique = Sets.newIdentityHashSet();
        for (DexEncodedField field : this.fields()) {
            boolean changed = unique.add((DexField)field.getReference());
            assert (changed) : "Duplicate field `" + ((DexField)field.getReference()).toSourceString() + "`";
        }
        return true;
    }

    private DexClassAndField toClassFieldOrNull(DexEncodedField field) {
        return field != null ? DexClassAndField.create(this, field) : null;
    }

    private DexClassAndMethod toClassMethodOrNull(DexEncodedMethod method) {
        return method != null ? DexClassAndMethod.create(this, method) : null;
    }

    public static boolean isSignaturePolymorphicMethod(DexEncodedMethod method, DexItemFactory factory) {
        assert (method.getHolderType() == factory.methodHandleType || method.getHolderType() == factory.varHandleType);
        return method.accessFlags.isVarargs() && method.accessFlags.isNative() && ((DexMethod)method.getReference()).proto.parameters.size() == 1 && ((DexMethod)method.getReference()).proto.parameters.values[0] == factory.objectArrayType;
    }

    private <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> D lookupTarget(D[] items, R descriptor) {
        for (D entry : items) {
            if (!descriptor.match(entry)) continue;
            return entry;
        }
        return null;
    }

    private List<GenericSignature.FieldTypeSignature> applyTypeArguments(GenericSignature.ClassTypeSignature superInterfaceSignatures, List<GenericSignature.FieldTypeSignature> appliedTypeArguments) {
        ImmutableList.Builder superTypeArgumentsBuilder = ImmutableList.builder();
        if (superInterfaceSignatures.type.toSourceString().equals("java.util.Map")) {
            System.currentTimeMillis();
        }
        superInterfaceSignatures.typeArguments().forEach(typeArgument -> {
            if (typeArgument.isTypeVariableSignature()) {
                for (int i = 0; i < this.getClassSignature().getFormalTypeParameters().size(); ++i) {
                    GenericSignature.FormalTypeParameter formalTypeParameter = this.getClassSignature().getFormalTypeParameters().get(i);
                    if (!formalTypeParameter.getName().equals(typeArgument.asTypeVariableSignature().typeVariable())) continue;
                    if (i >= appliedTypeArguments.size()) {
                        assert (false);
                        continue;
                    }
                    superTypeArgumentsBuilder.add((GenericSignature.FieldTypeSignature)appliedTypeArguments.get(i));
                }
            } else {
                superTypeArgumentsBuilder.add(typeArgument);
            }
        });
        return superTypeArgumentsBuilder.build();
    }

    @Override
    public boolean hasClassResolutionResult() {
        return true;
    }

    @Override
    public void forEachClassResolutionResult(Consumer<DexClass> consumer) {
        consumer.accept(this);
    }

    @Override
    public DexClass toSingleClassWithProgramOverLibrary() {
        return this;
    }

    public abstract void accept(Consumer<DexProgramClass> var1, Consumer<DexClasspathClass> var2, Consumer<DexLibraryClass> var3);

    @Override
    public void forEachClassField(Consumer<? super DexClassAndField> consumer) {
        this.forEachClassFieldMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachClassFieldMatching(Predicate<DexEncodedField> predicate, Consumer<? super DexClassAndField> consumer) {
        this.forEachFieldMatching(predicate, field -> consumer.accept(DexClassAndField.create(this, field)));
    }

    @Override
    public void forEachClassMethod(Consumer<? super DexClassAndMethod> consumer) {
        this.forEachClassMethodMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachClassMethodMatching(Predicate<DexEncodedMethod> predicate, Consumer<? super DexClassAndMethod> consumer) {
        this.methodCollection.forEachMethodMatching(predicate, method -> consumer.accept(DexClassAndMethod.create(this, method)));
    }

    public ClassAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public DexTypeList getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(DexTypeList interfaces) {
        this.interfaces = interfaces;
    }

    public DexString getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(DexString sourceFile) {
        this.sourceFile = sourceFile;
    }

    public Iterable<DexClassAndField> classFields() {
        return Iterables.transform(this.fields(), field -> DexClassAndField.create(this, field));
    }

    public Iterable<DexEncodedField> fields() {
        return this.fields(Predicates.alwaysTrue());
    }

    public Iterable<DexEncodedField> fields(Predicate<? super DexEncodedField> predicate) {
        return Iterables.concat(Iterables.filter(Arrays.asList(this.instanceFields), predicate::test), Iterables.filter(Arrays.asList(this.staticFields), predicate::test));
    }

    public Iterable<DexEncodedMember<?, ?>> members() {
        return Iterables.concat(this.fields(), this.methods());
    }

    public Iterable<DexEncodedMember<?, ?>> members(Predicate<DexEncodedMember<?, ?>> predicate) {
        return Iterables.concat(this.fields(predicate), this.methods(predicate));
    }

    @Override
    public MethodCollection getMethodCollection() {
        return this.methodCollection;
    }

    public Iterable<DexClassAndMethod> classMethods() {
        return Iterables.transform(this.methods(), method -> DexClassAndMethod.create(this, method));
    }

    public Iterable<DexEncodedMethod> methods() {
        return this.methodCollection.methods();
    }

    public Iterable<DexEncodedMethod> methods(Predicate<? super DexEncodedMethod> predicate) {
        return this.methodCollection.methods(predicate);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public Iterable<DexEncodedMethod> directMethods() {
        return this.methodCollection.directMethods();
    }

    public Iterable<DexEncodedMethod> directMethods(Predicate<? super DexEncodedMethod> predicate) {
        return Iterables.filter(this.directMethods(), predicate::test);
    }

    public void addDirectMethod(DexEncodedMethod method) {
        this.methodCollection.addDirectMethod(method);
    }

    public void addDirectMethods(Collection<DexEncodedMethod> methods) {
        this.methodCollection.addDirectMethods(methods);
    }

    public DexEncodedMethod removeMethod(DexMethod method) {
        return this.methodCollection.removeMethod(method);
    }

    public void setDirectMethods(Collection<DexEncodedMethod> methods) {
        this.setDirectMethods(methods.toArray(DexEncodedMethod.EMPTY_ARRAY));
    }

    public void setDirectMethods(DexEncodedMethod[] methods) {
        this.methodCollection.setDirectMethods(methods);
    }

    public Iterable<DexEncodedMethod> virtualMethods() {
        return this.methodCollection.virtualMethods();
    }

    public Iterable<DexEncodedMethod> virtualMethods(Predicate<? super DexEncodedMethod> predicate) {
        return Iterables.filter(this.virtualMethods(), predicate::test);
    }

    public void addVirtualMethods(Collection<DexEncodedMethod> methods) {
        this.methodCollection.addVirtualMethods(methods);
    }

    public void setVirtualMethods(List<DexEncodedMethod> methods) {
        this.setVirtualMethods(methods.toArray(DexEncodedMethod.EMPTY_ARRAY));
    }

    public void setVirtualMethods(DexEncodedMethod[] methods) {
        this.methodCollection.setVirtualMethods(methods);
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer) {
        this.methodCollection.forEachMethod(consumer);
    }

    public List<DexEncodedMethod> allMethodsSorted() {
        return this.methodCollection.allMethodsSorted();
    }

    public void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        this.methodCollection.virtualizeMethods(privateInstanceMethods);
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        this.annotations().forEach(consumer);
        for (DexEncodedMethod method : this.methods()) {
            method.annotations().forEach(consumer);
            method.parameterAnnotationsList.forEachAnnotation(consumer);
        }
        for (DexEncodedField field : this.fields()) {
            field.annotations().forEach(consumer);
        }
    }

    public void forEachField(Consumer<DexEncodedField> consumer) {
        this.forEachFieldMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachFieldMatching(Predicate<? super DexEncodedField> predicate, Consumer<? super DexEncodedField> consumer) {
        this.fields(predicate).forEach(consumer);
    }

    public void forEachInstanceField(Consumer<DexEncodedField> consumer) {
        this.forEachInstanceFieldMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachInstanceFieldMatching(Predicate<DexEncodedField> predicate, Consumer<DexEncodedField> consumer) {
        this.instanceFields(predicate).forEach(consumer);
    }

    public void forEachStaticField(Consumer<DexEncodedField> consumer) {
        this.forEachStaticFieldMatching(Predicates.alwaysTrue(), consumer);
    }

    public void forEachStaticFieldMatching(Predicate<DexEncodedField> predicate, Consumer<DexEncodedField> consumer) {
        this.staticFields(predicate).forEach(consumer);
    }

    public TraversalContinuation<?> traverseFields(Function<DexEncodedField, TraversalContinuation<?>> fn) {
        for (DexEncodedField field : this.fields()) {
            if (!fn.apply(field).shouldBreak()) continue;
            return TraversalContinuation.doBreak();
        }
        return TraversalContinuation.doContinue();
    }

    public List<DexEncodedField> staticFields() {
        assert (this.staticFields != null);
        if (InternalOptions.assertionsEnabled()) {
            return Collections.unmodifiableList(Arrays.asList(this.staticFields));
        }
        return Arrays.asList(this.staticFields);
    }

    public Iterable<DexEncodedField> staticFields(Predicate<DexEncodedField> predicate) {
        return IterableUtils.filter(this.staticFields(), predicate);
    }

    public void appendStaticField(DexEncodedField field) {
        DexEncodedField[] newFields = new DexEncodedField[this.staticFields.length + 1];
        System.arraycopy(this.staticFields, 0, newFields, 0, this.staticFields.length);
        newFields[this.staticFields.length] = field;
        this.staticFields = newFields;
        assert (this.verifyCorrectnessOfFieldHolder(field));
        assert (this.verifyNoDuplicateFields());
    }

    public void appendStaticFields(Collection<DexEncodedField> fields) {
        DexEncodedField[] newFields = new DexEncodedField[this.staticFields.length + fields.size()];
        System.arraycopy(this.staticFields, 0, newFields, 0, this.staticFields.length);
        int i = this.staticFields.length;
        Iterator<DexEncodedField> iterator2 = fields.iterator();
        while (iterator2.hasNext()) {
            DexEncodedField field;
            newFields[i] = field = iterator2.next();
            ++i;
        }
        this.staticFields = newFields;
        assert (this.verifyCorrectnessOfFieldHolders(fields));
        assert (this.verifyNoDuplicateFields());
    }

    public DexEncodedField[] clearStaticFields() {
        DexEncodedField[] previousFields = this.staticFields;
        this.setStaticFields(DexEncodedField.EMPTY_ARRAY);
        return previousFields;
    }

    public void removeStaticField(int index) {
        DexEncodedField[] newFields = new DexEncodedField[this.staticFields.length - 1];
        System.arraycopy(this.staticFields, 0, newFields, 0, index);
        System.arraycopy(this.staticFields, index + 1, newFields, index, this.staticFields.length - index - 1);
        this.staticFields = newFields;
    }

    public void setStaticField(int index, DexEncodedField field) {
        this.staticFields[index] = field;
        assert (this.verifyCorrectnessOfFieldHolder(field));
        assert (this.verifyNoDuplicateFields());
    }

    public void setStaticFields(DexEncodedField[] fields) {
        this.staticFields = MoreObjects.firstNonNull(fields, DexEncodedField.EMPTY_ARRAY);
        assert (this.verifyCorrectnessOfFieldHolders(this.staticFields()));
        assert (this.verifyNoDuplicateFields());
    }

    public void setStaticFields(Collection<DexEncodedField> fields) {
        this.setStaticFields(fields.toArray(DexEncodedField.EMPTY_ARRAY));
    }

    public boolean definesStaticField(DexField field) {
        for (DexEncodedField encodedField : this.staticFields()) {
            if (encodedField.getReference() != field) continue;
            return true;
        }
        return false;
    }

    public List<DexEncodedField> instanceFields() {
        assert (this.instanceFields != null);
        if (InternalOptions.assertionsEnabled()) {
            return Collections.unmodifiableList(Arrays.asList(this.instanceFields));
        }
        return Arrays.asList(this.instanceFields);
    }

    public Iterable<DexEncodedField> instanceFields(Predicate<? super DexEncodedField> predicate) {
        return Iterables.filter(Arrays.asList(this.instanceFields), predicate::test);
    }

    public void appendInstanceField(DexEncodedField field) {
        DexEncodedField[] newFields = new DexEncodedField[this.instanceFields.length + 1];
        System.arraycopy(this.instanceFields, 0, newFields, 0, this.instanceFields.length);
        newFields[this.instanceFields.length] = field;
        this.instanceFields = newFields;
        assert (this.verifyCorrectnessOfFieldHolder(field));
        assert (this.verifyNoDuplicateFields());
    }

    public void appendInstanceFields(Collection<DexEncodedField> fields) {
        DexEncodedField[] newFields = new DexEncodedField[this.instanceFields.length + fields.size()];
        System.arraycopy(this.instanceFields, 0, newFields, 0, this.instanceFields.length);
        int i = this.instanceFields.length;
        Iterator<DexEncodedField> iterator2 = fields.iterator();
        while (iterator2.hasNext()) {
            DexEncodedField field;
            newFields[i] = field = iterator2.next();
            ++i;
        }
        this.instanceFields = newFields;
        assert (this.verifyCorrectnessOfFieldHolders(fields));
        assert (this.verifyNoDuplicateFields());
    }

    public void removeInstanceField(int index) {
        DexEncodedField[] newFields = new DexEncodedField[this.instanceFields.length - 1];
        System.arraycopy(this.instanceFields, 0, newFields, 0, index);
        System.arraycopy(this.instanceFields, index + 1, newFields, index, this.instanceFields.length - index - 1);
        this.instanceFields = newFields;
    }

    public void setInstanceField(int index, DexEncodedField field) {
        this.instanceFields[index] = field;
        assert (this.verifyCorrectnessOfFieldHolder(field));
        assert (this.verifyNoDuplicateFields());
    }

    public void setInstanceFields(DexEncodedField[] fields) {
        this.instanceFields = MoreObjects.firstNonNull(fields, DexEncodedField.EMPTY_ARRAY);
        assert (this.verifyCorrectnessOfFieldHolders(this.instanceFields()));
        assert (this.verifyNoDuplicateFields());
    }

    public DexEncodedField[] clearInstanceFields() {
        DexEncodedField[] previousFields = this.instanceFields;
        this.instanceFields = DexEncodedField.EMPTY_ARRAY;
        return previousFields;
    }

    public DexEncodedField lookupStaticField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.staticFields, field);
    }

    public DexEncodedField lookupInstanceField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.instanceFields, field);
    }

    public DexField lookupUniqueInstanceFieldWithName(DexString name) {
        DexField field = null;
        for (DexEncodedField encodedField : this.instanceFields()) {
            if (((DexField)encodedField.getReference()).name != name) continue;
            if (field != null) {
                return null;
            }
            field = (DexField)encodedField.getReference();
        }
        return field;
    }

    public DexClassAndField lookupClassField(DexField field) {
        return this.toClassFieldOrNull(this.lookupField(field));
    }

    public DexEncodedField lookupField(DexField field) {
        DexEncodedField result = this.lookupInstanceField(field);
        return result == null ? this.lookupStaticField(field) : result;
    }

    public DexEncodedMethod lookupDirectMethod(DexMethod method) {
        return this.methodCollection.getDirectMethod(method);
    }

    public DexEncodedMethod lookupDirectMethod(Predicate<DexEncodedMethod> predicate) {
        return this.methodCollection.getDirectMethod(predicate);
    }

    public DexEncodedMethod lookupVirtualMethod(DexMethod method) {
        return this.methodCollection.getVirtualMethod(method);
    }

    public DexEncodedMethod lookupVirtualMethod(Predicate<DexEncodedMethod> predicate) {
        return this.methodCollection.getVirtualMethod(predicate);
    }

    public <D extends DexEncodedMember<D, R>, R extends DexMember<D, R>> D lookupMember(DexMember<D, R> member) {
        DexEncodedMember definition = member.isDexField() ? this.lookupField(member.asDexField()) : this.lookupMethod(member.asDexMethod());
        return (D)definition;
    }

    public DexClassAndMethod lookupClassMethod(DexMethod method) {
        return this.toClassMethodOrNull(this.methodCollection.getMethod(method));
    }

    public DexEncodedMethod lookupMethod(DexMethod method) {
        return this.methodCollection.getMethod(method);
    }

    public DexEncodedMethod lookupMethod(DexProto methodProto, DexString methodName) {
        return this.methodCollection.getMethod(methodProto, methodName);
    }

    public DexEncodedMethod lookupMethod(Predicate<DexEncodedMethod> predicate) {
        return this.methodCollection.getMethod(predicate);
    }

    public DexEncodedMethod lookupSignaturePolymorphicMethod(DexString methodName, DexItemFactory factory) {
        if (this.type != factory.methodHandleType && this.type != factory.varHandleType) {
            return null;
        }
        DexEncodedMethod matchingName = null;
        DexEncodedMethod signaturePolymorphicMethod = null;
        for (DexEncodedMethod method : this.virtualMethods()) {
            if (((DexMethod)method.getReference()).name != methodName) continue;
            if (matchingName != null) {
                return null;
            }
            matchingName = method;
            if (!DexClass.isSignaturePolymorphicMethod(method, factory)) continue;
            signaturePolymorphicMethod = method;
        }
        return signaturePolymorphicMethod;
    }

    public boolean canBeInstantiatedByNewInstance() {
        return !this.isAbstract() && !this.isAnnotation() && !this.isInterface();
    }

    public boolean isAbstract() {
        return this.accessFlags.isAbstract();
    }

    public boolean isAnnotation() {
        return this.accessFlags.isAnnotation();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    public boolean isEffectivelyFinal(AppView<?> appView) {
        return this.isFinal();
    }

    @Override
    public boolean isInterface() {
        return this.accessFlags.isInterface();
    }

    public boolean isEnum() {
        return this.accessFlags.isEnum();
    }

    public boolean isRecord() {
        return this.accessFlags.isRecord();
    }

    public abstract void addDependencies(MixedSectionCollection var1);

    @Override
    public DexReference getReference() {
        return this.getType();
    }

    @Override
    public DexClass asClass() {
        return this;
    }

    @Override
    public boolean isDexClass() {
        return true;
    }

    @Override
    public DexClass asDexClass() {
        return this;
    }

    @Override
    public boolean isClasspathClass() {
        return false;
    }

    @Override
    public DexClasspathClass asClasspathClass() {
        return null;
    }

    public abstract boolean isNotProgramClass();

    @Override
    public boolean isLibraryClass() {
        return false;
    }

    @Override
    public DexLibraryClass asLibraryClass() {
        return null;
    }

    public boolean isPrivate() {
        return this.accessFlags.isPrivate();
    }

    public boolean isPublic() {
        return this.accessFlags.isPublic();
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        return false;
    }

    public DexEncodedMethod getClassInitializer() {
        DexEncodedMethod classInitializer = this.methodCollection.getClassInitializer();
        assert (classInitializer != DexEncodedMethod.SENTINEL);
        return classInitializer;
    }

    @Override
    public ClassReference getClassReference() {
        return Reference.classFromDescriptor(this.getType().toDescriptorString());
    }

    @Override
    public DexClass getContextClass() {
        return this;
    }

    @Override
    public DexClass getDefinition() {
        return this;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public DexType getType() {
        return this.type;
    }

    public DexType getSuperType() {
        return this.superType;
    }

    public boolean hasClassInitializer() {
        return this.getClassInitializer() != null;
    }

    public boolean hasDefaultInitializer() {
        return this.getDefaultInitializer() != null;
    }

    public DexEncodedMethod getInitializer(DexType[] parameters) {
        for (DexEncodedMethod method : this.directMethods()) {
            if (!method.isInstanceInitializer() || !Arrays.equals(((DexMethod)method.getReference()).proto.parameters.values, parameters)) continue;
            return method;
        }
        return null;
    }

    public DexEncodedMethod getDefaultInitializer() {
        return this.getInitializer(DexType.EMPTY_ARRAY);
    }

    public boolean hasMissingSuperType(AppInfoWithClassHierarchy appInfo) {
        if (this.superType != null && appInfo.isMissingOrHasMissingSuperType(this.superType)) {
            return true;
        }
        for (DexType interfaceType : this.interfaces.values) {
            if (!appInfo.isMissingOrHasMissingSuperType(interfaceType)) continue;
            return true;
        }
        return false;
    }

    public boolean isResolvable(AppView<?> appView) {
        if (this.isResolvable.isUnknown()) {
            boolean resolvable;
            if (!this.isProgramClass()) {
                resolvable = appView.dexItemFactory().libraryTypesAssumedToBePresent.contains(this.type);
            } else {
                resolvable = true;
                for (DexType supertype : this.allImmediateSupertypes()) {
                    if (!(resolvable &= supertype.isResolvable(appView))) break;
                }
            }
            this.isResolvable = OptionalBool.of(resolvable);
        }
        assert (!this.isResolvable.isUnknown());
        return this.isResolvable.isTrue();
    }

    public boolean isSerializable(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return appView.appInfo().isSerializable(this.type);
    }

    public boolean isExternalizable(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return appView.appInfo().isExternalizable(this.type);
    }

    public boolean classInitializationMayHaveSideEffects(AppView<?> appView) {
        return this.classInitializationMayHaveSideEffects(appView, Predicates.alwaysFalse());
    }

    public boolean classInitializationMayHaveSideEffects(AppView<?> appView, Predicate<DexType> ignore) {
        return this.internalClassOrInterfaceMayHaveInitializationSideEffects(appView, this, ignore, Sets.newIdentityHashSet());
    }

    public final boolean classInitializationMayHaveSideEffectsInContext(AppView<?> appView, ProgramDefinition context) {
        return this.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context.getContextType(), (DexType)type).isTrue());
    }

    abstract boolean internalClassOrInterfaceMayHaveInitializationSideEffects(AppView<?> var1, DexClass var2, Predicate<DexType> var3, Set<DexType> var4);

    public void forEachImmediateInterface(Consumer<DexType> fn) {
        for (DexType iface : this.interfaces.values) {
            fn.accept(iface);
        }
    }

    public void forEachImmediateSupertype(Consumer<DexType> fn) {
        if (this.superType != null) {
            fn.accept(this.superType);
        }
        this.forEachImmediateInterface(fn);
    }

    public void forEachImmediateSupertype(BiConsumer<DexType, Boolean> fn) {
        if (this.superType != null) {
            fn.accept(this.superType, false);
        }
        this.forEachImmediateInterface(iface -> fn.accept((DexType)iface, true));
    }

    public boolean validInterfaceSignatures() {
        return this.getClassSignature().superInterfaceSignatures().isEmpty() || this.interfaces.values.length == this.getClassSignature().superInterfaceSignatures.size();
    }

    public void forEachImmediateInterfaceWithSignature(BiConsumer<DexType, GenericSignature.ClassTypeSignature> consumer) {
        assert (this.validInterfaceSignatures());
        if (this.getClassSignature().superInterfaceSignatures().isEmpty()) {
            this.forEachImmediateInterface(superInterface -> consumer.accept((DexType)superInterface, new GenericSignature.ClassTypeSignature((DexType)superInterface)));
            return;
        }
        Iterator<DexType> interfaceIterator = Arrays.asList(this.interfaces.values).iterator();
        Iterator<GenericSignature.ClassTypeSignature> interfaceSignatureIterator = this.getClassSignature().superInterfaceSignatures().iterator();
        while (interfaceIterator.hasNext()) {
            assert (interfaceSignatureIterator.hasNext());
            DexType superInterface2 = interfaceIterator.next();
            GenericSignature.ClassTypeSignature superInterfaceSignatures = interfaceSignatureIterator.next();
            consumer.accept(superInterface2, superInterfaceSignatures);
        }
    }

    public void forEachImmediateSupertypeWithSignature(BiConsumer<DexType, GenericSignature.ClassTypeSignature> consumer) {
        if (this.superType != null) {
            consumer.accept(this.superType, this.classSignature.superClassSignature);
        }
        this.forEachImmediateInterfaceWithSignature(consumer);
    }

    public void forEachImmediateInterfaceWithAppliedTypeArguments(List<GenericSignature.FieldTypeSignature> typeArguments, BiConsumer<DexType, List<GenericSignature.FieldTypeSignature>> consumer) {
        assert (this.validInterfaceSignatures());
        if (this.getClassSignature().superInterfaceSignatures().size() == 0) {
            this.forEachImmediateInterface(superInterface -> consumer.accept((DexType)superInterface, ImmutableList.of()));
            return;
        }
        Iterator<DexType> interfaceIterator = Arrays.asList(this.interfaces.values).iterator();
        Iterator<GenericSignature.ClassTypeSignature> interfaceSignatureIterator = this.getClassSignature().superInterfaceSignatures().iterator();
        while (interfaceIterator.hasNext()) {
            assert (interfaceSignatureIterator.hasNext());
            DexType superInterface2 = interfaceIterator.next();
            GenericSignature.ClassTypeSignature superInterfaceSignatures = interfaceSignatureIterator.next();
            if (typeArguments.isEmpty() && superInterfaceSignatures.hasTypeVariableArguments()) {
                consumer.accept(superInterface2, ImmutableList.of());
                continue;
            }
            consumer.accept(superInterface2, this.applyTypeArguments(superInterfaceSignatures, typeArguments));
        }
        assert (!interfaceSignatureIterator.hasNext());
    }

    public void forEachImmediateSupertypeWithAppliedTypeArguments(List<GenericSignature.FieldTypeSignature> typeArguments, BiConsumer<DexType, List<GenericSignature.FieldTypeSignature>> consumer) {
        if (this.superType != null) {
            consumer.accept(this.superType, this.applyTypeArguments(this.getClassSignature().superClassSignature, typeArguments));
        }
        this.forEachImmediateInterfaceWithAppliedTypeArguments(typeArguments, consumer);
    }

    @Override
    public Iterable<DexType> allImmediateSupertypes() {
        UnmodifiableIterator<DexType> iterator2 = this.superType != null ? Iterators.concat(Iterators.singletonIterator(this.superType), Iterators.forArray(this.interfaces.values)) : Iterators.forArray(this.interfaces.values);
        return () -> iterator2;
    }

    public boolean definesFinalizer(DexItemFactory factory) {
        return this.lookupVirtualMethod(factory.objectMembers.finalize) != null;
    }

    public boolean defaultValuesForStaticFieldsMayTriggerAllocation() {
        return this.staticFields().stream().anyMatch(field -> field.hasExplicitStaticValue() && field.getStaticValue().mayHaveSideEffects());
    }

    public List<InnerClassAttribute> getInnerClasses() {
        return this.innerClasses;
    }

    public void setInnerClasses(List<InnerClassAttribute> innerClasses) {
        this.innerClasses = innerClasses;
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.enclosingMethod != null;
    }

    public EnclosingMethodAttribute getEnclosingMethodAttribute() {
        return this.enclosingMethod;
    }

    public void setEnclosingMethodAttribute(EnclosingMethodAttribute enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    public void clearEnclosingMethodAttribute() {
        this.enclosingMethod = null;
    }

    public void removeEnclosingMethodAttribute(Predicate<EnclosingMethodAttribute> predicate) {
        if (this.enclosingMethod != null && predicate.test(this.enclosingMethod)) {
            this.enclosingMethod = null;
        }
    }

    public void clearInnerClasses() {
        this.innerClasses.clear();
    }

    public void clearClassSignature() {
        this.classSignature = GenericSignature.ClassSignature.noSignature();
    }

    public void removeInnerClasses(Predicate<InnerClassAttribute> predicate) {
        this.innerClasses.removeIf(predicate);
    }

    public InnerClassAttribute getInnerClassAttributeForThisClass() {
        for (InnerClassAttribute innerClassAttribute : this.getInnerClasses()) {
            if (this.type != innerClassAttribute.getInner()) continue;
            return innerClassAttribute;
        }
        return null;
    }

    public void replaceInnerClassAttributeForThisClass(InnerClassAttribute newInnerClassAttribute) {
        ListIterator<InnerClassAttribute> iterator2 = this.getInnerClasses().listIterator();
        while (iterator2.hasNext()) {
            InnerClassAttribute innerClassAttribute = iterator2.next();
            if (this.type != innerClassAttribute.getInner()) continue;
            iterator2.set(newInnerClassAttribute);
            return;
        }
        throw new Unreachable();
    }

    public GenericSignature.ClassSignature getClassSignature() {
        return this.classSignature;
    }

    public void setClassSignature(GenericSignature.ClassSignature classSignature) {
        this.classSignature = classSignature;
    }

    public boolean isLocalClass() {
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        return innerClass != null && innerClass.getOuter() == null && innerClass.isNamed();
    }

    public boolean isMemberClass() {
        boolean isMember;
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        boolean bl = isMember = innerClass != null && innerClass.getOuter() != null && innerClass.isNamed();
        assert (!isMember || this.getEnclosingMethodAttribute() == null);
        return isMember;
    }

    public boolean isAnonymousClass() {
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        return innerClass != null && innerClass.isAnonymous();
    }

    public boolean isInANest() {
        return this.isNestHost() || this.isNestMember();
    }

    public void clearNestHost() {
        this.nestHost = null;
    }

    public void clearNestMembers() {
        this.nestMembers.clear();
    }

    public void setNestHost(DexType type) {
        assert (type != null);
        this.nestHost = new NestHostClassAttribute(type);
    }

    public void setNestHostAttribute(NestHostClassAttribute nestHostAttribute) {
        this.nestHost = nestHostAttribute;
    }

    public boolean isNestHost() {
        return !this.nestMembers.isEmpty();
    }

    public boolean isNestMember() {
        return this.nestHost != null;
    }

    public DexType getNestHost() {
        if (this.isNestMember()) {
            return this.nestHost.getNestHost();
        }
        if (this.isNestHost()) {
            return this.type;
        }
        return null;
    }

    public void forEachNestMember(Consumer<DexType> consumer) {
        assert (this.isNestHost());
        this.getNestMembersClassAttributes().forEach(member -> consumer.accept(member.getNestMember()));
    }

    public NestHostClassAttribute getNestHostClassAttribute() {
        return this.nestHost;
    }

    public boolean hasNestMemberAttributes() {
        return this.nestMembers != null && !this.nestMembers.isEmpty();
    }

    public List<NestMemberClassAttribute> getNestMembersClassAttributes() {
        return this.nestMembers;
    }

    public void setNestMemberAttributes(List<NestMemberClassAttribute> nestMemberAttributes) {
        this.nestMembers = nestMemberAttributes;
    }

    public void removeNestMemberAttributes(Predicate<NestMemberClassAttribute> predicate) {
        this.nestMembers.removeIf(predicate);
    }

    public abstract KotlinClassLevelInfo getKotlinInfo();

    public final String getSimpleName() {
        return this.getType().getSimpleName();
    }

    public final String getTypeName() {
        return this.getType().getTypeName();
    }

    public boolean hasStaticFields() {
        return this.staticFields.length > 0;
    }

    public boolean hasInstanceFields() {
        return this.instanceFields.length > 0;
    }

    public boolean hasInstanceFieldsDirectlyOrIndirectly(AppView<?> appView) {
        if (this.superType == null || this.type == appView.dexItemFactory().objectType) {
            return false;
        }
        if (this.hasInstanceFields()) {
            return true;
        }
        DexClass superClass = appView.definitionFor(this.superType);
        return superClass == null || superClass.hasInstanceFieldsDirectlyOrIndirectly(appView);
    }

    public List<DexEncodedField> getDirectAndIndirectInstanceFields(AppView<?> appView) {
        ArrayList<DexEncodedField> result = new ArrayList<DexEncodedField>();
        DexClass current = this;
        while (current != null && current.type != appView.dexItemFactory().objectType) {
            result.addAll(current.instanceFields());
            current = appView.definitionFor(current.superType);
        }
        return result;
    }

    public boolean isValid(InternalOptions options) {
        assert (this.verifyNoAbstractMethodsOnNonAbstractClasses(this.virtualMethods(), options));
        assert (!this.isInterface() || !this.getMethodCollection().hasVirtualMethods(DexEncodedMethod::isFinal));
        assert (this.verifyCorrectnessOfFieldHolders(this.fields()));
        assert (this.verifyNoDuplicateFields());
        assert (this.methodCollection.verify());
        return true;
    }

    public boolean hasStaticSynchronizedMethods() {
        for (DexEncodedMethod encodedMethod : this.directMethods()) {
            if (!encodedMethod.isStatic() || !encodedMethod.isSynchronized()) continue;
            return true;
        }
        return false;
    }

    public static interface FieldSetter {
        public void setField(int var1, DexEncodedField var2);
    }
}

