/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.DebugBytecodeWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexDebugEventVisitor;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.utils.Int2StructuralItemArrayMap;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Objects;

public abstract class DexDebugEvent
extends DexItem
implements StructuralItem<DexDebugEvent> {
    private static final int DBG_SET_INLINE_FRAME_COMPARE_ID = 256;
    private static final int DBG_SET_OUTLINE_FRAME_COMPARE_ID = 257;
    private static final int DBG_SET_OUTLINE_CALLER_COMPARE_ID = 258;
    public static final DexDebugEvent[] EMPTY_ARRAY = new DexDebugEvent[0];

    public void collectIndexedItems(IndexedItemCollection collection, GraphLens graphLens) {
    }

    @Override
    public void collectMixedSectionItems(MixedSectionCollection collection) {
    }

    public abstract String toString();

    @Override
    public abstract int hashCode();

    @Override
    public final boolean equals(Object other) {
        return other instanceof DexDebugEvent && this.compareTo((DexDebugEvent)other) == 0;
    }

    abstract int getCompareToId();

    abstract int internalAcceptCompareTo(DexDebugEvent var1, CompareToVisitor var2);

    abstract void internalAcceptHashing(HashingVisitor var1);

    @Override
    public DexDebugEvent self() {
        return this;
    }

    @Override
    public StructuralMapping<DexDebugEvent> getStructuralMapping() {
        throw new Unreachable();
    }

    @Override
    public final int acceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
        int diff = visitor.visitInt(this.getCompareToId(), other.getCompareToId());
        return diff != 0 ? diff : this.internalAcceptCompareTo(other, visitor);
    }

    @Override
    public final void acceptHashing(HashingVisitor visitor) {
        visitor.visitInt(this.getCompareToId());
        this.internalAcceptHashing(visitor);
    }

    public final void writeOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
        assert (this.isWritableEvent());
        this.internalWriteOn(writer, mapping, graphLens);
    }

    boolean isWritableEvent() {
        return false;
    }

    void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
        throw new Unreachable();
    }

    public abstract void accept(DexDebugEventVisitor var1);

    public boolean isSetInlineFrame() {
        return false;
    }

    public boolean isSetOutlineFrame() {
        return false;
    }

    public boolean isSetOutlineCallerFrame() {
        return false;
    }

    public SetInlineFrame asSetInlineFrame() {
        return null;
    }

    public SetOutlineCallerFrame asSetOutlineCallerFrame() {
        return null;
    }

    public static class Default
    extends DexDebugEvent {
        final int value;

        Default(int value) {
            assert (value >= 10 && value <= 255);
            this.value = value;
        }

        static int computeSpecialOpcode(int lineDelta, int pcDelta) {
            return 10 + (lineDelta - -4) + 15 * pcDelta;
        }

        public static Default create(int lineDelta, int pcDelta) {
            return new Default(Default.computeSpecialOpcode(lineDelta, pcDelta));
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(this.value);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        public int getPCDelta() {
            int adjustedOpcode = this.value - 10;
            return adjustedOpcode / 15;
        }

        public int getLineDelta() {
            int adjustedOpcode = this.value - 10;
            return -4 + adjustedOpcode % 15;
        }

        @Override
        public String toString() {
            return String.format("DEFAULT %d (dpc %d, dline %d)", this.value, this.getPCDelta(), this.getLineDelta());
        }

        @Override
        public int hashCode() {
            return 10 + this.value * 7;
        }

        @Override
        int getCompareToId() {
            return 10;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visitInt(this.value, ((Default)other).value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.value);
        }
    }

    public static class SetOutlineCallerFrame
    extends DexDebugEvent {
        private final DexMethod outlineCallee;
        private final Int2StructuralItemArrayMap<Position> outlinePositions;

        private static void specify(StructuralSpecification<SetOutlineCallerFrame, ?> spec) {
            ((StructuralSpecification)spec.withItem(e -> e.outlineCallee)).withNullableItem(e -> e.outlinePositions);
        }

        SetOutlineCallerFrame(DexMethod outlineCallee, Int2StructuralItemArrayMap<Position> outlinePositions) {
            assert (outlineCallee != null);
            assert (!outlinePositions.isEmpty());
            this.outlineCallee = outlineCallee;
            this.outlinePositions = outlinePositions;
        }

        public DexMethod getOutlineCallee() {
            return this.outlineCallee;
        }

        public Int2StructuralItemArrayMap<Position> getOutlinePositions() {
            return this.outlinePositions;
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return String.format("SET_OUTLINE_CALLER_FRAME %s %s", this.outlineCallee, this.outlinePositions);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.outlineCallee, this.outlinePositions);
        }

        @Override
        int getCompareToId() {
            return 258;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visit(this, (SetOutlineCallerFrame)other, SetOutlineCallerFrame::specify);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visit(this, SetOutlineCallerFrame::specify);
        }

        @Override
        public boolean isSetOutlineCallerFrame() {
            return true;
        }

        @Override
        public SetOutlineCallerFrame asSetOutlineCallerFrame() {
            return this;
        }
    }

    public static class SetOutlineFrame
    extends DexDebugEvent {
        @Override
        public String toString() {
            return "SET_OUTLINE_FRAME";
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        int getCompareToId() {
            return 257;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return 0;
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class SetInlineFrame
    extends DexDebugEvent {
        final DexMethod callee;
        final Position caller;

        private static void specify(StructuralSpecification<SetInlineFrame, ?> spec) {
            ((StructuralSpecification)spec.withItem(e -> e.callee)).withNullableItem(e -> e.caller);
        }

        SetInlineFrame(DexMethod callee, Position caller) {
            assert (callee != null);
            this.callee = callee;
            this.caller = caller;
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return String.format("SET_INLINE_FRAME %s %s", this.callee, this.caller);
        }

        @Override
        public int hashCode() {
            return 31 * this.callee.hashCode() + Objects.hashCode(this.caller);
        }

        @Override
        int getCompareToId() {
            return 256;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visit(this, (SetInlineFrame)other, SetInlineFrame::specify);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visit(this, SetInlineFrame::specify);
        }

        @Override
        public boolean isSetInlineFrame() {
            return true;
        }

        @Override
        public SetInlineFrame asSetInlineFrame() {
            return this;
        }

        public boolean hasOuterPosition(DexMethod method) {
            return this.caller == null && this.callee == method || this.caller != null && this.caller.getOutermostCaller().getMethod() == method;
        }
    }

    public static class SetFile
    extends DexDebugEvent {
        DexString fileName;

        SetFile(DexString fileName) {
            this.fileName = fileName;
        }

        @Override
        boolean isWritableEvent() {
            return false;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection collection, GraphLens graphLens) {
            this.fileName.collectIndexedItems(collection);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_FILE " + this.fileName.toString();
        }

        @Override
        public int hashCode() {
            return 9 + this.fileName.hashCode() * 7;
        }

        @Override
        int getCompareToId() {
            return 9;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return this.fileName.acceptCompareTo(((SetFile)other).fileName, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            this.fileName.acceptHashing(visitor);
        }
    }

    public static class RestartLocal
    extends DexDebugEvent {
        final int registerNum;

        RestartLocal(int registerNum) {
            this.registerNum = registerNum;
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(6);
            writer.putUleb128(this.registerNum);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "RESTART_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 6 + this.registerNum * 7;
        }

        @Override
        int getCompareToId() {
            return 6;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visitInt(this.registerNum, ((RestartLocal)other).registerNum);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.registerNum);
        }
    }

    public static class EndLocal
    extends DexDebugEvent {
        final int registerNum;

        EndLocal(int registerNum) {
            this.registerNum = registerNum;
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(5);
            writer.putUleb128(this.registerNum);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "END_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 5 + this.registerNum * 7;
        }

        @Override
        int getCompareToId() {
            return 5;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visitInt(this.registerNum, ((EndLocal)other).registerNum);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.registerNum);
        }
    }

    public static class StartLocal
    extends DexDebugEvent {
        final int registerNum;
        final DexString name;
        final DexType type;
        final DexString signature;

        private static void spec(StructuralSpecification<StartLocal, ?> spec) {
            ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withInt(e -> e.registerNum)).withItem(e -> e.name)).withItem(e -> e.type)).withNullableItem(e -> e.signature);
        }

        public StartLocal(int registerNum, DexString name, DexType type, DexString signature) {
            this.registerNum = registerNum;
            this.name = name;
            this.type = type;
            this.signature = signature;
        }

        public StartLocal(int registerNum, DebugLocalInfo local) {
            this(registerNum, local.name, local.type, local.signature);
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(this.signature == null ? 3 : 4);
            writer.putUleb128(this.registerNum);
            writer.putString(this.name);
            writer.putType(graphLens.lookupType(this.type));
            if (this.signature != null) {
                writer.putString(this.signature);
            }
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection collection, GraphLens graphLens) {
            if (this.name != null) {
                this.name.collectIndexedItems(collection);
            }
            if (this.type != null) {
                DexType rewritten = graphLens.lookupType(this.type);
                rewritten.collectIndexedItems(collection);
            }
            if (this.signature != null) {
                this.signature.collectIndexedItems(collection);
            }
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "START_LOCAL " + this.registerNum;
        }

        @Override
        public int hashCode() {
            return 3 + this.registerNum * 7 + Objects.hashCode(this.name) * 13 + Objects.hashCode(this.type) * 17 + Objects.hashCode(this.signature) * 19;
        }

        @Override
        int getCompareToId() {
            return 3;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visit(this, (StartLocal)other, StartLocal::spec);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visit(this, StartLocal::spec);
        }
    }

    public static class AdvanceLine
    extends DexDebugEvent {
        final int delta;

        AdvanceLine(int delta) {
            this.delta = delta;
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(2);
            writer.putSleb128(this.delta);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "ADVANCE_LINE " + this.delta;
        }

        @Override
        public int hashCode() {
            return 2 + this.delta * 7;
        }

        @Override
        int getCompareToId() {
            return 2;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visitInt(this.delta, ((AdvanceLine)other).delta);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.delta);
        }
    }

    public static class SetEpilogueBegin
    extends DexDebugEvent {
        SetEpilogueBegin() {
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(8);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_EPILOGUE_BEGIN";
        }

        @Override
        public int hashCode() {
            return 8;
        }

        @Override
        int getCompareToId() {
            return 8;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            assert (other instanceof SetEpilogueBegin);
            return 0;
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
        }
    }

    public static class SetPrologueEnd
    extends DexDebugEvent {
        SetPrologueEnd() {
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(7);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "SET_PROLOGUE_END";
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        int getCompareToId() {
            return 7;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            assert (other instanceof SetPrologueEnd);
            return 0;
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
        }
    }

    public static class AdvancePC
    extends DexDebugEvent {
        public final int delta;

        public AdvancePC(int delta) {
            this.delta = delta;
        }

        @Override
        boolean isWritableEvent() {
            return true;
        }

        @Override
        public void internalWriteOn(DebugBytecodeWriter writer, ObjectToOffsetMapping mapping, GraphLens graphLens) {
            writer.putByte(1);
            writer.putUleb128(this.delta);
        }

        @Override
        public void accept(DexDebugEventVisitor visitor) {
            assert (this.delta >= 0);
            visitor.visit(this);
        }

        @Override
        public String toString() {
            return "ADVANCE_PC " + this.delta;
        }

        @Override
        public int hashCode() {
            return 1 + this.delta * 7;
        }

        @Override
        int getCompareToId() {
            return 1;
        }

        @Override
        int internalAcceptCompareTo(DexDebugEvent other, CompareToVisitor visitor) {
            return visitor.visitInt(this.delta, ((AdvancePC)other).delta);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.delta);
        }
    }
}

