/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public abstract class DexDefinition
extends DexItem {
    private DexAnnotationSet annotations;

    public DexDefinition(DexAnnotationSet annotations) {
        assert (annotations != null) : "Should use DexAnnotationSet.THE_EMPTY_ANNOTATIONS_SET";
        this.annotations = annotations;
    }

    private static <T> Stream<T> filter(Stream<DexDefinition> stream, Predicate<DexDefinition> pred, Function<DexDefinition, T> f) {
        return stream.filter(pred).map(f);
    }

    public static Stream<DexEncodedField> filterDexEncodedField(Stream<DexDefinition> stream) {
        return DexDefinition.filterDexEncodedField(stream, DexDefinition::asDexEncodedField);
    }

    public static <T> Stream<T> filterDexEncodedField(Stream<DexDefinition> stream, Function<DexEncodedField, T> transform) {
        return DexDefinition.filter(stream, DexDefinition::isDexEncodedField, field -> transform.apply(field.asDexEncodedField()));
    }

    public static Stream<DexEncodedMethod> filterDexEncodedMethod(Stream<DexDefinition> stream) {
        return DexDefinition.filterDexEncodedMethod(stream, DexDefinition::asDexEncodedMethod);
    }

    public static <T> Stream<T> filterDexEncodedMethod(Stream<DexDefinition> stream, Function<DexEncodedMethod, T> transform) {
        return DexDefinition.filter(stream, DexDefinition::isDexEncodedMethod, field -> transform.apply(field.asDexEncodedMethod()));
    }

    public boolean hasAnnotations() {
        return !this.annotations().isEmpty();
    }

    public boolean hasAnyAnnotations() {
        return this.hasAnnotations();
    }

    public DexAnnotationSet annotations() {
        return this.annotations;
    }

    public abstract AccessFlags<?> getAccessFlags();

    public void clearAnnotations() {
        this.setAnnotations(DexAnnotationSet.empty());
    }

    public void clearAllAnnotations() {
        this.clearAnnotations();
    }

    public void setAnnotations(DexAnnotationSet annotations) {
        this.annotations = annotations;
    }

    public void removeAnnotations(Predicate<DexAnnotation> predicate) {
        this.setAnnotations(this.annotations().removeIf(predicate));
    }

    public void rewriteAllAnnotations(BiFunction<DexAnnotation, DexAnnotation.AnnotatedKind, DexAnnotation> rewriter) {
        this.setAnnotations(this.annotations().rewrite(annotation -> (DexAnnotation)rewriter.apply((DexAnnotation)annotation, DexAnnotation.AnnotatedKind.from(this))));
    }

    public DexClass asClass() {
        return null;
    }

    public boolean isDexClass() {
        return false;
    }

    public DexClass asDexClass() {
        return null;
    }

    public boolean isProgramClass() {
        return false;
    }

    public DexProgramClass asProgramClass() {
        return null;
    }

    public boolean isDexEncodedMember() {
        return false;
    }

    public DexEncodedMember<?, ?> asDexEncodedMember() {
        return null;
    }

    public boolean isDexEncodedField() {
        return false;
    }

    public DexEncodedField asDexEncodedField() {
        return null;
    }

    public boolean isDexEncodedMethod() {
        return false;
    }

    public DexEncodedMethod asDexEncodedMethod() {
        return null;
    }

    public abstract DexReference getReference();

    public abstract boolean isStatic();

    public abstract boolean isStaticMember();

    public boolean isNotProgramDefinition(AppView<?> appView) {
        if (this.isDexClass()) {
            return this.asDexClass().isNotProgramClass();
        }
        DexClass clazz = appView.definitionFor(this.asDexEncodedMember().getHolderType());
        return clazz == null || clazz.isNotProgramClass();
    }

    public DexType getContextType() {
        return this.isDexClass() ? this.asDexClass().type : this.asDexEncodedMember().getHolderType();
    }
}

