/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureUtils;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import com.android.tools.r8.ir.optimize.info.DefaultFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.kotlin.KotlinFieldLevelInfo;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexEncodedField
extends DexEncodedMember<DexEncodedField, DexField>
implements StructuralItem<DexEncodedField> {
    public static final DexEncodedField[] EMPTY_ARRAY = new DexEncodedField[0];
    public final FieldAccessFlags accessFlags;
    private DexValue staticValue;
    private final boolean deprecated;
    private GenericSignature.FieldTypeSignature genericSignature;
    private FieldOptimizationInfo optimizationInfo = DefaultFieldOptimizationInfo.getInstance();
    private KotlinFieldLevelInfo kotlinMemberInfo = KotlinMetadataUtils.getNoKotlinInfo();
    private boolean isInlinableByJavaC = false;

    private static void specify(StructuralSpecification<DexEncodedField, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withItem(DexEncodedMember::getReference)).withItem(DexEncodedField::getAccessFlags)).withNullableItem(f -> f.staticValue)).withBool(DexEncodedField::isDeprecated)).withAssert(f -> f.genericSignature.hasNoSignature());
    }

    private DexEncodedField(DexField field, FieldAccessFlags accessFlags, GenericSignature.FieldTypeSignature genericSignature, DexAnnotationSet annotations, DexValue staticValue, ComputedApiLevel apiLevel, boolean deprecated, boolean d8R8Synthesized) {
        super(field, annotations, d8R8Synthesized, apiLevel);
        this.accessFlags = accessFlags;
        this.staticValue = staticValue;
        this.deprecated = deprecated;
        this.genericSignature = genericSignature;
        assert (genericSignature != null);
        assert (GenericSignatureUtils.verifyNoDuplicateGenericDefinitions(genericSignature, annotations));
    }

    public static Builder builder() {
        return new Builder(false);
    }

    private static Builder builder(DexEncodedField from) {
        return new Builder(from.isD8R8Synthesized(), from);
    }

    public static Builder syntheticBuilder() {
        return new Builder(true);
    }

    @Override
    public StructuralMapping<DexEncodedField> getStructuralMapping() {
        return DexEncodedField::specify;
    }

    @Override
    public DexEncodedField self() {
        return this;
    }

    public DexType type() {
        return ((DexField)this.getReference()).type;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isProgramField(DexDefinitionSupplier definitions) {
        if (((DexField)this.getReference()).holder.isClassType()) {
            DexClass clazz = definitions.definitionFor(((DexField)this.getReference()).holder);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    public FieldOptimizationInfo getOptimizationInfo() {
        return this.optimizationInfo;
    }

    @Override
    public ComputedApiLevel getApiLevel() {
        return this.getApiLevelForDefinition();
    }

    public synchronized MutableFieldOptimizationInfo getMutableOptimizationInfo() {
        MutableFieldOptimizationInfo mutableInfo = (MutableFieldOptimizationInfo)this.optimizationInfo.toMutableOptimizationInfo();
        this.optimizationInfo = mutableInfo;
        return mutableInfo;
    }

    public void setOptimizationInfo(MutableFieldOptimizationInfo info) {
        this.optimizationInfo = info;
    }

    @Override
    public KotlinFieldLevelInfo getKotlinInfo() {
        return this.kotlinMemberInfo;
    }

    @Override
    public void clearKotlinInfo() {
        this.kotlinMemberInfo = KotlinMetadataUtils.getNoKotlinInfo();
    }

    public FieldAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public void setKotlinMemberInfo(KotlinFieldLevelInfo kotlinMemberInfo) {
        assert (this.kotlinMemberInfo == KotlinMetadataUtils.getNoKotlinInfo());
        this.kotlinMemberInfo = kotlinMemberInfo;
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        this.annotations().collectMixedSectionItems(mixedItems);
    }

    public String toString() {
        return "Encoded field " + this.getReference();
    }

    @Override
    public String toSmaliString() {
        return ((DexField)this.getReference()).toSmaliString();
    }

    @Override
    public String toSourceString() {
        return ((DexField)this.getReference()).toSourceString();
    }

    public DexType getType() {
        return ((DexField)this.getReference()).getType();
    }

    public TypeElement getTypeElement(AppView<?> appView) {
        return ((DexField)this.getReference()).getTypeElement(appView);
    }

    @Override
    public boolean isDexEncodedField() {
        return true;
    }

    @Override
    public DexEncodedField asDexEncodedField() {
        return this;
    }

    public ProgramField asProgramMember(DexDefinitionSupplier definitions) {
        return this.asProgramField(definitions);
    }

    @Override
    public <T> T apply(Function<DexEncodedField, T> fieldConsumer, Function<DexEncodedMethod, T> methodConsumer) {
        return fieldConsumer.apply(this);
    }

    public ProgramField asProgramField(DexDefinitionSupplier definitions) {
        assert (this.getHolderType().isClassType());
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(definitions.definitionForHolder(this.getReference()));
        if (clazz != null) {
            return new ProgramField(clazz, this);
        }
        return null;
    }

    public boolean isEnum() {
        return this.accessFlags.isEnum();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    public boolean isPackagePrivate() {
        return this.accessFlags.isPackagePrivate();
    }

    public boolean isProtected() {
        return this.accessFlags.isProtected();
    }

    public boolean isPublic() {
        return this.accessFlags.isPublic();
    }

    @Override
    public boolean isStaticMember() {
        return this.isStatic();
    }

    public boolean isSynthetic() {
        return this.accessFlags.isSynthetic();
    }

    public boolean isVolatile() {
        return this.accessFlags.isVolatile();
    }

    public boolean hasExplicitStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue != null;
    }

    public void setStaticValue(DexValue staticValue) {
        assert (this.accessFlags.isStatic());
        assert (staticValue != null);
        this.staticValue = staticValue;
    }

    public void clearStaticValue() {
        assert (this.accessFlags.isStatic());
        this.staticValue = null;
    }

    public DexValue getStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue == null ? DexValue.defaultForType(((DexField)this.getReference()).type) : this.staticValue;
    }

    public Instruction valueAsConstInstruction(IRCode code, DebugLocalInfo local, AppView<AppInfoWithLiveness> appView) {
        boolean isWritten = appView.appInfo().isFieldWrittenByFieldPutInstruction(this);
        if (!isWritten) {
            DexValue value = this.isStatic() ? this.getStaticValue() : DexValue.defaultForType(((DexField)this.getReference()).type);
            return value.asConstInstruction(appView, code, local);
        }
        AbstractValue abstractValue = this.getOptimizationInfo().getAbstractValue();
        if (abstractValue.isSingleValue()) {
            SingleValue singleValue = abstractValue.asSingleValue();
            if (singleValue.isSingleFieldValue() && singleValue.asSingleFieldValue().getField() == this.getReference()) {
                return null;
            }
            if (singleValue.isMaterializableInContext(appView, code.context())) {
                TypeElement type = TypeElement.fromDexType(((DexField)this.getReference()).type, Nullability.maybeNull(), appView);
                return singleValue.createMaterializingInstruction(appView, code, TypeAndLocalInfoSupplier.create(type, local));
            }
        }
        if (this.accessFlags.isFinal() && this.isStatic()) {
            DexClass clazz = appView.definitionFor(((DexField)this.getReference()).holder);
            if (clazz == null || clazz.hasClassInitializer()) {
                return null;
            }
            DexValue staticValue = this.getStaticValue();
            if (!staticValue.isDefault(((DexField)this.getReference()).type)) {
                return staticValue.asConstInstruction(appView, code, local);
            }
        }
        return null;
    }

    public DexEncodedField toTypeSubstitutedField(AppView<?> appView, DexField field) {
        return this.toTypeSubstitutedField(appView, field, ConsumerUtils.emptyConsumer());
    }

    public DexEncodedField toTypeSubstitutedField(AppView<?> appView, DexField field, Consumer<Builder> consumer) {
        if (this.getReference() == field) {
            return this;
        }
        return DexEncodedField.builder(this).setField(field).disableAndroidApiLevelCheckIf(!appView.options().apiModelingOptions().enableApiCallerIdentification).apply(consumer).build();
    }

    public boolean validateDexValue(DexItemFactory factory) {
        if (!this.accessFlags.isStatic() || this.staticValue == null) {
            return true;
        }
        if (((DexField)this.getReference()).type.isPrimitiveType()) assert (this.staticValue.getType(factory) == ((DexField)this.getReference()).type) : "Static " + this.getReference() + " has invalid static value " + this.staticValue + ".";
        if (this.staticValue.isDexValueNull()) assert (((DexField)this.getReference()).type.isReferenceType()) : "Static " + this.getReference() + " has invalid null static value.";
        return true;
    }

    public GenericSignature.FieldTypeSignature getGenericSignature() {
        return this.genericSignature;
    }

    public void setGenericSignature(GenericSignature.FieldTypeSignature genericSignature) {
        assert (genericSignature != null);
        this.genericSignature = genericSignature;
    }

    @Override
    public void clearGenericSignature() {
        this.genericSignature = GenericSignature.FieldTypeSignature.noSignature();
    }

    public void markAsInlinableByJavaC() {
        this.isInlinableByJavaC = true;
    }

    public boolean getIsInlinableByJavaC() {
        return this.isInlinableByJavaC;
    }

    public boolean getOrComputeIsInlinableByJavaC(DexItemFactory dexItemFactory) {
        if (this.getIsInlinableByJavaC()) {
            return true;
        }
        if (!this.isStatic() || !this.isFinal()) {
            return false;
        }
        if (!this.hasExplicitStaticValue()) {
            return false;
        }
        if (this.getType().isPrimitiveType()) {
            return true;
        }
        if (this.getType() != dexItemFactory.stringType) {
            return false;
        }
        if (!this.getStaticValue().isDexValueString()) {
            return false;
        }
        this.markAsInlinableByJavaC();
        return true;
    }

    public static class Builder {
        private DexField field;
        private DexAnnotationSet annotations = DexAnnotationSet.empty();
        private FieldAccessFlags accessFlags;
        private GenericSignature.FieldTypeSignature genericSignature = GenericSignature.FieldTypeSignature.noSignature();
        private DexValue staticValue = null;
        private ComputedApiLevel apiLevel = ComputedApiLevel.notSet();
        private FieldOptimizationInfo optimizationInfo = DefaultFieldOptimizationInfo.getInstance();
        private boolean deprecated;
        private final boolean d8R8Synthesized;
        private Consumer<DexEncodedField> buildConsumer = ConsumerUtils.emptyConsumer();
        private boolean checkAndroidApiLevel = true;

        private Builder(boolean d8R8Synthesized) {
            this.d8R8Synthesized = d8R8Synthesized;
        }

        private Builder(boolean d8R8Synthesized, DexEncodedField from) {
            this.field = (DexField)from.getReference();
            this.accessFlags = from.accessFlags.copy();
            this.genericSignature = from.getGenericSignature();
            this.annotations = from.annotations();
            this.staticValue = from.staticValue;
            this.apiLevel = from.getApiLevel();
            this.optimizationInfo = from.optimizationInfo.isMutableOptimizationInfo() ? from.optimizationInfo.asMutableFieldOptimizationInfo().mutableCopy() : from.optimizationInfo;
            this.deprecated = from.isDeprecated();
            this.d8R8Synthesized = d8R8Synthesized;
        }

        private Builder addBuildConsumer(Consumer<DexEncodedField> consumer) {
            this.buildConsumer = this.buildConsumer.andThen(consumer);
            return this;
        }

        public Builder apply(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Builder modifyAccessFlags(Consumer<FieldAccessFlags> consumer) {
            consumer.accept(this.accessFlags);
            return this;
        }

        public Builder setAbstractValue(AbstractValue abstractValue, AppView<AppInfoWithLiveness> appView) {
            return this.addBuildConsumer(fixedUpField -> OptimizationFeedbackSimple.getInstance().recordFieldHasAbstractValue((DexEncodedField)fixedUpField, appView, abstractValue));
        }

        public Builder clearAnnotations() {
            return this.setAnnotations(DexAnnotationSet.empty());
        }

        public Builder setAnnotations(DexAnnotationSet annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder setField(DexField field) {
            this.field = field;
            return this;
        }

        public Builder setAccessFlags(FieldAccessFlags accessFlags) {
            this.accessFlags = accessFlags;
            return this;
        }

        public Builder setApiLevel(ComputedApiLevel apiLevel) {
            this.apiLevel = apiLevel;
            return this;
        }

        public Builder setGenericSignature(GenericSignature.FieldTypeSignature genericSignature) {
            this.genericSignature = genericSignature;
            return this;
        }

        public Builder setStaticValue(DexValue staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public Builder setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder disableAndroidApiLevelCheck() {
            return this.disableAndroidApiLevelCheckIf(true);
        }

        public Builder disableAndroidApiLevelCheckIf(boolean shouldDisable) {
            if (shouldDisable) {
                this.checkAndroidApiLevel = false;
            }
            return this;
        }

        public DexEncodedField build() {
            assert (this.field != null);
            assert (this.accessFlags != null);
            assert (this.genericSignature != null);
            assert (this.annotations != null);
            assert (!this.checkAndroidApiLevel || !this.apiLevel.isNotSetApiLevel());
            DexEncodedField dexEncodedField = new DexEncodedField(this.field, this.accessFlags, this.genericSignature, this.annotations, this.staticValue, this.apiLevel, this.deprecated, this.d8R8Synthesized);
            dexEncodedField.optimizationInfo = this.optimizationInfo;
            this.buildConsumer.accept(dexEncodedField);
            return dexEncodedField;
        }
    }
}

