/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfLogicalBinop;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.InstanceOf;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeStatic;
import com.android.tools.r8.code.NewInstance;
import com.android.tools.r8.code.Return;
import com.android.tools.r8.code.Throw;
import com.android.tools.r8.code.XorIntLit8;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexWritableCode;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.NestUtils;
import com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoFixer;
import com.android.tools.r8.ir.optimize.info.MutableMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.synthetic.ForwardMethodBuilder;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.Ordered;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexEncodedMethod
extends DexEncodedMember<DexEncodedMethod, DexMethod>
implements StructuralItem<DexEncodedMethod> {
    public static final String CONFIGURATION_DEBUGGING_PREFIX = "Shaking error: Missing method in ";
    public static final DexEncodedMethod[] EMPTY_ARRAY = new DexEncodedMethod[0];
    public static final DexEncodedMethod SENTINEL = new DexEncodedMethod(null, MethodAccessFlags.fromDexAccessFlags(0), GenericSignature.MethodTypeSignature.noSignature(), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), null, false, ComputedApiLevel.notSet(), ComputedApiLevel.notSet(), null, DefaultMethodOptimizationInfo.getInstance(), false);
    public static final Int2ReferenceMap<DebugLocalInfo> NO_PARAMETER_INFO = new Int2ReferenceArrayMap<DebugLocalInfo>(0);
    public final MethodAccessFlags accessFlags;
    public final boolean deprecated;
    public ParameterAnnotationsList parameterAnnotationsList;
    private Code code;
    private CompilationState compilationState = CompilationState.NOT_PROCESSED;
    private MethodOptimizationInfo optimizationInfo;
    private CfVersion classFileVersion;
    private ComputedApiLevel apiLevelForCode;
    private KotlinMethodLevelInfo kotlinMemberInfo = KotlinMetadataUtils.getNoKotlinInfo();
    private GenericSignature.MethodTypeSignature genericSignature;
    private OptionalBool isLibraryMethodOverride = OptionalBool.unknown();
    private Int2ReferenceMap<DebugLocalInfo> parameterInfo = NO_PARAMETER_INFO;
    private boolean obsolete = false;

    private void checkIfObsolete() {
        assert (!this.obsolete);
    }

    private DexEncodedMethod(DexMethod method, MethodAccessFlags accessFlags, GenericSignature.MethodTypeSignature genericSignature, DexAnnotationSet annotations, ParameterAnnotationsList parameterAnnotationsList, Code code, boolean d8R8Synthesized, ComputedApiLevel apiLevelForDefinition, ComputedApiLevel apiLevelForCode, CfVersion classFileVersion, MethodOptimizationInfo optimizationInfo, boolean deprecated) {
        super(method, annotations, d8R8Synthesized, apiLevelForDefinition);
        this.accessFlags = accessFlags;
        this.deprecated = deprecated;
        this.genericSignature = genericSignature;
        this.parameterAnnotationsList = parameterAnnotationsList;
        this.code = code;
        this.classFileVersion = classFileVersion;
        this.apiLevelForCode = apiLevelForCode;
        this.optimizationInfo = Objects.requireNonNull(optimizationInfo);
        assert (accessFlags != null);
        assert (code == null || !this.shouldNotHaveCode());
        assert (parameterAnnotationsList != null);
        assert (apiLevelForDefinition != null);
        assert (apiLevelForCode != null);
    }

    public static DexEncodedMethod toMethodDefinitionOrNull(DexClassAndMethod method) {
        return method != null ? (DexEncodedMethod)method.getDefinition() : null;
    }

    private static void syntheticSpecify(StructuralSpecification<DexEncodedMethod, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)((StructuralSpecification)spec.withItem(DexEncodedMember::getReference)).withItem(DexEncodedMethod::getAccessFlags)).withItem(DexDefinition::annotations)).withItem(m3 -> m3.parameterAnnotationsList)).withNullableItem(m3 -> m3.classFileVersion)).withBool(DexEncodedMember::isD8R8Synthesized)).withAssert(m3 -> m3.genericSignature.hasNoSignature())).withCustomItem(DexEncodedMethod::getCode, DexEncodedMethod::compareCodeObject, DexEncodedMethod::hashCodeObject);
    }

    private static int compareCodeObject(Code code1, Code code2, CompareToVisitor visitor) {
        if (code1 == code2) {
            return 0;
        }
        if (code1 == null || code2 == null) {
            return visitor.visitBool(code1 != null, code2 != null);
        }
        if (code1.isCfWritableCode() && code2.isCfWritableCode()) {
            return code1.asCfWritableCode().acceptCompareTo(code2.asCfWritableCode(), visitor);
        }
        if (code1.isDexWritableCode() && code2.isDexWritableCode()) {
            return code1.asDexWritableCode().acceptCompareTo(code2.asDexWritableCode(), visitor);
        }
        throw new Unreachable("Unexpected attempt to compare incompatible synthetic objects: " + code1 + " and " + code2);
    }

    private static void hashCodeObject(Code code, HashingVisitor visitor) {
        if (code != null) {
            if (code.isCfWritableCode()) {
                code.asCfWritableCode().acceptHashing(visitor);
            } else {
                assert (code.isDexWritableCode());
                code.asDexWritableCode().acceptHashing(visitor);
            }
        }
    }

    public static DexClassAndMethod asDexClassAndMethodOrNull(DexEncodedMethod method, DexDefinitionSupplier definitions) {
        return method != null ? method.asDexClassAndMethod(definitions) : null;
    }

    public static ProgramMethod asProgramMethodOrNull(DexEncodedMethod method, DexProgramClass holder) {
        return method != null ? method.asProgramMethod(holder) : null;
    }

    public static ProgramMethod asProgramMethodOrNull(DexEncodedMethod method, DexDefinitionSupplier definitions) {
        return method != null ? method.asProgramMethod(definitions) : null;
    }

    private DexCode generateCodeFromTemplate(int numberOfRegisters, int outRegisters, Instruction ... instructions) {
        int offset = 0;
        for (Instruction instruction : instructions) {
            instruction.setOffset(offset);
            offset += instruction.getSize();
        }
        int requiredArgRegisters = this.accessFlags.isStatic() ? 0 : 1;
        for (DexType type : ((DexMethod)this.getReference()).proto.parameters.values) {
            requiredArgRegisters += ValueType.fromDexType(type).requiredRegisters();
        }
        return new DexCode(Math.max(numberOfRegisters, requiredArgRegisters), requiredArgRegisters, outRegisters, instructions, new DexCode.Try[0], new DexCode.TryHandler[0], null);
    }

    public static void setDebugInfoWithFakeThisParameter(Code code, int arity, AppView<?> appView) {
        if (code.isDexCode()) {
            DexCode dexCode = code.asDexCode();
            DexDebugInfo newDebugInfo = dexCode.debugInfoWithFakeThisParameter(appView.dexItemFactory());
            assert (newDebugInfo == null || arity == newDebugInfo.getParameterCount());
            dexCode.setDebugInfo(newDebugInfo);
        } else {
            assert (code.isCfCode());
            CfCode cfCode = code.asCfCode();
            cfCode.addFakeThisParameter(appView.dexItemFactory());
        }
    }

    private DexCode toDexCodeThatLogsError(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod((DexMethod)this.getReference());
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + ((DexMethod)this.getReference()).holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType[] args2 = new DexType[]{itemFactory.stringType, itemFactory.stringType};
        DexProto proto = itemFactory.createProto(itemFactory.intType, args2);
        DexMethod logMethod = itemFactory.createMethod(itemFactory.androidUtilLogType, proto, itemFactory.createString("e"));
        DexType exceptionType = itemFactory.runtimeExceptionType;
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        return this.generateCodeFromTemplate(2, 2, new ConstString(0, tag), new ConstString(1, message), new InvokeStatic(2, logMethod, 0, 1, 0, 0, 0), new NewInstance(0, exceptionType), new InvokeDirect(2, exceptionInitMethod, 0, 1, 0, 0, 0), new Throw(0));
    }

    private CfCode toCfCodeThatLogsError(DexItemFactory itemFactory) {
        this.checkIfObsolete();
        MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod((DexMethod)this.getReference());
        DexString message = itemFactory.createString(CONFIGURATION_DEBUGGING_PREFIX + ((DexMethod)this.getReference()).holder.toSourceString() + ": " + signature);
        DexString tag = itemFactory.createString("[R8]");
        DexType logger = itemFactory.javaUtilLoggingLoggerType;
        DexMethod getLogger = itemFactory.createMethod(logger, itemFactory.createProto(logger, itemFactory.stringType), itemFactory.createString("getLogger"));
        DexMethod severe = itemFactory.createMethod(logger, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.createString("severe"));
        DexType exceptionType = itemFactory.runtimeExceptionType;
        DexMethod exceptionInitMethod = itemFactory.createMethod(exceptionType, itemFactory.createProto(itemFactory.voidType, itemFactory.stringType), itemFactory.constructorMethodName);
        int locals = ((DexMethod)this.getReference()).proto.parameters.size() + 1;
        if (!this.isStaticMember()) {
            ++locals;
        }
        ImmutableList.Builder instructionBuilder = ImmutableList.builder();
        ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)instructionBuilder.add(new CfConstString(tag))).add(new CfInvoke(184, getLogger, false))).add(new CfStore(ValueType.OBJECT, locals - 1))).add(new CfLoad(ValueType.OBJECT, locals - 1))).add(new CfConstString(message))).add(new CfInvoke(182, severe, false))).add(new CfNew(exceptionType))).add(new CfStackInstruction(CfStackInstruction.Opcode.Dup))).add(new CfConstString(message))).add(new CfInvoke(183, exceptionInitMethod, false))).add(new CfThrow());
        return new CfCode(((DexMethod)this.getReference()).holder, 3, locals, (List<CfInstruction>)((Object)instructionBuilder.build()));
    }

    public static DexEncodedMethod createDesugaringForwardingMethod(DexEncodedMethod target, DexClass clazz, DexMethod forwardMethod, DexItemFactory factory) {
        DexMethod method = (DexMethod)target.getReference();
        assert (forwardMethod != null);
        DexMethod newMethod = factory.createMethod(clazz.type, method.proto, method.name);
        MethodAccessFlags newFlags = target.getAccessFlags().copy();
        newFlags.setSynthetic();
        newFlags.unsetAbstract();
        boolean isInterfaceMethodReference = false;
        return DexEncodedMethod.syntheticBuilder().setMethod(newMethod).setAccessFlags(newFlags).setGenericSignature(GenericSignature.MethodTypeSignature.noSignature()).setAnnotations(DexAnnotationSet.empty()).setCode(ForwardMethodBuilder.builder(factory).setNonStaticSource(newMethod).setStaticTarget(forwardMethod, isInterfaceMethodReference).build()).setApiLevelForDefinition(target.getApiLevelForDefinition()).setApiLevelForCode(target.getApiLevelForCode()).build();
    }

    public static int slowCompare(DexEncodedMethod m1, DexEncodedMethod m22) {
        return ((DexMethod)m1.getReference()).compareTo((DexMethod)m22.getReference());
    }

    public static Builder syntheticBuilder() {
        return new Builder(true);
    }

    public static Builder syntheticBuilder(DexEncodedMethod from) {
        return new Builder(true, from);
    }

    public static Builder builder() {
        return new Builder(false);
    }

    private static Builder builder(DexEncodedMethod from) {
        return new Builder(from.isD8R8Synthesized(), from);
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete() {
        this.obsolete = true;
    }

    public MethodAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public DexType getArgumentType(int argumentIndex) {
        return ((DexMethod)this.getReference()).getArgumentType(argumentIndex, this.isStatic());
    }

    public int getFirstNonReceiverArgumentIndex() {
        return this.isStatic() ? 0 : 1;
    }

    public int getNumberOfArguments() {
        return ((DexMethod)this.getReference()).getNumberOfArguments(this.isStatic());
    }

    public CompilationState getCompilationState() {
        return this.compilationState;
    }

    public void unsetObsolete() {
        this.obsolete = false;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public DexEncodedMethod self() {
        return this;
    }

    @Override
    public StructuralMapping<DexEncodedMethod> getStructuralMapping() {
        return DexEncodedMethod::syntheticSpecify;
    }

    public DexProto getProto() {
        return ((DexMethod)this.getReference()).getProto();
    }

    public DexType getParameter(int index) {
        return ((DexMethod)this.getReference()).getParameter(index);
    }

    public DexTypeList getParameters() {
        return ((DexMethod)this.getReference()).getParameters();
    }

    public DexType getReturnType() {
        return ((DexMethod)this.getReference()).getReturnType();
    }

    public DexMethodSignature getSignature() {
        return DexMethodSignature.create((DexMethod)this.getReference());
    }

    public DexType returnType() {
        return ((DexMethod)this.getReference()).proto.returnType;
    }

    public OptionalBool isLibraryMethodOverride() {
        return this.isNonPrivateVirtualMethod() ? this.isLibraryMethodOverride : OptionalBool.FALSE;
    }

    public void setLibraryMethodOverride(OptionalBool isLibraryMethodOverride) {
        assert (this.isNonPrivateVirtualMethod());
        assert (!isLibraryMethodOverride.isUnknown());
        assert (isLibraryMethodOverride.isPossiblyFalse() || this.isLibraryMethodOverride.isPossiblyTrue()) : "Method `" + ((DexMethod)this.getReference()).toSourceString() + "` went from not overriding a library method to overriding a library method";
        assert (isLibraryMethodOverride.isPossiblyTrue() || this.isLibraryMethodOverride.isPossiblyFalse()) : "Method `" + ((DexMethod)this.getReference()).toSourceString() + "` went from overriding a library method to not overriding a library method";
        this.isLibraryMethodOverride = isLibraryMethodOverride;
    }

    public boolean isProgramMethod(DexDefinitionSupplier definitions) {
        if (((DexMethod)this.getReference()).holder.isClassType()) {
            DexClass clazz = definitions.definitionFor(((DexMethod)this.getReference()).holder);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    public ProgramMethod asProgramMember(DexDefinitionSupplier definitions) {
        return this.asProgramMethod(definitions);
    }

    @Override
    public <T> T apply(Function<DexEncodedField, T> fieldConsumer, Function<DexEncodedMethod, T> methodConsumer) {
        return methodConsumer.apply(this);
    }

    public DexClassAndMethod asDexClassAndMethod(DexDefinitionSupplier definitions) {
        assert (((DexMethod)this.getReference()).holder.isClassType());
        DexClass clazz = definitions.definitionForHolder(this.getReference());
        if (clazz != null) {
            return DexClassAndMethod.create(clazz, this);
        }
        return null;
    }

    public ProgramMethod asProgramMethod(DexProgramClass holder) {
        assert (this.getHolderType() == holder.getType());
        return new ProgramMethod(holder, this);
    }

    public ProgramMethod asProgramMethod(DexDefinitionSupplier definitions) {
        assert (((DexMethod)this.getReference()).holder.isClassType());
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(definitions.definitionForHolder(this.getReference()));
        if (clazz != null) {
            return new ProgramMethod(clazz, this);
        }
        return null;
    }

    public boolean isProcessed() {
        this.checkIfObsolete();
        return this.compilationState != CompilationState.NOT_PROCESSED;
    }

    public boolean isAbstract() {
        return this.accessFlags.isAbstract();
    }

    public boolean isBridge() {
        return this.accessFlags.isBridge();
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    public boolean isNative() {
        return this.accessFlags.isNative();
    }

    public boolean isPublic() {
        return this.accessFlags.isPublic();
    }

    public boolean isSynchronized() {
        return this.accessFlags.isSynchronized();
    }

    public boolean isInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() || this.isClassInitializer();
    }

    public boolean isInstanceInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && !this.accessFlags.isStatic();
    }

    public boolean willBeInlinedIntoInstanceInitializer(DexItemFactory dexItemFactory) {
        this.checkIfObsolete();
        if (this.getName().startsWith(dexItemFactory.temporaryConstructorMethodPrefix)) {
            assert (this.isPrivate());
            assert (!this.isStatic());
            return true;
        }
        return false;
    }

    public boolean isOrWillBeInlinedIntoInstanceInitializer(DexItemFactory dexItemFactory) {
        return this.isInstanceInitializer() || this.willBeInlinedIntoInstanceInitializer(dexItemFactory);
    }

    public boolean isDefaultInitializer() {
        this.checkIfObsolete();
        return this.isInstanceInitializer() && ((DexMethod)this.getReference()).proto.parameters.isEmpty();
    }

    public boolean isClassInitializer() {
        this.checkIfObsolete();
        return this.accessFlags.isConstructor() && this.accessFlags.isStatic();
    }

    public boolean isDefaultMethod() {
        return !this.isStatic() && !this.isAbstract() && !this.isPrivateMethod() && !this.isInstanceInitializer();
    }

    public boolean isVirtualMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isStatic() && !this.accessFlags.isConstructor();
    }

    public boolean isNonPrivateVirtualMethod() {
        this.checkIfObsolete();
        return !this.isPrivateMethod() && this.isVirtualMethod();
    }

    public boolean isNonStaticPrivateMethod() {
        this.checkIfObsolete();
        return this.isInstance() && this.isPrivate();
    }

    public boolean isNonAbstractVirtualMethod() {
        this.checkIfObsolete();
        return this.isVirtualMethod() && !this.accessFlags.isAbstract();
    }

    public boolean isNonAbstractNonNativeMethod() {
        this.checkIfObsolete();
        return !this.accessFlags.isAbstract() && !this.accessFlags.isNative();
    }

    public boolean isPublicized() {
        this.checkIfObsolete();
        return this.accessFlags.isPromotedToPublic();
    }

    public boolean isPublicMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPublic();
    }

    public boolean isProtectedMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isProtected();
    }

    public boolean isPrivateMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isPrivate();
    }

    public boolean isDirectMethod() {
        this.checkIfObsolete();
        return (this.accessFlags.isPrivate() || this.accessFlags.isConstructor()) && !this.accessFlags.isStatic();
    }

    public boolean isInstance() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        this.checkIfObsolete();
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        this.checkIfObsolete();
        return this.isStatic();
    }

    public boolean isSyntheticMethod() {
        this.checkIfObsolete();
        return this.accessFlags.isSynthetic();
    }

    public boolean belongsToDirectPool() {
        return this.accessFlags.isStatic() || this.accessFlags.isPrivate() || this.accessFlags.isConstructor();
    }

    public boolean belongsToVirtualPool() {
        return !this.belongsToDirectPool();
    }

    @Override
    public KotlinMethodLevelInfo getKotlinInfo() {
        return this.kotlinMemberInfo;
    }

    @Override
    public void clearKotlinInfo() {
        this.kotlinMemberInfo = KotlinMetadataUtils.getNoKotlinInfo();
    }

    public void setKotlinMemberInfo(KotlinMethodLevelInfo kotlinMemberInfo) {
        assert (this.kotlinMemberInfo == KotlinMetadataUtils.getNoKotlinInfo());
        this.kotlinMemberInfo = kotlinMemberInfo;
    }

    public boolean isKotlinFunction() {
        return this.kotlinMemberInfo.isFunction();
    }

    public boolean isKotlinExtensionFunction() {
        return this.kotlinMemberInfo.isFunction() && this.kotlinMemberInfo.asFunction().isExtensionFunction();
    }

    public boolean isOnlyInlinedIntoNestMembers() {
        return this.compilationState == CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_NEST;
    }

    public boolean isInliningCandidate(ProgramMethod container, Inliner.Reason inliningReason, AppInfoWithClassHierarchy appInfo, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        this.checkIfObsolete();
        return this.isInliningCandidate(container.getHolderType(), inliningReason, appInfo, whyAreYouNotInliningReporter);
    }

    public boolean isInliningCandidate(DexType containerType, Inliner.Reason inliningReason, AppInfoWithClassHierarchy appInfo, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        this.checkIfObsolete();
        if (inliningReason == Inliner.Reason.FORCE) {
            if (!this.isInliningCandidate(containerType, Inliner.Reason.SIMPLE, appInfo, whyAreYouNotInliningReporter)) {
                throw new InternalCompilerError("FORCE inlining on non-inlinable: " + this.toSourceString());
            }
            return true;
        }
        switch (this.compilationState) {
            case PROCESSED_INLINING_CANDIDATE_ANY: {
                return true;
            }
            case PROCESSED_INLINING_CANDIDATE_SUBCLASS: {
                if (appInfo.isSubtype(containerType, ((DexMethod)this.getReference()).holder)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSubtype();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE: {
                if (containerType.isSamePackage(((DexMethod)this.getReference()).holder)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSamePackage();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_NEST: {
                if (NestUtils.sameNest(containerType, ((DexMethod)this.getReference()).holder, appInfo)) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSameNest();
                return false;
            }
            case PROCESSED_INLINING_CANDIDATE_SAME_CLASS: {
                if (containerType == ((DexMethod)this.getReference()).holder) {
                    return true;
                }
                whyAreYouNotInliningReporter.reportCallerNotSameClass();
                return false;
            }
            case PROCESSED_NOT_INLINING_CANDIDATE: {
                whyAreYouNotInliningReporter.reportInlineeNotInliningCandidate();
                return false;
            }
            case NOT_PROCESSED: {
                whyAreYouNotInliningReporter.reportInlineeNotProcessed();
                return false;
            }
        }
        throw new Unreachable("Unexpected compilation state: " + (Object)((Object)this.compilationState));
    }

    public boolean markProcessed(Inliner.ConstraintWithTarget state) {
        this.checkIfObsolete();
        CompilationState prevCompilationState = this.compilationState;
        switch (state.constraint) {
            case ALWAYS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_ANY;
                break;
            }
            case SUBCLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SUBCLASS;
                break;
            }
            case PACKAGE: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE;
                break;
            }
            case SAMENEST: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_NEST;
                break;
            }
            case SAMECLASS: {
                this.compilationState = CompilationState.PROCESSED_INLINING_CANDIDATE_SAME_CLASS;
                break;
            }
            case NEVER: {
                this.compilationState = CompilationState.PROCESSED_NOT_INLINING_CANDIDATE;
            }
        }
        return prevCompilationState != this.compilationState;
    }

    public void markNotProcessed() {
        this.checkIfObsolete();
        this.compilationState = CompilationState.NOT_PROCESSED;
    }

    public void setCode(Code code, Int2ReferenceMap<DebugLocalInfo> parameterInfo) {
        this.checkIfObsolete();
        this.code = code;
        this.parameterInfo = parameterInfo;
    }

    public void unsetCode() {
        this.checkIfObsolete();
        this.code = null;
    }

    public boolean hasParameterInfo() {
        return this.parameterInfo != NO_PARAMETER_INFO;
    }

    public Int2ReferenceMap<DebugLocalInfo> getParameterInfo() {
        return this.parameterInfo;
    }

    public String toString() {
        this.checkIfObsolete();
        return "Encoded method " + this.getReference();
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.visit(this);
    }

    public void collectMixedSectionItemsWithCodeMapping(MixedSectionCollection mixedItems) {
        DexWritableCode code = this.getDexWritableCodeOrNull();
        if (code != null && mixedItems.add(this, code)) {
            code.collectMixedSectionItems(mixedItems);
        }
        this.annotations().collectMixedSectionItems(mixedItems);
        this.parameterAnnotationsList.collectMixedSectionItems(mixedItems);
    }

    public boolean shouldNotHaveCode() {
        return this.accessFlags.isAbstract() || this.accessFlags.isNative();
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public Code getCode() {
        this.checkIfObsolete();
        return this.code;
    }

    public CfVersion getClassFileVersion() {
        this.checkIfObsolete();
        assert (this.classFileVersion != null);
        return this.classFileVersion;
    }

    public CfVersion getClassFileVersionOrElse(CfVersion defaultValue) {
        return this.hasClassFileVersion() ? this.getClassFileVersion() : defaultValue;
    }

    public boolean hasClassFileVersion() {
        this.checkIfObsolete();
        return this.classFileVersion != null;
    }

    public void upgradeClassFileVersion(CfVersion version) {
        this.checkIfObsolete();
        assert (version != null);
        this.classFileVersion = Ordered.maxIgnoreNull(this.classFileVersion, version);
    }

    public void downgradeClassFileVersion(CfVersion version) {
        this.checkIfObsolete();
        assert (version != null);
        this.classFileVersion = Ordered.minIgnoreNull(this.classFileVersion, version);
    }

    public String qualifiedName() {
        this.checkIfObsolete();
        return ((DexMethod)this.getReference()).qualifiedName();
    }

    public String descriptor() {
        this.checkIfObsolete();
        return this.descriptor(NamingLens.getIdentityLens());
    }

    public String descriptor(NamingLens namingLens) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (DexType type : ((DexMethod)this.getReference()).proto.parameters.values) {
            builder.append(namingLens.lookupDescriptor(type).toString());
        }
        builder.append(")");
        builder.append(namingLens.lookupDescriptor(((DexMethod)this.getReference()).proto.returnType).toString());
        return builder.toString();
    }

    @Override
    public boolean hasAnyAnnotations() {
        return this.hasAnnotations() || this.hasParameterAnnotations();
    }

    @Override
    public void clearAllAnnotations() {
        this.clearAnnotations();
        this.clearParameterAnnotations();
    }

    @Override
    public void rewriteAllAnnotations(BiFunction<DexAnnotation, DexAnnotation.AnnotatedKind, DexAnnotation> rewriter) {
        this.setAnnotations(this.annotations().rewrite(annotation -> (DexAnnotation)rewriter.apply((DexAnnotation)annotation, DexAnnotation.AnnotatedKind.METHOD)));
        this.setParameterAnnotations(this.getParameterAnnotations().rewrite(annotation -> (DexAnnotation)rewriter.apply((DexAnnotation)annotation, DexAnnotation.AnnotatedKind.PARAMETER)));
    }

    public void clearParameterAnnotations() {
        this.parameterAnnotationsList = ParameterAnnotationsList.empty();
    }

    public DexAnnotationSet getParameterAnnotation(int index) {
        return this.getParameterAnnotations().get(index);
    }

    public ParameterAnnotationsList getParameterAnnotations() {
        return this.parameterAnnotationsList;
    }

    public boolean hasParameterAnnotations() {
        return !this.getParameterAnnotations().isEmpty();
    }

    public void setParameterAnnotations(ParameterAnnotationsList parameterAnnotations) {
        this.parameterAnnotationsList = parameterAnnotations;
    }

    public String toSmaliString(ClassNameMapper naming) {
        this.checkIfObsolete();
        StringBuilder builder = new StringBuilder();
        builder.append(".method ");
        builder.append(this.accessFlags.toSmaliString());
        builder.append(" ");
        builder.append(((DexMethod)this.getReference()).name.toSmaliString());
        builder.append(((DexMethod)this.getReference()).proto.toSmaliString());
        builder.append("\n");
        if (this.code != null) {
            DexCode dexCode = this.code.asDexCode();
            builder.append("    .registers ");
            builder.append(dexCode.registerSize);
            builder.append("\n\n");
            builder.append(dexCode.toSmaliString(naming));
        }
        builder.append(".end method\n");
        return builder.toString();
    }

    @Override
    public String toSourceString() {
        this.checkIfObsolete();
        return ((DexMethod)this.getReference()).toSourceString();
    }

    public Code buildInstanceOfCode(DexType type, boolean negate, InternalOptions options) {
        return options.isGeneratingClassFiles() ? this.buildInstanceOfCfCode(type, negate) : this.buildInstanceOfDexCode(type, negate);
    }

    public CfCode buildInstanceOfCfCode(DexType type, boolean negate) {
        CfInstruction[] instructions = new CfInstruction[3 + BooleanUtils.intValue(negate) * 2];
        int i = 0;
        instructions[i++] = new CfLoad(ValueType.OBJECT, 0);
        instructions[i++] = new CfInstanceOf(type);
        if (negate) {
            instructions[i++] = new CfConstNumber(1L, ValueType.INT);
            instructions[i++] = new CfLogicalBinop(CfLogicalBinop.Opcode.Xor, NumericType.INT);
        }
        instructions[i] = new CfReturn(ValueType.INT);
        return new CfCode(((DexMethod)this.getReference()).holder, 1 + BooleanUtils.intValue(negate), ((DexMethod)this.getReference()).getArity() + 1, Arrays.asList(instructions));
    }

    public DexCode buildInstanceOfDexCode(DexType type, boolean negate) {
        Instruction[] instructions = new Instruction[2 + BooleanUtils.intValue(negate)];
        int i = 0;
        instructions[i++] = new InstanceOf(0, 0, type);
        if (negate) {
            instructions[i++] = new XorIntLit8(0, 0, 1);
        }
        instructions[i] = new Return(0);
        return this.generateCodeFromTemplate(1, 0, instructions);
    }

    public DexEncodedMethod toMethodThatLogsError(AppView<?> appView) {
        Builder builder = DexEncodedMethod.builder(this).setCode(appView.options().isGeneratingClassFiles() ? this.toCfCodeThatLogsError(appView.dexItemFactory()) : this.toDexCodeThatLogsError(appView.dexItemFactory())).setIsLibraryMethodOverrideIf(this.belongsToVirtualPool() && !this.isLibraryMethodOverride().isUnknown(), this.isLibraryMethodOverride());
        this.setObsolete();
        return builder.build();
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method) {
        this.checkIfObsolete();
        return this.toTypeSubstitutedMethod(method, null);
    }

    public DexEncodedMethod toTypeSubstitutedMethod(DexMethod method, Consumer<Builder> consumer) {
        this.checkIfObsolete();
        Builder builder = DexEncodedMethod.builder(this);
        if (this.isNonPrivateVirtualMethod() && this.isLibraryMethodOverride() != OptionalBool.unknown()) {
            builder.setIsLibraryMethodOverride(this.isLibraryMethodOverride());
        }
        builder.setMethod(method);
        if (consumer != null) {
            consumer.accept(builder);
        }
        return builder.build();
    }

    public DexEncodedMethod toRenamedHolderMethod(DexType newHolderType, DexItemFactory factory) {
        Builder builder = DexEncodedMethod.builder(this);
        builder.setMethod(((DexMethod)this.getReference()).withHolder(newHolderType, factory));
        return builder.build();
    }

    public ProgramMethod toPrivateSyntheticMethod(DexProgramClass holder, DexMethod method) {
        assert (!this.isStatic());
        assert (!this.isPrivate());
        assert (this.getHolderType() == method.getHolderType());
        this.checkIfObsolete();
        return new ProgramMethod(holder, DexEncodedMethod.syntheticBuilder(this).setMethod(method).modifyAccessFlags(accessFlags -> {
            accessFlags.setSynthetic();
            accessFlags.unsetProtected();
            accessFlags.unsetPublic();
            accessFlags.setPrivate();
        }).build());
    }

    public DexEncodedMethod toForwardingMethod(DexClass newHolder, DexDefinitionSupplier definitions) {
        DexMethod newMethod = ((DexMethod)this.getReference()).withHolder(newHolder, definitions.dexItemFactory());
        this.checkIfObsolete();
        this.accessFlags.demoteFromFinal();
        return DexEncodedMethod.syntheticBuilder(this).setMethod(newMethod).modifyAccessFlags(AccessFlags::setSynthetic).applyIf(!this.isAbstract(), builder -> builder.setGenericSignature(GenericSignature.MethodTypeSignature.noSignature()).setCode(ForwardMethodBuilder.builder(definitions.dexItemFactory()).setStaticSource(newMethod).applyIf(this.isStatic(), codeBuilder -> codeBuilder.setStaticSource(newMethod).setStaticTarget((DexMethod)this.getReference(), ((DexMethod)this.getReference()).getHolderType().isInterface(definitions)), codeBuilder -> codeBuilder.setNonStaticSource(newMethod).setSuperTarget((DexMethod)this.getReference(), ((DexMethod)this.getReference()).getHolderType().isInterface(definitions))).build()).modifyAccessFlags(MethodAccessFlags::setBridge)).setIsLibraryMethodOverrideIf(!this.isStatic() && !this.isLibraryMethodOverride().isUnknown(), this.isLibraryMethodOverride()).build();
    }

    public String codeToString() {
        this.checkIfObsolete();
        return this.code == null ? "<no code>" : this.code.toString(this, null);
    }

    @Override
    public boolean isDexEncodedMethod() {
        this.checkIfObsolete();
        return true;
    }

    @Override
    public DexEncodedMethod asDexEncodedMethod() {
        this.checkIfObsolete();
        return this;
    }

    public MethodOptimizationInfo getOptimizationInfo() {
        this.checkIfObsolete();
        return this.optimizationInfo;
    }

    public ComputedApiLevel getApiLevelForCode() {
        return this.apiLevelForCode;
    }

    public void clearApiLevelForCode() {
        this.apiLevelForCode = ComputedApiLevel.notSet();
    }

    public void setApiLevelForCode(ComputedApiLevel apiLevel) {
        assert (apiLevel != null);
        this.apiLevelForCode = apiLevel;
    }

    @Override
    public ComputedApiLevel getApiLevel() {
        ComputedApiLevel apiLevelForDefinition = this.getApiLevelForDefinition();
        return this.shouldNotHaveCode() ? apiLevelForDefinition : apiLevelForDefinition.max(this.apiLevelForCode);
    }

    public synchronized MutableMethodOptimizationInfo getMutableOptimizationInfo() {
        this.checkIfObsolete();
        MutableMethodOptimizationInfo mutableInfo = (MutableMethodOptimizationInfo)this.optimizationInfo.toMutableOptimizationInfo();
        this.optimizationInfo = mutableInfo;
        return mutableInfo;
    }

    public void setOptimizationInfo(MutableMethodOptimizationInfo info) {
        this.checkIfObsolete();
        this.optimizationInfo = info;
    }

    public void copyMetadata(AppView<?> appView, DexEncodedMethod from) {
        this.checkIfObsolete();
        if (from.hasClassFileVersion()) {
            this.upgradeClassFileVersion(from.getClassFileVersion());
        }
        if (appView.options().apiModelingOptions().enableApiCallerIdentification) {
            this.apiLevelForCode = this.getApiLevelForCode().max(from.getApiLevelForCode());
        }
    }

    public GenericSignature.MethodTypeSignature getGenericSignature() {
        return this.genericSignature;
    }

    public void setGenericSignature(GenericSignature.MethodTypeSignature genericSignature) {
        assert (genericSignature != null);
        this.genericSignature = genericSignature;
    }

    @Override
    public void clearGenericSignature() {
        this.genericSignature = GenericSignature.MethodTypeSignature.noSignature();
    }

    public DexWritableCode getDexWritableCodeOrNull() {
        Code code = this.getCode();
        assert (code == null || code.isDexWritableCode());
        return code == null ? null : code.asDexWritableCode();
    }

    public static class Builder {
        private MethodAccessFlags accessFlags;
        private Code code;
        private DexMethod method;
        private GenericSignature.MethodTypeSignature genericSignature = GenericSignature.MethodTypeSignature.noSignature();
        private DexAnnotationSet annotations = DexAnnotationSet.empty();
        private OptionalBool isLibraryMethodOverride = OptionalBool.UNKNOWN;
        private ParameterAnnotationsList parameterAnnotations = ParameterAnnotationsList.empty();
        private CompilationState compilationState = CompilationState.NOT_PROCESSED;
        private MethodOptimizationInfo optimizationInfo = DefaultMethodOptimizationInfo.getInstance();
        private KotlinMethodLevelInfo kotlinInfo = KotlinMetadataUtils.getNoKotlinInfo();
        private CfVersion classFileVersion = null;
        private ComputedApiLevel apiLevelForDefinition = ComputedApiLevel.notSet();
        private ComputedApiLevel apiLevelForCode = ComputedApiLevel.notSet();
        private final boolean d8R8Synthesized;
        private boolean deprecated = false;
        private boolean checkMethodNotNull = true;
        private boolean checkParameterAnnotationList = true;
        private boolean checkAndroidApiLevels = true;
        private Consumer<DexEncodedMethod> buildConsumer = ConsumerUtils.emptyConsumer();

        private Builder(boolean d8R8Synthesized) {
            this.d8R8Synthesized = d8R8Synthesized;
        }

        private Builder(boolean d8R8Synthesized, DexEncodedMethod from) {
            this.method = (DexMethod)from.getReference();
            this.accessFlags = from.getAccessFlags().copy();
            this.genericSignature = from.getGenericSignature();
            this.annotations = from.annotations();
            this.code = from.getCode();
            this.apiLevelForDefinition = from.getApiLevelForDefinition();
            this.apiLevelForCode = from.getApiLevelForCode();
            this.optimizationInfo = from.getOptimizationInfo().isMutableOptimizationInfo() ? from.getOptimizationInfo().asMutableMethodOptimizationInfo().mutableCopy() : from.getOptimizationInfo();
            this.kotlinInfo = from.getKotlinInfo();
            this.classFileVersion = from.classFileVersion;
            this.d8R8Synthesized = d8R8Synthesized;
            this.deprecated = from.isDeprecated();
            this.parameterAnnotations = from.getParameterAnnotations().isEmpty() || from.getParameterAnnotations().size() == from.getParameters().size() ? from.getParameterAnnotations() : from.getParameterAnnotations().withParameterCount(from.getParameters().size());
        }

        public Builder apply(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Builder applyIf(boolean condition, Consumer<Builder> thenConsumer) {
            return this.applyIf(condition, thenConsumer, ConsumerUtils.emptyConsumer());
        }

        public Builder applyIf(boolean condition, Consumer<Builder> thenConsumer, Consumer<Builder> elseConsumer) {
            if (condition) {
                thenConsumer.accept(this);
            } else {
                elseConsumer.accept(this);
            }
            return this;
        }

        public Builder fixupOptimizationInfo(AppView<AppInfoWithLiveness> appView, MethodOptimizationInfoFixer fixer) {
            return this.modifyOptimizationInfo((newMethod, optimizationInfo) -> optimizationInfo.fixup(appView, fixer));
        }

        public Builder addBuildConsumer(Consumer<DexEncodedMethod> consumer) {
            this.buildConsumer = this.buildConsumer.andThen(consumer);
            return this;
        }

        public Builder modifyAccessFlags(Consumer<MethodAccessFlags> consumer) {
            consumer.accept(this.accessFlags);
            return this;
        }

        public Builder setAccessFlags(MethodAccessFlags accessFlags) {
            this.accessFlags = accessFlags;
            return this;
        }

        public Builder setMethod(DexMethod method) {
            this.method = method;
            return this;
        }

        public Builder setCompilationState(CompilationState compilationState) {
            assert (this.compilationState == CompilationState.NOT_PROCESSED);
            this.compilationState = compilationState;
            return this;
        }

        public Builder setIsLibraryMethodOverride(OptionalBool isLibraryMethodOverride) {
            assert (!isLibraryMethodOverride.isUnknown());
            this.isLibraryMethodOverride = isLibraryMethodOverride;
            return this;
        }

        public Builder setIsLibraryMethodOverrideIf(boolean condition, OptionalBool isLibraryMethodOverride) {
            if (condition) {
                return this.setIsLibraryMethodOverride(isLibraryMethodOverride);
            }
            return this;
        }

        public Builder setIsLibraryMethodOverrideIfKnown(OptionalBool isLibraryMethodOverride) {
            return this.setIsLibraryMethodOverrideIf(!isLibraryMethodOverride.isUnknown(), isLibraryMethodOverride);
        }

        public Builder unsetIsLibraryMethodOverride() {
            this.isLibraryMethodOverride = OptionalBool.UNKNOWN;
            return this;
        }

        public Builder clearAnnotations() {
            return this.setAnnotations(DexAnnotationSet.empty());
        }

        public Builder clearParameterAnnotations() {
            return this.setParameterAnnotations(ParameterAnnotationsList.empty());
        }

        public Builder clearAllAnnotations() {
            return this.clearAnnotations().clearParameterAnnotations();
        }

        public Builder setAnnotations(DexAnnotationSet annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder setParameterAnnotations(ParameterAnnotationsList parameterAnnotations) {
            this.parameterAnnotations = parameterAnnotations;
            return this;
        }

        public Builder rewriteParameterAnnotations(DexEncodedMethod method, ArgumentInfoCollection argumentInfoCollection) {
            if (this.parameterAnnotations.isEmpty()) {
                return this;
            }
            if (!argumentInfoCollection.hasArgumentPermutation() && !argumentInfoCollection.hasRemovedArguments()) {
                return this;
            }
            List<Object> newParameterAnnotations = new ArrayList<DexAnnotationSet>(this.parameterAnnotations.countNonMissing());
            int newNumberOfMissingParameterAnnotations = 0;
            for (int parameterIndex = 0; parameterIndex < method.getParameters().size(); ++parameterIndex) {
                int argumentIndex = parameterIndex + method.getFirstNonReceiverArgumentIndex();
                if (argumentInfoCollection.isArgumentRemoved(argumentIndex)) continue;
                if (this.parameterAnnotations.isMissing(parameterIndex)) {
                    ++newNumberOfMissingParameterAnnotations;
                    continue;
                }
                newParameterAnnotations.add(this.parameterAnnotations.get(parameterIndex));
            }
            if (newParameterAnnotations.isEmpty()) {
                return this.setParameterAnnotations(ParameterAnnotationsList.empty());
            }
            if (argumentInfoCollection.hasArgumentPermutation()) {
                List<DexAnnotationSet> newPermutedParameterAnnotations = Arrays.asList(new DexAnnotationSet[method.getParameters().size()]);
                for (int parameterIndex = newNumberOfMissingParameterAnnotations; parameterIndex < method.getParameters().size(); ++parameterIndex) {
                    int argumentIndex = parameterIndex + method.getFirstNonReceiverArgumentIndex();
                    int newArgumentIndex = argumentInfoCollection.getNewArgumentIndex(argumentIndex, 0);
                    int newParameterIndex = newArgumentIndex - method.getFirstNonReceiverArgumentIndex();
                    newPermutedParameterAnnotations.set(newParameterIndex, (DexAnnotationSet)newParameterAnnotations.get(parameterIndex - newNumberOfMissingParameterAnnotations));
                }
                newParameterAnnotations = newPermutedParameterAnnotations;
                newNumberOfMissingParameterAnnotations = 0;
            }
            return this.setParameterAnnotations(ParameterAnnotationsList.create(newParameterAnnotations.toArray(DexAnnotationSet.EMPTY_ARRAY), newNumberOfMissingParameterAnnotations));
        }

        public Builder setOptimizationInfo(MethodOptimizationInfo optimizationInfo) {
            this.optimizationInfo = optimizationInfo;
            return this;
        }

        public Builder modifyOptimizationInfo(BiConsumer<DexEncodedMethod, MutableMethodOptimizationInfo> consumer) {
            return this.addBuildConsumer(newMethod -> {
                if (this.optimizationInfo.isMutableOptimizationInfo()) {
                    consumer.accept((DexEncodedMethod)newMethod, this.optimizationInfo.asMutableMethodOptimizationInfo());
                }
            });
        }

        public Builder setCode(Code code) {
            this.code = code;
            return this;
        }

        public Builder unsetCode() {
            return this.setCode(null);
        }

        public Builder setGenericSignature(GenericSignature.MethodTypeSignature methodSignature) {
            this.genericSignature = methodSignature;
            return this;
        }

        public Builder setApiLevelForDefinition(ComputedApiLevel apiLevelForDefinition) {
            this.apiLevelForDefinition = apiLevelForDefinition;
            return this;
        }

        public Builder setApiLevelForCode(ComputedApiLevel apiLevelForCode) {
            this.apiLevelForCode = apiLevelForCode;
            return this;
        }

        public Builder setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder setClassFileVersion(CfVersion version) {
            this.classFileVersion = version;
            return this;
        }

        public Builder disableMethodNotNullCheck() {
            this.checkMethodNotNull = false;
            return this;
        }

        public Builder disableParameterAnnotationListCheck() {
            this.checkParameterAnnotationList = false;
            return this;
        }

        public Builder disableAndroidApiLevelCheck() {
            this.checkAndroidApiLevels = false;
            return this;
        }

        public DexEncodedMethod build() {
            assert (!this.checkMethodNotNull || this.method != null);
            assert (this.accessFlags != null);
            assert (this.annotations != null);
            assert (this.parameterAnnotations != null);
            assert (!this.checkParameterAnnotationList || this.parameterAnnotations.isEmpty() || this.parameterAnnotations.size() == this.method.proto.parameters.size());
            assert (!this.checkAndroidApiLevels || this.apiLevelForDefinition != null);
            assert (!this.checkAndroidApiLevels || this.apiLevelForCode != null);
            DexEncodedMethod result = new DexEncodedMethod(this.method, this.accessFlags, this.genericSignature, this.annotations, this.parameterAnnotations, this.code, this.d8R8Synthesized, this.apiLevelForDefinition, this.apiLevelForCode, this.classFileVersion, this.optimizationInfo, this.deprecated);
            result.setKotlinMemberInfo(this.kotlinInfo);
            result.compilationState = this.compilationState;
            if (!this.isLibraryMethodOverride.isUnknown()) {
                result.setLibraryMethodOverride(this.isLibraryMethodOverride);
            }
            this.buildConsumer.accept(result);
            return result;
        }
    }

    public static enum CompilationState {
        NOT_PROCESSED,
        PROCESSED_NOT_INLINING_CANDIDATE,
        PROCESSED_INLINING_CANDIDATE_ANY,
        PROCESSED_INLINING_CANDIDATE_SUBCLASS,
        PROCESSED_INLINING_CANDIDATE_SAME_PACKAGE,
        PROCESSED_INLINING_CANDIDATE_SAME_NEST,
        PROCESSED_INLINING_CANDIDATE_SAME_CLASS;

    }
}

