/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class DexField
extends DexMember<DexEncodedField, DexField> {
    public final DexType type;

    DexField(DexType holder, DexType type, DexString name, boolean skipNameValidationForTesting) {
        super(holder, name);
        this.type = type;
        if (!skipNameValidationForTesting && !name.isValidFieldName()) {
            throw new CompilationError("Field name '" + name.toString() + "' cannot be represented in dex format.");
        }
    }

    private static void specify(StructuralSpecification<DexField, ?> spec) {
        ((StructuralSpecification)((StructuralSpecification)spec.withItem(DexMember::getHolderType)).withItem(DexMember::getName)).withItem(DexField::getType);
    }

    @Override
    public int compareTo(DexReference other) {
        if (other.isDexField()) {
            return this.compareTo(other.asDexField());
        }
        if (other.isDexMethod()) {
            int comparisonResult = this.getHolderType().compareTo(other.getContextType());
            return comparisonResult != 0 ? comparisonResult : -1;
        }
        int comparisonResult = this.getHolderType().compareTo(other.asDexType());
        return comparisonResult != 0 ? comparisonResult : 1;
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitDexType(this.holder);
        visitor.visitDexString(this.name);
        this.getReferencedTypes().forEach(visitor::visitDexType);
    }

    @Override
    public DexField self() {
        return this;
    }

    @Override
    public StructuralMapping<DexField> getStructuralMapping() {
        return DexField::specify;
    }

    public DexType getType() {
        return this.type;
    }

    public TypeElement getTypeElement(AppView<?> appView) {
        return TypeElement.fromDexType(this.getType(), Nullability.maybeNull(), appView);
    }

    public DexEncodedField lookupOnClass(DexClass clazz) {
        return clazz != null ? clazz.lookupField(this) : null;
    }

    public DexClassAndField lookupMemberOnClass(DexClass clazz) {
        return clazz != null ? clazz.lookupClassField(this) : null;
    }

    public ProgramField lookupOnProgramClass(DexProgramClass clazz) {
        return clazz != null ? clazz.lookupProgramField(this) : null;
    }

    @Override
    public <T> T apply(Function<DexField, T> fieldConsumer, Function<DexMethod, T> methodConsumer) {
        return fieldConsumer.apply(this);
    }

    @Override
    public <T> T apply(Function<DexType, T> classConsumer, Function<DexField, T> fieldConsumer, Function<DexMethod, T> methodConsumer) {
        return fieldConsumer.apply(this);
    }

    @Override
    public void accept(Consumer<DexType> classConsumer, Consumer<DexField> fieldConsumer, Consumer<DexMethod> methodConsumer) {
        fieldConsumer.accept(this);
    }

    @Override
    public <T> void accept(BiConsumer<DexType, T> classConsumer, BiConsumer<DexField, T> fieldConsumer, BiConsumer<DexMethod, T> methodConsumer, T arg) {
        fieldConsumer.accept(this, (DexField)arg);
    }

    @Override
    public int computeHashCode() {
        return this.holder.hashCode() + this.type.hashCode() * 7 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexField) {
            DexField o = (DexField)other;
            return this.holder.equals(o.holder) && this.type.equals(o.type) && this.name.equals(o.name);
        }
        return false;
    }

    public String toString() {
        return "Field " + this.type + " " + this.holder + "." + this.name;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (indexedItems.addField(this)) {
            this.holder.collectIndexedItems(indexedItems);
            this.type.collectIndexedItems(indexedItems);
            indexedItems.getRenamedName(this).collectIndexedItems(indexedItems);
        }
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexField() {
        return true;
    }

    @Override
    public DexField asDexField() {
        return this;
    }

    @Override
    public Iterable<DexType> getReferencedTypes() {
        return Collections.singleton(this.type);
    }

    @Override
    public int acceptCompareTo(DexField other, CompareToVisitor visitor) {
        return visitor.visitDexField(this, other);
    }

    @Override
    public boolean match(DexField field) {
        return field.name == this.name && field.type == this.type;
    }

    @Override
    public boolean match(DexEncodedField encodedField) {
        return this.match((DexField)encodedField.getReference());
    }

    public String qualifiedName() {
        return this.holder + "." + this.name;
    }

    @Override
    public String toSmaliString() {
        return this.holder.toSmaliString() + "->" + this.name + ":" + this.type.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString() + " " + this.holder.toSourceString() + "." + this.name.toSourceString();
    }

    public DexField withHolder(DexType holder, DexItemFactory dexItemFactory) {
        return dexItemFactory.createField(holder, this.type, this.name);
    }

    public DexField withName(DexString name, DexItemFactory dexItemFactory) {
        return dexItemFactory.createField(this.holder, this.type, name);
    }

    public DexField withType(DexType type, DexItemFactory dexItemFactory) {
        return dexItemFactory.createField(this.holder, type, this.name);
    }

    public FieldReference asFieldReference() {
        return Reference.field(Reference.classFromDescriptor(this.holder.toDescriptorString()), this.name.toString(), Reference.typeFromDescriptor(this.type.toDescriptorString()));
    }
}

