/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.LibraryClass;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.origin.Origin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DexLibraryClass
extends DexClass
implements LibraryClass,
Supplier<DexLibraryClass> {
    public DexLibraryClass(DexType type, ProgramResource.Kind kind, Origin origin, ClassAccessFlags accessFlags, DexType superType, DexTypeList interfaces, DexString sourceFile, NestHostClassAttribute nestHost, List<NestMemberClassAttribute> nestMembers, EnclosingMethodAttribute enclosingMember, List<InnerClassAttribute> innerClasses, GenericSignature.ClassSignature classSignature, DexAnnotationSet annotations, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, MethodCollection.MethodCollectionFactory methodCollectionFactory, boolean skipNameValidationForTesting) {
        super(sourceFile, interfaces, accessFlags, superType, type, staticFields, instanceFields, methodCollectionFactory, nestHost, nestMembers, enclosingMember, innerClasses, classSignature, annotations, origin, skipNameValidationForTesting);
        assert (Streams.stream(this.methods()).allMatch(DexLibraryClass::verifyLibraryMethod));
        assert (Arrays.stream(staticFields).allMatch(DexLibraryClass::verifyLibraryField));
        assert (Arrays.stream(instanceFields).allMatch(DexLibraryClass::verifyLibraryField));
        for (DexEncodedField staticField : staticFields) {
            staticField.clearStaticValue();
        }
        assert (kind == ProgramResource.Kind.CF) : "Invalid kind " + (Object)((Object)kind) + " for library-path class " + type;
    }

    public static Builder builder(DexItemFactory dexItemFactory) {
        return new Builder(dexItemFactory);
    }

    public static DexLibraryClass asLibraryClassOrNull(DexClass clazz) {
        return clazz != null ? clazz.asLibraryClass() : null;
    }

    private static boolean verifyLibraryMethod(DexEncodedMethod method) {
        assert (!method.isClassInitializer());
        assert (!method.isPrivateMethod());
        assert (!method.hasCode());
        return true;
    }

    private static boolean verifyLibraryField(DexEncodedField field) {
        assert (!field.isPrivate());
        assert (!field.isStatic() || !field.hasExplicitStaticValue());
        return true;
    }

    @Override
    public void accept(Consumer<DexProgramClass> programClassConsumer, Consumer<DexClasspathClass> classpathClassConsumer, Consumer<DexLibraryClass> libraryClassConsumer) {
        libraryClassConsumer.accept(this);
    }

    public String toString() {
        return this.type.toString() + "(library class)";
    }

    @Override
    public String toSourceString() {
        return this.type.toSourceString() + "(library class)";
    }

    @Override
    public void addDependencies(MixedSectionCollection collector) {
        assert (false);
    }

    @Override
    public boolean isNotProgramClass() {
        return true;
    }

    @Override
    public boolean isLibraryClass() {
        return true;
    }

    @Override
    public DexLibraryClass asLibraryClass() {
        return this;
    }

    @Override
    public DexLibraryClass asClasspathOrLibraryClass() {
        return this;
    }

    @Override
    public KotlinClassLevelInfo getKotlinInfo() {
        throw new Unreachable("We should never consider metadata for library classes");
    }

    @Override
    public DexLibraryClass get() {
        return this;
    }

    @Override
    boolean internalClassOrInterfaceMayHaveInitializationSideEffects(AppView<?> appView, DexClass initialAccessHolder, Predicate<DexType> ignore, Set<DexType> seen) {
        if (!seen.add(this.getType()) || ignore.test(this.getType())) {
            return false;
        }
        return this.isInterface() ? appView.options().libraryInterfacesMayHaveStaticInitialization : !appView.dexItemFactory().libraryClassesWithoutStaticInitialization.contains(this.type);
    }

    public static class Builder {
        private DexType type;
        private ClassAccessFlags accessFlags;
        private Origin origin = Origin.unknown();
        private DexType superType;
        private DexTypeList interfaces = DexTypeList.empty();
        private DexString sourceFile = null;
        private NestHostClassAttribute nestHost = null;
        private List<NestMemberClassAttribute> nestMembers = Collections.emptyList();
        private EnclosingMethodAttribute enclosingMember = null;
        private List<InnerClassAttribute> innerClasses = Collections.emptyList();
        private GenericSignature.ClassSignature classSignature = GenericSignature.ClassSignature.noSignature();
        private DexAnnotationSet annotations = DexAnnotationSet.empty();
        private DexEncodedField[] staticFields = DexEncodedField.EMPTY_ARRAY;
        private DexEncodedField[] instanceFields = DexEncodedField.EMPTY_ARRAY;
        private DexEncodedMethod[] directMethods = DexEncodedMethod.EMPTY_ARRAY;
        private DexEncodedMethod[] virtualMethods = DexEncodedMethod.EMPTY_ARRAY;
        private boolean skipNameValidationForTesting;

        private Builder(DexItemFactory dexItemFactory) {
            this.superType = dexItemFactory.objectType;
            this.skipNameValidationForTesting = dexItemFactory.getSkipNameValidationForTesting();
        }

        private boolean validate() {
            assert (this.type != null);
            assert (this.accessFlags != null);
            return true;
        }

        public Builder setAccessFlags(ClassAccessFlags accessFlags) {
            this.accessFlags = accessFlags;
            return this;
        }

        public Builder setDirectMethods(Collection<DexEncodedMethod> directMethods) {
            this.directMethods = directMethods.toArray(DexEncodedMethod.EMPTY_ARRAY);
            return this;
        }

        public Builder setType(DexType type) {
            this.type = type;
            return this;
        }

        public DexLibraryClass build() {
            assert (this.validate());
            return new DexLibraryClass(this.type, ProgramResource.Kind.CF, this.origin, this.accessFlags, this.superType, this.interfaces, this.sourceFile, this.nestHost, this.nestMembers, this.enclosingMember, this.innerClasses, this.classSignature, this.annotations, this.staticFields, this.instanceFields, MethodCollection.MethodCollectionFactory.fromMethods(this.directMethods, this.virtualMethods), this.skipNameValidationForTesting);
        }
    }
}

