/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.NamingLensComparable;
import com.android.tools.r8.graph.ProgramMember;
import java.util.function.Function;

public abstract class DexMember<D extends DexEncodedMember<D, R>, R extends DexMember<D, R>>
extends DexReference
implements NamingLensComparable<R> {
    public final DexType holder;
    public final DexString name;

    public DexMember(DexType holder, DexString name) {
        assert (holder != null);
        this.holder = holder;
        assert (name != null);
        this.name = name;
    }

    public abstract <T> T apply(Function<DexField, T> var1, Function<DexMethod, T> var2);

    public abstract DexEncodedMember<?, ?> lookupOnClass(DexClass var1);

    public abstract DexClassAndMember<?, ?> lookupMemberOnClass(DexClass var1);

    public abstract ProgramMember<?, ?> lookupOnProgramClass(DexProgramClass var1);

    public abstract boolean match(R var1);

    public abstract boolean match(D var1);

    @Override
    public DexType getContextType() {
        return this.holder;
    }

    public DexType getHolderType() {
        return this.holder;
    }

    public DexString getName() {
        return this.name;
    }

    @Override
    public boolean isDexMember() {
        return true;
    }

    public DexMember<D, R> asDexMember() {
        return this;
    }

    public abstract Iterable<DexType> getReferencedTypes();

    public Iterable<DexType> getReferencedBaseTypes(DexItemFactory dexItemFactory) {
        return Iterables.transform(this.getReferencedTypes(), type -> type.toBaseType(dexItemFactory));
    }

    public abstract DexMember<D, R> withHolder(DexType var1, DexItemFactory var2);
}

