/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.NamingLensComparable;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.IdentifierUtils;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.ThrowingCharIterator;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.io.UTFDataFormatException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class DexString
extends IndexedDexItem
implements NamingLensComparable<DexString> {
    public static final DexString[] EMPTY_ARRAY = new DexString[0];
    private static final int ARRAY_CHARACTER = 91;
    public final int size;
    public final byte[] content;

    DexString(int size, byte[] content) {
        this.size = size;
        this.content = content;
    }

    DexString(String string) {
        this.size = string.length();
        this.content = DexString.encodeToMutf8(string);
    }

    private String decode() throws UTFDataFormatException {
        char[] out = new char[this.size];
        int decodedLength = this.decodePrefix(out);
        return new String(out, 0, decodedLength);
    }

    private static int countBytes(String string) {
        int result = 1;
        for (int i = 0; i < string.length(); ++i) {
            assert ((result += DexString.countBytes(string.charAt(i))) > 0);
        }
        return result;
    }

    public static int countBytes(char ch) {
        if (ch != '\u0000' && ch <= '\u007f') {
            return 1;
        }
        if (ch <= '\u07ff') {
            return 2;
        }
        return 3;
    }

    public static byte[] encodeToMutf8(String string) {
        byte[] result = new byte[DexString.countBytes(string)];
        int offset = 0;
        for (int i = 0; i < string.length(); ++i) {
            offset = DexString.encodeToMutf8(string.charAt(i), result, offset);
        }
        result[offset] = 0;
        return result;
    }

    public static int encodeToMutf8(char ch, byte[] array, int offset) {
        if (ch != '\u0000' && ch <= '\u007f') {
            array[offset++] = (byte)ch;
        } else if (ch <= '\u07ff') {
            array[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
            array[offset++] = (byte)(0x80 | 0x3F & ch);
        } else {
            array[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            array[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            array[offset++] = (byte)(0x80 | 0x3F & ch);
        }
        return offset;
    }

    private int internalCompareTo(DexString other) {
        int index = 0;
        while (true) {
            char b2;
            char b1;
            int diff;
            if ((diff = (b1 = (char)(this.content[index] & 0xFF)) - (b2 = (char)(other.content[index] & 0xFF))) != 0) {
                if (b1 == '\u0000' || b2 == '\u0000') {
                    return diff;
                }
                if (b1 == '\u00c0' && (this.content[index + 1] & 0xFF) == 128 || b2 == '\u00c0' && (other.content[index + 1] & 0xFF) == 128) {
                    return b1 == '\u00c0' && (this.content[index + 1] & 0xFF) == 128 ? -1 : 1;
                }
                return diff;
            }
            if (b1 == '\u0000') {
                return 0;
            }
            ++index;
        }
    }

    private static boolean isValidClassDescriptor(String string) {
        int cp;
        if (string.length() < 3 || string.charAt(0) != 'L' || string.charAt(string.length() - 1) != ';') {
            return false;
        }
        if (string.charAt(1) == '/' || string.charAt(string.length() - 2) == '/') {
            return false;
        }
        for (int i = 1; i < string.length() - 1; i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            if (cp == 47 || IdentifierUtils.isRelaxedDexIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidMethodName(String string) {
        int cp;
        if (string.isEmpty()) {
            return false;
        }
        if (string.charAt(0) == '<' && (string.equals("<init>") || string.equals("<clinit>"))) {
            return true;
        }
        for (int i = 0; i < string.length(); i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            if (IdentifierUtils.isRelaxedDexIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFieldName(String string) {
        int cp;
        if (string.isEmpty()) {
            return false;
        }
        int start = 0;
        int end = string.length();
        if (string.charAt(0) == '<') {
            if (string.charAt(end - 1) == '>') {
                start = 1;
                --end;
            } else {
                return false;
            }
        }
        for (int i = start; i < end; i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            if (IdentifierUtils.isRelaxedDexIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSimpleName(AndroidApiLevel apiLevel, String string) {
        if (apiLevel.isLessThan(AndroidApiLevel.R)) {
            int cp;
            for (int i = 0; i < string.length(); i += Character.charCount(cp)) {
                cp = string.codePointAt(i);
                if (!IdentifierUtils.isUnicodeSpace(cp)) continue;
                return false;
            }
        }
        return true;
    }

    private int getArrayDim() {
        int arrayDim = 0;
        while (this.content[arrayDim] == 91) {
            ++arrayDim;
        }
        return arrayDim;
    }

    @Override
    public DexString self() {
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public StructuralMapping<DexString> getStructuralMapping() {
        throw new Unreachable();
    }

    public byte byteAt(int index) {
        return this.content[index];
    }

    @Override
    public int compareTo(DexString other) {
        return this.internalCompareTo(other);
    }

    @Override
    public int acceptCompareTo(DexString other, CompareToVisitor visitor) {
        return visitor.visitDexString(this, other);
    }

    @Override
    public void acceptHashing(HashingVisitor visitor) {
        visitor.visitDexString(this);
    }

    public ThrowingCharIterator<UTFDataFormatException> iterator() {
        return new ThrowingCharIterator<UTFDataFormatException>(){
            private int i = 0;

            @Override
            public char nextChar() throws UTFDataFormatException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                char a = (char)(DexString.this.content[this.i++] & 0xFF);
                assert (a != '\u0000');
                if (a < '\u0080') {
                    return a;
                }
                if ((a & 0xE0) == 192) {
                    int b;
                    if (((b = DexString.this.content[this.i++] & 0xFF) & 0xC0) == 128) {
                        return (char)((a & 0x1F) << 6 | b & 0x3F);
                    }
                    throw new UTFDataFormatException("bad second byte");
                }
                if ((a & 0xF0) == 224) {
                    int b = DexString.this.content[this.i++] & 0xFF;
                    int c = DexString.this.content[this.i++] & 0xFF;
                    if ((b & 0xC0) == 128 && (c & 0xC0) == 128) {
                        return (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                    }
                    throw new UTFDataFormatException("bad second or third byte");
                }
                throw new UTFDataFormatException("bad byte");
            }

            @Override
            public boolean hasNext() {
                return this.i < DexString.this.content.length && (DexString.this.content[this.i] & 0xFF) != 0;
            }
        };
    }

    @Override
    public int computeHashCode() {
        return this.size * 7 + Arrays.hashCode(this.content);
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexString) {
            DexString o = (DexString)other;
            return this.size == o.size && Arrays.equals(this.content, o.content);
        }
        return false;
    }

    public String toString() {
        try {
            return this.decode();
        }
        catch (UTFDataFormatException e) {
            throw new RuntimeException("Bad format", e);
        }
    }

    public String toASCIIString() {
        try {
            return StringUtils.toASCIIString(this.decode());
        }
        catch (UTFDataFormatException e) {
            throw new RuntimeException("Bad format", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int decodePrefix(char[] out) throws UTFDataFormatException {
        block4: {
            s = 0;
            p = 0;
            prefixLength = out.length;
            do lbl-1000:
            // 4 sources

            {
                block6: {
                    block5: {
                        if ((a = (char)(this.content[p++] & 255)) == '\u0000') {
                            return s;
                        }
                        out[s] = a;
                        if (a >= '\u0080') break block5;
                        if (++s != prefixLength) ** GOTO lbl-1000
                        return s;
                    }
                    if ((a & 224) != 192) break block6;
                    if (((b = this.content[p++] & 255) & 192) != 128) {
                        throw new UTFDataFormatException("bad second byte");
                    }
                    out[s] = (char)((a & 31) << 6 | b & 63);
                    if (++s != prefixLength) ** GOTO lbl-1000
                    return s;
                }
                if ((a & 240) != 224) break block4;
                b = this.content[p++] & 255;
                c = this.content[p++] & 255;
                if ((b & 192) != 128 || (c & 192) != 128) {
                    throw new UTFDataFormatException("bad second or third byte");
                }
                out[s] = (char)((a & 15) << 12 | (b & 63) << 6 | c & 63);
            } while (++s != prefixLength);
            return s;
        }
        throw new UTFDataFormatException("bad byte");
    }

    public int decodedHashCode() throws UTFDataFormatException {
        char a;
        if (this.size == 0) {
            assert (this.decode().hashCode() == 0);
            return 0;
        }
        int h2 = 0;
        int p = 0;
        while ((a = (char)(this.content[p++] & 0xFF)) != '\u0000') {
            int b;
            if (a < '\u0080') {
                h2 = 31 * h2 + a;
                continue;
            }
            if ((a & 0xE0) == 192) {
                if (((b = this.content[p++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                h2 = 31 * h2 + (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                b = this.content[p++] & 0xFF;
                int c = this.content[p++] & 0xFF;
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second or third byte");
                }
                h2 = 31 * h2 + (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("bad byte");
        }
        assert (h2 == this.decode().hashCode());
        return h2;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        indexedItems.addString(this);
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    public boolean isValidMethodName() {
        try {
            return DexString.isValidMethodName(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public boolean isValidFieldName() {
        try {
            return DexString.isValidFieldName(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public boolean isValidClassDescriptor() {
        try {
            return DexString.isValidClassDescriptor(this.decode());
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public boolean isValidSimpleName(AndroidApiLevel apiLevel) {
        if (apiLevel.isLessThan(AndroidApiLevel.R)) {
            try {
                return DexString.isValidSimpleName(apiLevel, this.decode());
            }
            catch (UTFDataFormatException e) {
                return false;
            }
        }
        return true;
    }

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString());
        builder.append(" [");
        for (int i = 0; i < this.content.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(Integer.toHexString(this.content[i] & 0xFF));
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean startsWith(DexString prefix) {
        return this.startsWith(prefix.content);
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(DexString.encodeToMutf8(prefix));
    }

    public boolean startsWith(byte[] prefixContent) {
        if (this.content.length < prefixContent.length) {
            return false;
        }
        for (int i = 0; i < prefixContent.length - 1; ++i) {
            if (this.content[i] == prefixContent[i]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(DexString s2) {
        int index = 0;
        while (this.content.length - index >= s2.content.length) {
            int i;
            for (i = 0; i < s2.content.length - 1 && this.content[index + i] == s2.content[i]; ++i) {
            }
            if (i == s2.content.length - 1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean endsWith(DexString suffix) {
        if (this.content.length < suffix.content.length) {
            return false;
        }
        int i = this.content.length - suffix.content.length;
        int j = 0;
        while (i < this.content.length) {
            if (this.content[i] != suffix.content[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public DexString withNewPrefix(DexString prefix, DexString rewrittenPrefix, DexItemFactory factory) {
        int arrayDim = this.getArrayDim();
        int newSize = rewrittenPrefix.size + this.size - prefix.size;
        byte[] newContent = new byte[rewrittenPrefix.content.length + this.content.length - prefix.content.length];
        for (int i = 0; i < arrayDim; ++i) {
            newContent[i] = 91;
        }
        System.arraycopy(rewrittenPrefix.content, 0, newContent, arrayDim, rewrittenPrefix.content.length - 1);
        System.arraycopy(this.content, prefix.content.length - 1, newContent, rewrittenPrefix.content.length - 1, this.content.length - prefix.content.length + 1);
        return factory.createString(newSize, newContent);
    }

    public DexString withoutArray(DexItemFactory factory) {
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            return this;
        }
        byte[] newContent = new byte[this.content.length - arrayDim];
        System.arraycopy(this.content, arrayDim, newContent, 0, newContent.length);
        return factory.createString(this.size - arrayDim, newContent);
    }

    public DexString toArrayDescriptor(int dimensions, DexItemFactory dexItemFactory) {
        byte[] newContent = new byte[this.content.length + dimensions];
        Arrays.fill(newContent, 0, dimensions, (byte)91);
        System.arraycopy(this.content, 0, newContent, dimensions, this.content.length);
        return dexItemFactory.createString(this.size + dimensions, newContent);
    }
}

