/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;

public class DexTypeUtils {
    public static DexType computeLeastUpperBound(AppView<? extends AppInfoWithClassHierarchy> appView, Iterable<DexType> types) {
        TypeElement join = TypeElement.join(Iterables.transform(types, type -> type.toTypeElement(appView)), appView);
        return DexTypeUtils.toDexType(appView, join);
    }

    private static DexType toDexType(AppView<? extends AppInfoWithClassHierarchy> appView, TypeElement type) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        if (type.isPrimitiveType()) {
            return type.asPrimitiveType().toDexType(dexItemFactory);
        }
        if (type.isArrayType()) {
            ArrayTypeElement arrayType = type.asArrayType();
            DexType baseType = DexTypeUtils.toDexType(appView, arrayType.getBaseType());
            return baseType.toArrayType(arrayType.getNesting(), dexItemFactory);
        }
        assert (type.isClassType());
        ClassTypeElement classType = type.asClassType();
        if (classType.getClassType() != dexItemFactory.objectType) {
            return classType.getClassType();
        }
        if (classType.getInterfaces().hasSingleKnownInterface()) {
            return classType.getInterfaces().getSingleKnownInterface();
        }
        return dexItemFactory.objectType;
    }
}

