/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.DexOutputBuffer;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.naming.dexitembasedstring.NameComputationInfo;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.EncodedValueUtils;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import java.util.Arrays;
import java.util.function.Consumer;

public abstract class DexValue
extends DexItem
implements StructuralItem<DexValue> {
    public static final DexValue[] EMPTY_ARRAY = new DexValue[0];

    static DexValue fromAsmBootstrapArgument(Object value, JarApplicationReader application, DexType clazz) {
        if (value instanceof Integer) {
            return DexValueInt.create((Integer)value);
        }
        if (value instanceof Long) {
            return DexValueLong.create((Long)value);
        }
        if (value instanceof Float) {
            return DexValueFloat.create(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return DexValueDouble.create((Double)value);
        }
        if (value instanceof String) {
            return new DexValueString(application.getString((String)value));
        }
        if (value instanceof Type) {
            Type type = (Type)value;
            switch (type.getSort()) {
                case 10: {
                    return new DexValueType(application.getTypeFromDescriptor(((Type)value).getDescriptor()));
                }
                case 11: {
                    return new DexValueMethodType(application.getProto(((Type)value).getDescriptor()));
                }
            }
            throw new Unreachable("Type sort is not supported: " + type.getSort());
        }
        if (value instanceof Handle) {
            return new DexValueMethodHandle(DexMethodHandle.fromAsmHandle((Handle)value, application, clazz));
        }
        throw new Unreachable("Unsupported bootstrap static argument of type " + value.getClass().getSimpleName());
    }

    private static void writeHeader(DexValueKind kind, int arg, DexOutputBuffer dest) {
        dest.putByte((byte)(arg << 5 | kind.toByte()));
    }

    public static DexValue defaultForType(DexType type) {
        switch (type.toShorty()) {
            case 'Z': {
                return DexValueBoolean.DEFAULT;
            }
            case 'B': {
                return DexValueByte.DEFAULT;
            }
            case 'C': {
                return DexValueChar.DEFAULT;
            }
            case 'S': {
                return DexValueShort.DEFAULT;
            }
            case 'I': {
                return DexValueInt.DEFAULT;
            }
            case 'J': {
                return DexValueLong.DEFAULT;
            }
            case 'F': {
                return DexValueFloat.DEFAULT;
            }
            case 'D': {
                return DexValueDouble.DEFAULT;
            }
            case 'L': {
                return DexValueNull.NULL;
            }
        }
        throw new Unreachable("No default value for unexpected type " + type);
    }

    @Override
    public DexValue self() {
        return this;
    }

    @Override
    public final StructuralMapping<DexValue> getStructuralMapping() {
        throw new Unreachable();
    }

    @Override
    public final int acceptCompareTo(DexValue other, CompareToVisitor visitor) {
        if (this.getValueKind() != other.getValueKind()) {
            return visitor.visitInt(this.getValueKind().toByte(), other.getValueKind().toByte());
        }
        return this.internalAcceptCompareTo(other, visitor);
    }

    @Override
    public final void acceptHashing(HashingVisitor visitor) {
        visitor.visitInt(this.getValueKind().toByte());
        this.internalAcceptHashing(visitor);
    }

    abstract int internalAcceptCompareTo(DexValue var1, CompareToVisitor var2);

    abstract void internalAcceptHashing(HashingVisitor var1);

    public abstract DexValueKind getValueKind();

    public boolean isDexItemBasedValueString() {
        return false;
    }

    public DexItemBasedValueString asDexItemBasedValueString() {
        return null;
    }

    public boolean isDexValueMethodHandle() {
        return false;
    }

    public DexValueMethodHandle asDexValueMethodHandle() {
        return null;
    }

    public boolean isDexValueMethodType() {
        return false;
    }

    public DexValueMethodType asDexValueMethodType() {
        return null;
    }

    public boolean isDexValueAnnotation() {
        return false;
    }

    public DexValueAnnotation asDexValueAnnotation() {
        return null;
    }

    public boolean isDexValueArray() {
        return false;
    }

    public DexValueArray asDexValueArray() {
        return null;
    }

    public boolean isDexValueBoolean() {
        return false;
    }

    public DexValueBoolean asDexValueBoolean() {
        return null;
    }

    public boolean isDexValueByte() {
        return false;
    }

    public DexValueByte asDexValueByte() {
        return null;
    }

    public boolean isDexValueDouble() {
        return false;
    }

    public DexValueDouble asDexValueDouble() {
        return null;
    }

    public boolean isDexValueChar() {
        return false;
    }

    public DexValueChar asDexValueChar() {
        return null;
    }

    public boolean isDexValueEnum() {
        return false;
    }

    public DexValueEnum asDexValueEnum() {
        return null;
    }

    public boolean isDexValueField() {
        return false;
    }

    public DexValueField asDexValueField() {
        return null;
    }

    public boolean isDexValueFloat() {
        return false;
    }

    public DexValueFloat asDexValueFloat() {
        return null;
    }

    public boolean isDexValueInt() {
        return false;
    }

    public DexValueInt asDexValueInt() {
        return null;
    }

    public boolean isDexValueLong() {
        return false;
    }

    public DexValueLong asDexValueLong() {
        return null;
    }

    public boolean isDexValueMethod() {
        return false;
    }

    public DexValueMethod asDexValueMethod() {
        return null;
    }

    public boolean isDexValueNull() {
        return false;
    }

    public DexValueNull asDexValueNull() {
        return null;
    }

    public boolean isDexValueNumber() {
        return false;
    }

    public DexValueNumber asDexValueNumber() {
        return null;
    }

    public boolean isDexValueShort() {
        return false;
    }

    public DexValueShort asDexValueShort() {
        return null;
    }

    public boolean isDexValueString() {
        return false;
    }

    public DexValueString asDexValueString() {
        return null;
    }

    public boolean isDexValueType() {
        return false;
    }

    public DexValueType asDexValueType() {
        return null;
    }

    public boolean isNestedDexValue() {
        return false;
    }

    public abstract AbstractValue toAbstractValue(AbstractValueFactory var1);

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public abstract void sort();

    public abstract void writeTo(DexOutputBuffer var1, ObjectToOffsetMapping var2);

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract DexType getType(DexItemFactory var1);

    public abstract Object getBoxedValue();

    public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
        return null;
    }

    public boolean isDefault(DexType type) {
        return this == DexValue.defaultForType(type);
    }

    public boolean mayHaveSideEffects() {
        return true;
    }

    public abstract Object asAsmEncodedObject();

    public static class DexValueMethodHandle
    extends NestedDexValue<DexMethodHandle> {
        public DexValueMethodHandle(DexMethodHandle value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexMethodHandle)this.value).acceptCompareTo((DexMethodHandle)other.asDexValueMethodHandle().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexMethodHandle)this.value).acceptHashing(visitor);
        }

        @Override
        public boolean isDexValueMethodHandle() {
            return true;
        }

        @Override
        public DexValueMethodHandle asDexValueMethodHandle() {
            return this;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.METHOD_HANDLE;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexMethodHandle)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexValueBoolean
    extends DexValueNumber {
        private static final DexValueBoolean TRUE = new DexValueBoolean(true);
        private static final DexValueBoolean FALSE = new DexValueBoolean(false);
        private static final DexValueBoolean DEFAULT = new DexValueBoolean(false);
        final boolean value;

        private DexValueBoolean(boolean value) {
            this.value = value;
        }

        public static DexValueBoolean create(boolean value) {
            return value ? TRUE : FALSE;
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitBool(this.value, other.asDexValueBoolean().value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitBool(this.value);
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.BOOLEAN;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.booleanType;
        }

        @Override
        public long getRawValue() {
            return BooleanUtils.longValue(this.value);
        }

        @Override
        public boolean isDexValueBoolean() {
            return true;
        }

        @Override
        public DexValueBoolean asDexValueBoolean() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader(DexValueKind.BOOLEAN, this.value ? 1 : 0, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value ? 1 : 0;
        }

        @Override
        public int hashCode() {
            return this.value ? 1234 : 4321;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueBoolean && ((DexValueBoolean)other).value == this.value;
        }

        @Override
        public String toString() {
            return this.value ? "True" : "False";
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createIntConstant(BooleanUtils.intValue(this.value), local);
        }
    }

    public static class DexValueNull
    extends DexValueNumber {
        public static final DexValue NULL = new DexValueNull();

        private DexValueNull() {
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            assert (this == NULL);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            assert (this == NULL);
            assert (other == NULL);
            return 0;
        }

        public Object getValue() {
            return null;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.NULL;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            throw new Unreachable();
        }

        @Override
        public long getRawValue() {
            return 0L;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader(DexValueKind.NULL, 0, dest);
        }

        @Override
        public boolean isDexValueNull() {
            return true;
        }

        @Override
        public DexValueNull asDexValueNull() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return null;
        }

        @Override
        public Object asAsmEncodedObject() {
            return null;
        }

        @Override
        public int hashCode() {
            return 42;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueNull;
        }

        @Override
        public String toString() {
            return "Null";
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createConstNull(local);
        }
    }

    public static class DexValueAnnotation
    extends DexValue {
        public final DexEncodedAnnotation value;

        public DexValueAnnotation(DexEncodedAnnotation value) {
            this.value = value;
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return this.value.acceptCompareTo(other.asDexValueAnnotation().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            this.value.acceptHashing(visitor);
        }

        public DexEncodedAnnotation getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.ANNOTATION;
        }

        @Override
        public boolean isDexValueAnnotation() {
            return true;
        }

        @Override
        public DexValueAnnotation asDexValueAnnotation() {
            return this;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            this.value.collectIndexedItems(indexedItems);
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader(DexValueKind.ANNOTATION, 0, dest);
            FileWriter.writeEncodedAnnotation(this.value, dest, mapping);
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            throw new Unreachable();
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValueAnnotation");
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValueAnnotation");
        }

        @Override
        public void sort() {
            this.value.sort();
        }

        @Override
        public int hashCode() {
            return this.value.hashCode() * 7;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DexValueAnnotation) {
                DexValueAnnotation that = (DexValueAnnotation)other;
                return that.value.equals(this.value);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Annotation " + this.value;
        }
    }

    public static class DexValueArray
    extends DexValue {
        final DexValue[] values;

        public DexValueArray(DexValue[] values2) {
            this.values = values2;
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitItemArray(this.values, other.asDexValueArray().values);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitItemArray(this.values);
        }

        public void forEachElement(Consumer<DexValue> consumer) {
            for (DexValue value : this.values) {
                consumer.accept(value);
            }
        }

        public DexValue[] getValues() {
            return this.values;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.ARRAY;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            for (DexValue value : this.values) {
                value.collectIndexedItems(indexedItems);
            }
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader(DexValueKind.ARRAY, 0, dest);
            dest.putUleb128(this.values.length);
            for (DexValue value : this.values) {
                value.writeTo(dest, mapping);
            }
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            throw new Unreachable();
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValueArray");
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValueArray");
        }

        @Override
        public void sort() {
            for (DexValue value : this.values) {
                value.sort();
            }
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DexValueArray) {
                DexValueArray that = (DexValueArray)other;
                return Arrays.equals(that.values, this.values);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Array " + Arrays.toString(this.values);
        }

        @Override
        public boolean isDexValueArray() {
            return true;
        }

        @Override
        public DexValueArray asDexValueArray() {
            return this;
        }
    }

    public static class DexValueMethodType
    extends NestedDexValue<DexProto> {
        public DexValueMethodType(DexProto value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexProto)this.value).acceptCompareTo((DexProto)other.asDexValueMethodType().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexProto)this.value).acceptHashing(visitor);
        }

        @Override
        public boolean isDexValueMethodType() {
            return true;
        }

        @Override
        public DexValueMethodType asDexValueMethodType() {
            return this;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.METHOD_TYPE;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexProto)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexValueEnum
    extends NestedDexValue<DexField> {
        public DexValueEnum(DexField value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexField)this.value).acceptCompareTo((DexField)other.asDexValueEnum().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexField)this.value).acceptHashing(visitor);
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.ENUM;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexField)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public boolean isDexValueEnum() {
            return true;
        }

        @Override
        public DexValueEnum asDexValueEnum() {
            return this;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexValueMethod
    extends NestedDexValue<DexMethod> {
        public DexValueMethod(DexMethod value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexMethod)this.value).acceptCompareTo((DexMethod)other.asDexValueMethod().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexMethod)this.value).acceptHashing(visitor);
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.METHOD;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexMethod)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public boolean isDexValueMethod() {
            return true;
        }

        @Override
        public DexValueMethod asDexValueMethod() {
            return this;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexValueField
    extends NestedDexValue<DexField> {
        public DexValueField(DexField value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexField)this.value).acceptCompareTo((DexField)other.asDexValueField().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexField)this.value).acceptHashing(visitor);
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.FIELD;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexField)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public boolean isDexValueField() {
            return true;
        }

        @Override
        public DexValueField asDexValueField() {
            return this;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexValueType
    extends NestedDexValue<DexType> {
        public DexValueType(DexType value) {
            super(value, null);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return ((DexType)this.value).acceptCompareTo((DexType)other.asDexValueType().value, visitor);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexType)this.value).acceptHashing(visitor);
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.TYPE;
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexType)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public DexValueType asDexValueType() {
            return this;
        }

        @Override
        public boolean isDexValueType() {
            return true;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return UnknownValue.getInstance();
        }
    }

    public static class DexItemBasedValueString
    extends NestedDexValue<DexReference> {
        private final NameComputationInfo<?> nameComputationInfo;

        static int compareAndCheckValueStrings(DexValue v1, DexValue v2, CompareToVisitor visitor) {
            assert (v1.getValueKind() == DexValueKind.STRING);
            assert (v2.getValueKind() == DexValueKind.STRING);
            int order1 = v1.isDexItemBasedValueString() ? 1 : 0;
            int order2 = v2.isDexItemBasedValueString() ? 1 : 0;
            return visitor.visitInt(order1, order2);
        }

        public DexItemBasedValueString(DexReference value, NameComputationInfo<?> nameComputationInfo) {
            super(value, null);
            this.nameComputationInfo = nameComputationInfo;
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitDexReference((DexReference)this.value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            int order = DexItemBasedValueString.compareAndCheckValueStrings(this, other, visitor);
            if (order != 0) {
                return order;
            }
            return visitor.visitDexReference((DexReference)this.value, (DexReference)other.asDexItemBasedValueString().value);
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexReference)this.value).collectIndexedItems(indexedItems);
        }

        public NameComputationInfo<?> getNameComputationInfo() {
            return this.nameComputationInfo;
        }

        @Override
        public boolean isDexItemBasedValueString() {
            return true;
        }

        @Override
        public DexItemBasedValueString asDexItemBasedValueString() {
            return this;
        }

        @Override
        public Object asAsmEncodedObject() {
            return ((DexReference)this.value).toString();
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.STRING;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.stringType;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            ClassTypeElement type = TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
            Value outValue = code.createValue(type, local);
            DexItemBasedConstString instruction = new DexItemBasedConstString(outValue, (DexReference)this.value, this.nameComputationInfo);
            assert (!instruction.instructionInstanceCanThrow());
            return instruction;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return factory.createSingleDexItemBasedStringValue((DexReference)this.value, this.nameComputationInfo);
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            throw new Unreachable("DexItemBasedValueString values should always be rewritten into DexValueString");
        }
    }

    public static class DexValueString
    extends NestedDexValue<DexString> {
        public DexValueString(DexString value) {
            super(value, null);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            ((DexString)this.value).acceptHashing(visitor);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            int order = DexItemBasedValueString.compareAndCheckValueStrings(this, other, visitor);
            if (order != 0) {
                return order;
            }
            return ((DexString)this.value).acceptCompareTo((DexString)other.asDexValueString().value, visitor);
        }

        @Override
        public void collectIndexedItems(IndexedItemCollection indexedItems) {
            ((DexString)this.value).collectIndexedItems(indexedItems);
        }

        @Override
        public DexValueString asDexValueString() {
            return this;
        }

        @Override
        public boolean isDexValueString() {
            return true;
        }

        @Override
        public Object asAsmEncodedObject() {
            return ((DexString)this.value).toString();
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.STRING;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.stringType;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            ClassTypeElement type = TypeElement.stringClassType(appView, Nullability.definitelyNotNull());
            Value outValue = code.createValue(type, local);
            ConstString instruction = new ConstString(outValue, (DexString)this.value);
            if (!instruction.instructionInstanceCanThrow()) {
                return instruction;
            }
            return null;
        }

        @Override
        public boolean mayHaveSideEffects() {
            return false;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return factory.createSingleStringValue((DexString)this.value);
        }
    }

    private static abstract class NestedDexValue<T extends IndexedDexItem>
    extends DexValue {
        public final T value;

        private NestedDexValue(T value) {
            this.value = value;
        }

        /* synthetic */ NestedDexValue(IndexedDexItem x0, 1 x1) {
            this(x0);
        }

        @Override
        public boolean isNestedDexValue() {
            return true;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            throw new Unreachable();
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            int offset = ((IndexedDexItem)this.value).getOffset(mapping);
            dest.forward(1);
            int length = dest.putUnsignedEncodedValue(offset, 4);
            dest.rewind(length + 1);
            DexValue.writeHeader(this.getValueKind(), length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object getBoxedValue() {
            throw new Unreachable("No boxed value for DexValue " + this.getClass().getSimpleName());
        }

        @Override
        public Object asAsmEncodedObject() {
            throw new Unreachable("No ASM conversion for DexValue " + this.getClass().getSimpleName());
        }

        @Override
        public void sort() {
        }

        @Override
        public int hashCode() {
            return ((CachedHashValueDexItem)this.value).hashCode() * 7 + this.getValueKind().toByte();
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof NestedDexValue) {
                NestedDexValue that = (NestedDexValue)other;
                return that.getValueKind() == this.getValueKind() && ((CachedHashValueDexItem)that.value).equals(this.value);
            }
            return false;
        }

        @Override
        public String toString() {
            return "Item " + (Object)((Object)this.getValueKind()) + " " + this.value;
        }
    }

    public static class DexValueDouble
    extends DexValueNumber {
        public static final DexValueDouble DEFAULT = new DexValueDouble(0.0);
        final double value;

        private DexValueDouble(double value) {
            this.value = value;
        }

        public static DexValueDouble create(double value) {
            return Double.compare(value, DexValueDouble.DEFAULT.value) == 0 ? DEFAULT : new DexValueDouble(value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitDouble(this.value, other.asDexValueDouble().value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitDouble(this.value);
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.DOUBLE;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.doubleType;
        }

        @Override
        public long getRawValue() {
            return Double.doubleToRawLongBits(this.value);
        }

        @Override
        public boolean isDexValueDouble() {
            return true;
        }

        @Override
        public DexValueDouble asDexValueDouble() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = EncodedValueUtils.putDouble(dest, this.value);
            dest.rewind(length + 1);
            DexValue.writeHeader(DexValueKind.DOUBLE, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createDoubleConstant(this.value, local);
        }

        @Override
        public int hashCode() {
            return (int)(this.value * 29.0);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueDouble && Double.compare(this.value, ((DexValueDouble)other).value) == 0;
        }

        @Override
        public String toString() {
            return "Double " + this.value;
        }
    }

    public static class DexValueFloat
    extends DexValueNumber {
        public static final DexValueFloat DEFAULT = new DexValueFloat(0.0f);
        final float value;

        private DexValueFloat(float value) {
            this.value = value;
        }

        public static DexValueFloat create(float value) {
            return Float.compare(value, DexValueFloat.DEFAULT.value) == 0 ? DEFAULT : new DexValueFloat(value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitFloat(this.value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitFloat(this.value, other.asDexValueFloat().value);
        }

        public float getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.FLOAT;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.floatType;
        }

        @Override
        public long getRawValue() {
            return Float.floatToIntBits(this.value);
        }

        @Override
        public boolean isDexValueFloat() {
            return true;
        }

        @Override
        public DexValueFloat asDexValueFloat() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return Float.valueOf(this.getValue());
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = EncodedValueUtils.putFloat(dest, this.value);
            dest.rewind(length + 1);
            DexValue.writeHeader(DexValueKind.FLOAT, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return Float.valueOf(this.value);
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createFloatConstant(this.value, local);
        }

        @Override
        public int hashCode() {
            return (int)(this.value * 19.0f);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueFloat && Float.compare(this.value, ((DexValueFloat)other).value) == 0;
        }

        @Override
        public String toString() {
            return "Float " + this.value;
        }
    }

    public static class DexValueLong
    extends DexValueNumber {
        public static final DexValueLong DEFAULT = new DexValueLong(0L);
        final long value;

        private DexValueLong(long value) {
            this.value = value;
        }

        public static DexValueLong create(long value) {
            return value == DexValueLong.DEFAULT.value ? DEFAULT : new DexValueLong(value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitLong(this.value, other.asDexValueLong().value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitLong(this.value);
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.LONG;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.longType;
        }

        @Override
        public long getRawValue() {
            return this.value;
        }

        @Override
        public boolean isDexValueLong() {
            return true;
        }

        @Override
        public DexValueLong asDexValueLong() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueLong.writeIntegerTo(DexValueKind.LONG, this.value, 8, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (int)this.value * 13;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueLong && this.value == ((DexValueLong)other).value;
        }

        @Override
        public String toString() {
            return "Long " + this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createLongConstant(this.value, local);
        }
    }

    public static class DexValueInt
    extends DexValueNumber {
        public static final DexValueInt DEFAULT = new DexValueInt(0);
        public final int value;

        private DexValueInt(int value) {
            this.value = value;
        }

        public static DexValueInt create(int value) {
            return value == DexValueInt.DEFAULT.value ? DEFAULT : new DexValueInt(value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitInt(this.value, other.asDexValueInt().value);
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.INT;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.intType;
        }

        @Override
        public long getRawValue() {
            return this.value;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueInt.writeIntegerTo(DexValueKind.INT, this.value, 4, dest);
        }

        @Override
        public boolean isDexValueInt() {
            return true;
        }

        @Override
        public DexValueInt asDexValueInt() {
            return this;
        }

        @Override
        public Object asAsmEncodedObject() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 11;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueInt && this.value == ((DexValueInt)other).value;
        }

        @Override
        public String toString() {
            return "Int " + this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createIntConstant(this.value, local);
        }
    }

    public static class DexValueChar
    extends DexValueNumber {
        public static final DexValueChar DEFAULT = new DexValueChar('\u0000');
        final char value;

        private DexValueChar(char value) {
            this.value = value;
        }

        public static DexValueChar create(char value) {
            return value == DexValueChar.DEFAULT.value ? DEFAULT : new DexValueChar(value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitInt(this.value, other.asDexValueChar().value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.value);
        }

        public char getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.CHAR;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.charType;
        }

        @Override
        public long getRawValue() {
            return this.value;
        }

        @Override
        public boolean isDexValueChar() {
            return true;
        }

        @Override
        public DexValueChar asDexValueChar() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return Character.valueOf(this.getValue());
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            dest.forward(1);
            int length = dest.putUnsignedEncodedValue(this.value, 2);
            dest.rewind(length + 1);
            DexValue.writeHeader(DexValueKind.CHAR, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 5;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueChar && this.value == ((DexValueChar)other).value;
        }

        @Override
        public String toString() {
            return "Char " + this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createIntConstant(this.value, local);
        }
    }

    public static class DexValueShort
    extends DexValueNumber {
        public static final DexValueShort DEFAULT = new DexValueShort(0);
        final short value;

        private DexValueShort(short value) {
            this.value = value;
        }

        public static DexValueShort create(short value) {
            return value == DexValueShort.DEFAULT.value ? DEFAULT : new DexValueShort(value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitInt(this.value, other.asDexValueShort().getValue());
        }

        public short getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.SHORT;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.shortType;
        }

        @Override
        public long getRawValue() {
            return this.value;
        }

        @Override
        public boolean isDexValueShort() {
            return true;
        }

        @Override
        public DexValueShort asDexValueShort() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValueShort.writeIntegerTo(DexValueKind.SHORT, this.value, 2, dest);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 7;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueShort && this.value == ((DexValueShort)other).value;
        }

        @Override
        public String toString() {
            return "Short " + this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createIntConstant(this.value, local);
        }
    }

    public static class DexValueByte
    extends DexValueNumber {
        public static final DexValueByte DEFAULT = new DexValueByte(0);
        final byte value;

        private DexValueByte(byte value) {
            this.value = value;
        }

        public static DexValueByte create(byte value) {
            return value == DexValueByte.DEFAULT.value ? DEFAULT : new DexValueByte(value);
        }

        @Override
        int internalAcceptCompareTo(DexValue other, CompareToVisitor visitor) {
            return visitor.visitInt(this.value, other.asDexValueByte().value);
        }

        @Override
        void internalAcceptHashing(HashingVisitor visitor) {
            visitor.visitInt(this.value);
        }

        public byte getValue() {
            return this.value;
        }

        @Override
        public DexValueKind getValueKind() {
            return DexValueKind.BYTE;
        }

        @Override
        public DexType getType(DexItemFactory factory) {
            return factory.byteType;
        }

        @Override
        public long getRawValue() {
            return this.value;
        }

        @Override
        public boolean isDexValueByte() {
            return true;
        }

        @Override
        public DexValueByte asDexValueByte() {
            return this;
        }

        @Override
        public Object getBoxedValue() {
            return this.getValue();
        }

        @Override
        public void writeTo(DexOutputBuffer dest, ObjectToOffsetMapping mapping) {
            DexValue.writeHeader(DexValueKind.BYTE, 0, dest);
            dest.putSignedEncodedValue(this.value, 1);
        }

        @Override
        public Object asAsmEncodedObject() {
            return (int)this.value;
        }

        @Override
        public int hashCode() {
            return this.value * 3;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof DexValueByte && this.value == ((DexValueByte)other).value;
        }

        @Override
        public String toString() {
            return "Byte " + this.value;
        }

        @Override
        public ConstInstruction asConstInstruction(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, DebugLocalInfo local) {
            return code.createIntConstant(this.value, local);
        }
    }

    public static abstract class DexValueNumber
    extends SimpleDexValue {
        public abstract long getRawValue();

        @Override
        public boolean isDexValueNumber() {
            return true;
        }

        @Override
        public DexValueNumber asDexValueNumber() {
            return this;
        }

        @Override
        public AbstractValue toAbstractValue(AbstractValueFactory factory) {
            return factory.createSingleNumberValue(this.getRawValue());
        }
    }

    private static abstract class SimpleDexValue
    extends DexValue {
        private SimpleDexValue() {
        }

        static void writeIntegerTo(DexValueKind kind, long value, int expected, DexOutputBuffer dest) {
            dest.forward(1);
            int length = dest.putSignedEncodedValue(value, expected);
            dest.rewind(length + 1);
            DexValue.writeHeader(kind, length - 1, dest);
            dest.forward(length);
        }

        @Override
        public void sort() {
        }

        @Override
        public boolean mayHaveSideEffects() {
            return false;
        }
    }

    public static enum DexValueKind {
        BYTE(0),
        SHORT(2),
        CHAR(3),
        INT(4),
        LONG(6),
        FLOAT(16),
        DOUBLE(17),
        METHOD_TYPE(21),
        METHOD_HANDLE(22),
        STRING(23),
        TYPE(24),
        FIELD(25),
        METHOD(26),
        ENUM(27),
        ARRAY(28),
        ANNOTATION(29),
        NULL(30),
        BOOLEAN(31);

        private final byte b;

        public static DexValueKind fromId(int id) {
            switch (id) {
                case 0: {
                    return BYTE;
                }
                case 2: {
                    return SHORT;
                }
                case 3: {
                    return CHAR;
                }
                case 4: {
                    return INT;
                }
                case 6: {
                    return LONG;
                }
                case 16: {
                    return FLOAT;
                }
                case 17: {
                    return DOUBLE;
                }
                case 21: {
                    return METHOD_TYPE;
                }
                case 22: {
                    return METHOD_HANDLE;
                }
                case 23: {
                    return STRING;
                }
                case 24: {
                    return TYPE;
                }
                case 25: {
                    return FIELD;
                }
                case 26: {
                    return METHOD;
                }
                case 27: {
                    return ENUM;
                }
                case 28: {
                    return ARRAY;
                }
                case 29: {
                    return ANNOTATION;
                }
                case 30: {
                    return NULL;
                }
                case 31: {
                    return BOOLEAN;
                }
            }
            throw new Unreachable();
        }

        private DexValueKind(int b) {
            this.b = (byte)b;
        }

        byte toByte() {
            return this.b;
        }
    }
}

