/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AbstractAccessContexts;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FieldAccessInfoImpl
implements FieldAccessInfo {
    public static final FieldAccessInfoImpl MISSING_FIELD_ACCESS_INFO = new FieldAccessInfoImpl(null);
    public static int FLAG_IS_READ_FROM_ANNOTATION = 1;
    public static int FLAG_IS_READ_FROM_METHOD_HANDLE = 2;
    public static int FLAG_IS_WRITTEN_FROM_METHOD_HANDLE = 4;
    public static int FLAG_HAS_REFLECTIVE_ACCESS = 8;
    public static int FLAG_IS_READ_FROM_RECORD_INVOKE_DYNAMIC = 16;
    private DexField field;
    private int flags;
    private AbstractAccessContexts readsWithContexts = AbstractAccessContexts.empty();
    private AbstractAccessContexts writesWithContexts = AbstractAccessContexts.empty();

    public FieldAccessInfoImpl(DexField field) {
        this.field = field;
    }

    private void flattenAccessContexts(AbstractAccessContexts accessesWithContexts) {
        accessesWithContexts.flattenAccessContexts(this.field);
    }

    private void forEachIndirectAccess(Consumer<DexField> consumer, AbstractAccessContexts accessesWithContexts, Set<DexField> visited) {
        if (accessesWithContexts.isBottom()) {
            return;
        }
        if (accessesWithContexts.isConcrete()) {
            accessesWithContexts.asConcrete().forEachAccess(consumer, access -> access != this.field && visited.add((DexField)access));
            return;
        }
        throw new Unreachable("Should never be iterating the indirect accesses when they are unknown");
    }

    private static void addAccessesWithContextsToMap(AbstractAccessContexts accessesWithContexts, Predicate<DexField> predicate, Map<DexField, ProgramMethodSet> out) {
        if (accessesWithContexts.isBottom()) {
            return;
        }
        if (accessesWithContexts.isConcrete()) {
            FieldAccessInfoImpl.extendAccessesWithContexts(accessesWithContexts.asConcrete().getAccessesWithContexts(), predicate, out);
            return;
        }
        throw new Unreachable("Should never be iterating the indirect accesses when they are unknown");
    }

    private static void extendAccessesWithContexts(Map<DexField, ProgramMethodSet> accessesWithContexts, Predicate<DexField> predicate, Map<DexField, ProgramMethodSet> out) {
        accessesWithContexts.forEach((access, contexts) -> {
            if (predicate.test((DexField)access)) {
                out.computeIfAbsent((DexField)access, ignore -> ProgramMethodSet.create()).addAll((ProgramMethodSet)contexts);
            }
        });
    }

    void destroyAccessContexts() {
        this.readsWithContexts = AbstractAccessContexts.unknown();
        this.writesWithContexts = AbstractAccessContexts.unknown();
    }

    void flattenAccessContexts() {
        this.flattenAccessContexts(this.readsWithContexts);
        this.flattenAccessContexts(this.writesWithContexts);
    }

    @Override
    public FieldAccessInfoImpl asMutable() {
        return this;
    }

    @Override
    public DexField getField() {
        return this.field;
    }

    public AbstractAccessContexts getReadsWithContexts() {
        return this.readsWithContexts;
    }

    public void setReadsWithContexts(AbstractAccessContexts readsWithContexts) {
        this.readsWithContexts = readsWithContexts;
    }

    public void setWritesWithContexts(AbstractAccessContexts writesWithContexts) {
        this.writesWithContexts = writesWithContexts;
    }

    @Override
    public int getNumberOfReadContexts() {
        return this.readsWithContexts.getNumberOfAccessContexts();
    }

    @Override
    public int getNumberOfWriteContexts() {
        return this.writesWithContexts.getNumberOfAccessContexts();
    }

    @Override
    public ProgramMethod getUniqueReadContext() {
        return this.readsWithContexts.isConcrete() ? this.readsWithContexts.asConcrete().getUniqueAccessContext() : null;
    }

    @Override
    public boolean hasKnownWriteContexts() {
        return !this.writesWithContexts.isTop();
    }

    @Override
    public void forEachIndirectAccess(Consumer<DexField> consumer) {
        Set<DexField> visited = Sets.newIdentityHashSet();
        this.forEachIndirectAccess(consumer, this.readsWithContexts, visited);
        this.forEachIndirectAccess(consumer, this.writesWithContexts, visited);
    }

    @Override
    public void forEachIndirectAccessWithContexts(BiConsumer<DexField, ProgramMethodSet> consumer) {
        IdentityHashMap<DexField, ProgramMethodSet> indirectAccessesWithContexts = new IdentityHashMap<DexField, ProgramMethodSet>();
        FieldAccessInfoImpl.addAccessesWithContextsToMap(this.readsWithContexts, access -> access != this.field, indirectAccessesWithContexts);
        FieldAccessInfoImpl.addAccessesWithContextsToMap(this.writesWithContexts, access -> access != this.field, indirectAccessesWithContexts);
        indirectAccessesWithContexts.forEach(consumer);
    }

    @Override
    public void forEachReadContext(Consumer<ProgramMethod> consumer) {
        this.readsWithContexts.forEachAccessContext(consumer);
    }

    @Override
    public void forEachWriteContext(Consumer<ProgramMethod> consumer) {
        this.writesWithContexts.forEachAccessContext(consumer);
    }

    @Override
    public boolean hasReflectiveAccess() {
        return (this.flags & FLAG_HAS_REFLECTIVE_ACCESS) != 0;
    }

    public void setHasReflectiveAccess() {
        this.flags |= FLAG_HAS_REFLECTIVE_ACCESS;
    }

    @Override
    public boolean isRead() {
        return !this.readsWithContexts.isEmpty() || this.isReadFromAnnotation() || this.isReadFromMethodHandle() || this.isReadFromRecordInvokeDynamic();
    }

    @Override
    public boolean isReadFromAnnotation() {
        return (this.flags & FLAG_IS_READ_FROM_ANNOTATION) != 0;
    }

    public void setReadFromAnnotation() {
        this.flags |= FLAG_IS_READ_FROM_ANNOTATION;
    }

    @Override
    public boolean isReadFromMethodHandle() {
        return (this.flags & FLAG_IS_READ_FROM_METHOD_HANDLE) != 0;
    }

    @Override
    public boolean isReadFromRecordInvokeDynamic() {
        return (this.flags & FLAG_IS_READ_FROM_RECORD_INVOKE_DYNAMIC) != 0;
    }

    public void setReadFromMethodHandle() {
        this.flags |= FLAG_IS_READ_FROM_METHOD_HANDLE;
    }

    public void setReadFromRecordInvokeDynamic() {
        this.flags |= FLAG_IS_READ_FROM_RECORD_INVOKE_DYNAMIC;
    }

    public void clearReadFromRecordInvokeDynamic() {
        this.flags &= ~FLAG_IS_READ_FROM_RECORD_INVOKE_DYNAMIC;
    }

    @Override
    public boolean isWritten() {
        return !this.writesWithContexts.isEmpty();
    }

    @Override
    public boolean isWrittenFromMethodHandle() {
        return (this.flags & FLAG_IS_WRITTEN_FROM_METHOD_HANDLE) != 0;
    }

    public void setWrittenFromMethodHandle() {
        this.flags |= FLAG_IS_WRITTEN_FROM_METHOD_HANDLE;
    }

    @Override
    public boolean isWrittenInMethodSatisfying(Predicate<ProgramMethod> predicate) {
        return this.writesWithContexts.isAccessedInMethodSatisfying(predicate);
    }

    @Override
    public boolean isWrittenOnlyInMethodSatisfying(Predicate<ProgramMethod> predicate) {
        return this.writesWithContexts.isAccessedOnlyInMethodSatisfying(predicate);
    }

    @Override
    public boolean isReadOnlyInMethodSatisfying(Predicate<ProgramMethod> predicate) {
        return this.readsWithContexts.isAccessedOnlyInMethodSatisfying(predicate);
    }

    @Override
    public boolean isWrittenOutside(DexEncodedMethod method) {
        return this.writesWithContexts.isAccessedOutside(method);
    }

    public boolean recordRead(DexField access, ProgramMethod context) {
        if (this.readsWithContexts.isBottom()) {
            this.readsWithContexts = new AbstractAccessContexts.ConcreteAccessContexts();
        }
        if (this.readsWithContexts.isConcrete()) {
            return this.readsWithContexts.asConcrete().recordAccess(access, context);
        }
        return false;
    }

    public boolean recordWrite(DexField access, ProgramMethod context) {
        if (this.writesWithContexts.isBottom()) {
            this.writesWithContexts = new AbstractAccessContexts.ConcreteAccessContexts();
        }
        if (this.writesWithContexts.isConcrete()) {
            return this.writesWithContexts.asConcrete().recordAccess(access, context);
        }
        return false;
    }

    public void clearReads() {
        assert (!this.hasReflectiveAccess());
        assert (!this.isReadFromAnnotation());
        assert (!this.isReadFromMethodHandle());
        this.readsWithContexts = AbstractAccessContexts.empty();
        this.clearReadFromRecordInvokeDynamic();
    }

    public void clearWrites() {
        this.writesWithContexts = AbstractAccessContexts.empty();
    }

    public FieldAccessInfoImpl rewrittenWithLens(DexDefinitionSupplier definitions, GraphLens lens) {
        FieldAccessInfoImpl rewritten = new FieldAccessInfoImpl(lens.lookupField(this.field));
        rewritten.flags = this.flags;
        rewritten.readsWithContexts = this.readsWithContexts.rewrittenWithLens(definitions, lens);
        rewritten.writesWithContexts = this.writesWithContexts.rewrittenWithLens(definitions, lens);
        return rewritten;
    }

    public FieldAccessInfoImpl join(FieldAccessInfoImpl impl) {
        FieldAccessInfoImpl merged = new FieldAccessInfoImpl(this.field);
        merged.flags = this.flags | impl.flags;
        merged.readsWithContexts = this.readsWithContexts.join(impl.readsWithContexts);
        merged.writesWithContexts = this.writesWithContexts.join(impl.writesWithContexts);
        return merged;
    }
}

