/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.utils.SetUtils;
import java.util.Set;

public class FieldResolution {
    private final DexDefinitionSupplier definitionFor;

    public FieldResolution(DexDefinitionSupplier definitionFor) {
        this.definitionFor = definitionFor;
    }

    private FieldResolutionResult resolveFieldOn(DexClass holder, DexField field, DexClass initialResolutionHolder, Set<DexType> visitedInterfaces) {
        assert (holder != null);
        DexEncodedField definition = holder.lookupField(field);
        if (definition != null) {
            return FieldResolutionResult.createSingleFieldResolutionResult(initialResolutionHolder, holder, definition);
        }
        FieldResolutionResult result = this.resolveFieldOnDirectInterfaces(initialResolutionHolder, holder, field, visitedInterfaces);
        if (result != null) {
            return result;
        }
        if (holder.superType != null) {
            FieldResolutionResult.Builder builder = FieldResolutionResult.builder();
            this.definitionFor.contextIndependentDefinitionForWithResolutionResult(holder.superType).forEachClassResolutionResult(superClass -> {
                if (holder.isLibraryClass() && !superClass.isLibraryClass()) {
                    return;
                }
                builder.addResolutionResult(this.resolveFieldOn((DexClass)superClass, field, initialResolutionHolder, visitedInterfaces));
            });
            return builder.buildOrIfEmpty(null);
        }
        return FieldResolutionResult.failure();
    }

    private FieldResolutionResult resolveFieldOnDirectInterfaces(DexClass initialResolutionHolder, DexClass clazz, DexField field, Set<DexType> visitedInterfaces) {
        for (DexType interfaceType : clazz.interfaces.values) {
            if (!visitedInterfaces.add(interfaceType)) continue;
            FieldResolutionResult.Builder builder = FieldResolutionResult.builder();
            this.definitionFor.contextIndependentDefinitionForWithResolutionResult(interfaceType).forEachClassResolutionResult(ifaceClass -> {
                if (clazz.isLibraryClass() && !ifaceClass.isLibraryClass()) {
                    return;
                }
                builder.addResolutionResult(this.resolveFieldOnInterface(initialResolutionHolder, (DexClass)ifaceClass, field, visitedInterfaces));
            });
            FieldResolutionResult fieldResolutionResult = builder.buildOrIfEmpty(null);
            if (fieldResolutionResult == null) continue;
            return fieldResolutionResult;
        }
        return null;
    }

    private FieldResolutionResult resolveFieldOnInterface(DexClass initialResolutionHolder, DexClass interfaceClass, DexField field, Set<DexType> visitedInterfaces) {
        DexEncodedField definition = interfaceClass.lookupField(field);
        if (definition != null) {
            return FieldResolutionResult.createSingleFieldResolutionResult(initialResolutionHolder, interfaceClass, definition);
        }
        return this.resolveFieldOnDirectInterfaces(initialResolutionHolder, interfaceClass, field, visitedInterfaces);
    }

    public FieldResolutionResult resolveFieldOn(DexType type, DexField field) {
        FieldResolutionResult.Builder builder = FieldResolutionResult.builder();
        this.definitionFor.contextIndependentDefinitionForWithResolutionResult(type).forEachClassResolutionResult(clazz -> builder.addResolutionResult(this.resolveFieldOn((DexClass)clazz, field)));
        return builder.buildOrIfEmpty(FieldResolutionResult.failure());
    }

    public FieldResolutionResult resolveFieldOn(DexClass holder, DexField field) {
        assert (holder != null);
        return this.resolveFieldOn(holder, field, holder, SetUtils.newIdentityHashSet(8));
    }
}

