/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.InitClassLens;
import java.util.Map;

public class FinalInitClassLens
extends InitClassLens {
    private final Map<DexType, DexField> mapping;

    FinalInitClassLens(Map<DexType, DexField> mapping) {
        this.mapping = mapping;
    }

    @Override
    public DexField getInitClassField(DexType type) {
        DexField field = this.mapping.get(type);
        if (field != null) {
            return field;
        }
        throw new Unreachable("Unexpected InitClass instruction for `" + type.toSourceString() + "`");
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public InitClassLens rewrittenWithLens(GraphLens lens) {
        InitClassLens.Builder builder = InitClassLens.builder();
        this.mapping.forEach((type, field) -> {
            DexType rewrittenType = lens.lookupType((DexType)type);
            DexField rewrittenField = lens.lookupField((DexField)field);
            builder.map(rewrittenType, rewrittenField);
        });
        return builder.build();
    }
}

