/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.utils.WorkList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class GenericSignatureContextBuilder {
    private final Map<DexReference, TypeParameterSubstitutions> formalsInfo;
    private final Map<DexReference, DexReference> enclosingInfo;

    private GenericSignatureContextBuilder(Map<DexReference, TypeParameterSubstitutions> formalsInfo, Map<DexReference, DexReference> enclosingInfo) {
        this.formalsInfo = formalsInfo;
        this.enclosingInfo = enclosingInfo;
    }

    public static GenericSignatureContextBuilder create(AppView<?> appView) {
        return GenericSignatureContextBuilder.create(appView, ((AppInfo)appView.appInfo()).classes());
    }

    public static GenericSignatureContextBuilder create(AppView<?> appView, Collection<DexProgramClass> programClasses) {
        if (!appView.options().parseSignatureAttribute()) {
            return null;
        }
        IdentityHashMap<DexReference, TypeParameterSubstitutions> formalsInfo = new IdentityHashMap<DexReference, TypeParameterSubstitutions>();
        IdentityHashMap<DexReference, DexReference> enclosingInfo = new IdentityHashMap<DexReference, DexReference>();
        programClasses.forEach(clazz -> {
            EnclosingMethodAttribute enclosingMethodAttribute;
            InnerClassAttribute innerClassAttribute;
            if (clazz.getClassSignature().isValid()) {
                formalsInfo.put(clazz.getReference(), TypeParameterSubstitutions.create(clazz.classSignature.getFormalTypeParameters()));
                clazz.forEachProgramMethod(method -> {
                    GenericSignature.MethodTypeSignature methodSignature = ((DexEncodedMethod)method.getDefinition()).getGenericSignature();
                    if (methodSignature.isValid()) {
                        formalsInfo.put(method.getReference(), TypeParameterSubstitutions.create(methodSignature.getFormalTypeParameters()));
                    }
                });
            }
            if ((innerClassAttribute = clazz.getInnerClassAttributeForThisClass()) != null) {
                enclosingInfo.put(clazz.getType(), innerClassAttribute.getOuter());
            }
            if ((enclosingMethodAttribute = clazz.getEnclosingMethodAttribute()) != null) {
                enclosingInfo.put(clazz.getType(), enclosingMethodAttribute.getEnclosingMethod() != null ? enclosingMethodAttribute.getEnclosingMethod() : enclosingMethodAttribute.getEnclosingClass());
            }
        });
        return new GenericSignatureContextBuilder(formalsInfo, enclosingInfo);
    }

    public static GenericSignatureContextBuilder createForSingleClass(AppView<?> appView, DexProgramClass clazz) {
        WorkList<DexProgramClass> workList = WorkList.newIdentityWorkList(clazz);
        while (workList.hasNext()) {
            DexProgramClass current = workList.next();
            DexClass outer = null;
            if (current.getEnclosingMethodAttribute() != null) {
                outer = appView.definitionFor(current.getEnclosingMethodAttribute().getEnclosingType());
            } else if (current.getInnerClassAttributeForThisClass() != null) {
                outer = appView.definitionFor(current.getInnerClassAttributeForThisClass().getOuter());
            }
            if (outer == null || !outer.isProgramClass()) continue;
            workList.addIfNotSeen(outer.asProgramClass());
        }
        return GenericSignatureContextBuilder.create(appView, workList.getSeenSet());
    }

    private TypeParameterContext computeTypeParameterContext(AppView<?> appView, DexReference reference, Predicate<DexType> wasPruned, boolean seenPruned) {
        if (reference == null) {
            return TypeParameterContext.empty();
        }
        DexType contextType = reference.getContextType();
        DexClass clazz = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(contextType);
        boolean prunedHere = seenPruned;
        prunedHere |= clazz == null && appView.hasLiveness() && !appView.withLiveness().appInfo().getMissingClasses().contains(contextType);
        TypeParameterSubstitutions formalsInfo = this.formalsInfo.get(contextType);
        boolean bl = clazz != null && formalsInfo != null && !formalsInfo.parametersWithBounds.isEmpty() && clazz.getClassSignature().getFormalTypeParameters().isEmpty();
        DexReference enclosingReference = this.enclosingInfo.get(contextType);
        TypeParameterContext typeParameterContext = this.computeTypeParameterContext(appView, enclosingReference, wasPruned, (prunedHere |= bl) || this.hasPrunedRelationship(appView, enclosingReference, contextType, wasPruned)).combine(formalsInfo, prunedHere);
        if (!reference.isDexMethod()) {
            return typeParameterContext;
        }
        TypeParameterSubstitutions methodFormals = this.formalsInfo.get(reference);
        if (clazz != null && !prunedHere) {
            DexEncodedMethod method = clazz.lookupMethod(reference.asDexMethod());
            prunedHere = method == null || !methodFormals.parametersWithBounds.isEmpty() && method.getGenericSignature().getFormalTypeParameters().isEmpty();
        }
        return typeParameterContext.combine(methodFormals, prunedHere);
    }

    public static boolean hasGenericTypeVariables(AppView<?> appView, DexType type, Predicate<DexType> wasPruned) {
        if (wasPruned.test(type)) {
            return false;
        }
        DexClass clazz = appView.definitionFor(type);
        if (clazz == null || clazz.isNotProgramClass() || clazz.getClassSignature().isInvalid()) {
            return true;
        }
        return !clazz.getClassSignature().getFormalTypeParameters().isEmpty();
    }

    public TypeParameterContext computeTypeParameterContext(AppView<?> appView, DexReference reference, Predicate<DexType> wasPruned) {
        assert (!wasPruned.test(reference.getContextType())) : "Building context for pruned type";
        return this.computeTypeParameterContext(appView, reference, wasPruned, false);
    }

    public boolean hasPrunedRelationship(AppView<?> appView, DexReference enclosingReference, DexType enclosedClassType, Predicate<DexType> wasPruned) {
        assert (enclosedClassType != null);
        if (enclosingReference == null) {
            return true;
        }
        if (wasPruned.test(enclosingReference.getContextType()) || wasPruned.test(enclosedClassType)) {
            return true;
        }
        DexClass enclosingClass = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(enclosingReference.getContextType());
        DexClass enclosedClass = ((AppInfo)appView.appInfo()).definitionForWithoutExistenceAssert(enclosedClassType);
        if (enclosingClass == null || enclosedClass == null) {
            return true;
        }
        if (enclosedClass.getEnclosingMethodAttribute() != null) {
            return enclosingReference.isDexMethod() ? enclosedClass.getEnclosingMethodAttribute().getEnclosingMethod() != enclosingReference : enclosedClass.getEnclosingMethodAttribute().getEnclosingClass() != enclosingReference;
        }
        InnerClassAttribute innerClassAttribute = enclosedClass.getInnerClassAttributeForThisClass();
        return innerClassAttribute == null || innerClassAttribute.getOuter() != enclosingReference;
    }

    public static class TypeParameterContext {
        private static final TypeParameterContext EMPTY = new TypeParameterContext(Collections.emptyMap(), Collections.emptySet());
        private final Map<String, GenericSignature.FieldTypeSignature> prunedParametersWithBounds;
        private final Set<String> liveParameters;

        private TypeParameterContext(Map<String, GenericSignature.FieldTypeSignature> prunedParametersWithBounds, Set<String> liveParameters) {
            this.prunedParametersWithBounds = prunedParametersWithBounds;
            this.liveParameters = liveParameters;
        }

        private TypeParameterContext combine(TypeParameterSubstitutions information, boolean dead) {
            if (information == null) {
                return this;
            }
            return dead ? this.addPrunedSubstitutions(information.parametersWithBounds) : this.addLiveParameters(information.parametersWithBounds.keySet());
        }

        public static TypeParameterContext empty() {
            return EMPTY;
        }

        public boolean isLiveParameter(String parameterName) {
            return this.liveParameters.contains(parameterName);
        }

        public GenericSignature.FieldTypeSignature getPrunedSubstitution(String parameterName) {
            assert (!this.isLiveParameter(parameterName));
            return this.prunedParametersWithBounds.get(parameterName);
        }

        public TypeParameterContext addLiveParameters(Collection<String> typeParameters) {
            if (typeParameters.isEmpty()) {
                return this;
            }
            HashSet<String> newLiveParameters = new HashSet<String>();
            newLiveParameters.addAll(this.liveParameters);
            newLiveParameters.addAll(typeParameters);
            HashMap<String, GenericSignature.FieldTypeSignature> newPruned = new HashMap<String, GenericSignature.FieldTypeSignature>();
            this.prunedParametersWithBounds.forEach((name, type) -> {
                if (!typeParameters.contains(name)) {
                    newPruned.put((String)name, (GenericSignature.FieldTypeSignature)type);
                }
            });
            return new TypeParameterContext(newPruned, newLiveParameters);
        }

        public TypeParameterContext addPrunedSubstitutions(Map<String, GenericSignature.FieldTypeSignature> substitutions) {
            if (substitutions.isEmpty()) {
                return this;
            }
            HashMap<String, GenericSignature.FieldTypeSignature> newPruned = new HashMap<String, GenericSignature.FieldTypeSignature>();
            newPruned.putAll(this.prunedParametersWithBounds);
            newPruned.putAll(substitutions);
            HashSet<String> newLiveParameters = new HashSet<String>();
            this.liveParameters.forEach(name -> {
                if (!substitutions.containsKey(name)) {
                    newLiveParameters.add((String)name);
                }
            });
            return new TypeParameterContext(newPruned, newLiveParameters);
        }
    }

    private static class TypeParameterSubstitutions {
        private final Map<String, GenericSignature.FieldTypeSignature> parametersWithBounds;

        private TypeParameterSubstitutions(Map<String, GenericSignature.FieldTypeSignature> parametersWithBounds) {
            this.parametersWithBounds = parametersWithBounds;
        }

        private static TypeParameterSubstitutions create(List<GenericSignature.FormalTypeParameter> formals) {
            HashMap<String, GenericSignature.FieldTypeSignature> map = new HashMap<String, GenericSignature.FieldTypeSignature>();
            formals.forEach(formal -> {
                if (formal.getClassBound() != null && formal.getClassBound().hasSignature() && formal.getClassBound().isClassTypeSignature()) {
                    map.put(formal.getName(), formal.getClassBound());
                } else if (!formal.getInterfaceBounds().isEmpty() && formal.getInterfaceBounds().get(0).isClassTypeSignature()) {
                    map.put(formal.getName(), formal.getInterfaceBounds().get(0));
                } else {
                    map.put(formal.getName(), null);
                }
            });
            return new TypeParameterSubstitutions(map);
        }
    }
}

