/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.GenericSignatureTypeVisitor;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import java.util.Set;

public class GenericSignatureEnqueuerAnalysis
extends EnqueuerAnalysis {
    private final Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier;
    private final Set<DexReference> processedSignatures = Sets.newIdentityHashSet();

    public GenericSignatureEnqueuerAnalysis(Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier) {
        this.enqueuerDefinitionSupplier = enqueuerDefinitionSupplier;
    }

    private void processSignature(ProgramDefinition signatureHolder, ProgramDefinition context) {
        if (!this.processedSignatures.add(signatureHolder.getReference())) {
            return;
        }
        GenericSignatureTypeVisitor genericSignatureTypeVisitor = new GenericSignatureTypeVisitor(context, this.enqueuerDefinitionSupplier::definitionFor);
        if (signatureHolder.isClass()) {
            genericSignatureTypeVisitor.visitClassSignature(signatureHolder.asClass().getClassSignature());
        } else if (signatureHolder.isMethod()) {
            genericSignatureTypeVisitor.visitMethodSignature(((DexEncodedMethod)signatureHolder.asMethod().getDefinition()).getGenericSignature());
        } else {
            assert (signatureHolder.isField());
            genericSignatureTypeVisitor.visitFieldTypeSignature(((DexEncodedField)signatureHolder.asField().getDefinition()).getGenericSignature());
        }
    }

    @Override
    public void processNewlyLiveClass(DexProgramClass clazz, EnqueuerWorklist worklist) {
        this.processSignature(clazz, clazz.getContext());
    }

    @Override
    public void notifyMarkFieldAsReachable(ProgramField field, EnqueuerWorklist worklist) {
        this.processSignature(field, field.getContext());
    }

    @Override
    public void processNewlyLiveField(ProgramField field, ProgramDefinition context, EnqueuerWorklist worklist) {
        this.processSignature(field, context);
    }

    @Override
    public void notifyMarkMethodAsTargeted(ProgramMethod method, EnqueuerWorklist worklist) {
        this.processSignature(method, method.getContext());
    }

    @Override
    public void processNewlyLiveMethod(ProgramMethod method, ProgramDefinition context, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        this.processSignature(method, context);
    }
}

