/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.GenericSignatureVisitor;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.List;
import java.util.function.Predicate;

public class GenericSignaturePrinter
implements GenericSignatureVisitor {
    private final NamingLens namingLens;
    private final Predicate<DexType> isTypeMissing;
    private final StringBuilder sb = new StringBuilder();

    public GenericSignaturePrinter(NamingLens namingLens, Predicate<DexType> isTypeMissing) {
        this.namingLens = namingLens;
        this.isTypeMissing = isTypeMissing;
    }

    private void printFieldTypeSignature(GenericSignature.FieldTypeSignature fieldTypeSignature, boolean printingOuter) {
        if (fieldTypeSignature.isStar()) {
            this.sb.append("*");
        } else if (fieldTypeSignature.isTypeVariableSignature()) {
            this.sb.append("T").append(fieldTypeSignature.asTypeVariableSignature().typeVariable).append(";");
        } else if (fieldTypeSignature.isArrayTypeSignature()) {
            this.sb.append("[");
            fieldTypeSignature.asArrayTypeSignature().visit(this);
        } else {
            assert (fieldTypeSignature.isClassTypeSignature());
            GenericSignature.ClassTypeSignature classTypeSignature = fieldTypeSignature.asClassTypeSignature();
            if (classTypeSignature.hasNoSignature()) {
                return;
            }
            if (classTypeSignature.enclosingTypeSignature != null) {
                this.visitEnclosing(classTypeSignature.enclosingTypeSignature, classTypeSignature);
            }
            String renamedString = this.namingLens.lookupDescriptor(classTypeSignature.type).toString();
            if (classTypeSignature.enclosingTypeSignature == null) {
                this.sb.append("L").append(DescriptorUtils.getBinaryNameFromDescriptor(renamedString));
            } else {
                DexType enclosingType = classTypeSignature.enclosingTypeSignature.type;
                String outerDescriptor = this.namingLens.lookupDescriptor(enclosingType).toString();
                String innerClassName = DescriptorUtils.getInnerClassName(outerDescriptor, renamedString);
                if (innerClassName == null && this.isTypeMissing.test(classTypeSignature.type)) {
                    assert (renamedString.equals(classTypeSignature.type.toDescriptorString()));
                    innerClassName = DescriptorUtils.getInnerClassName(enclosingType.toDescriptorString(), renamedString);
                }
                if (innerClassName == null) {
                    return;
                }
                this.sb.append(".").append(innerClassName);
            }
            this.visitTypeArguments(null, null, classTypeSignature.typeArguments);
            if (!printingOuter) {
                this.sb.append(";");
            }
        }
    }

    @Override
    public GenericSignature.ClassSignature visitClassSignature(GenericSignature.ClassSignature classSignature) {
        return classSignature.visit(this);
    }

    @Override
    public GenericSignature.FieldTypeSignature visitFieldTypeSignature(GenericSignature.FieldTypeSignature fieldSignature) {
        this.printFieldTypeSignature(fieldSignature, false);
        return fieldSignature;
    }

    @Override
    public GenericSignature.MethodTypeSignature visitMethodSignature(GenericSignature.MethodTypeSignature methodSignature) {
        return methodSignature.visit(this);
    }

    @Override
    public List<GenericSignature.TypeSignature> visitMethodTypeSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        this.sb.append("(");
        typeSignatures.forEach(this::visitTypeSignature);
        this.sb.append(")");
        return typeSignatures;
    }

    @Override
    public GenericSignature.ReturnType visitReturnType(GenericSignature.ReturnType returnType) {
        if (returnType.isVoidDescriptor()) {
            this.sb.append("V");
        } else {
            this.visitTypeSignature(returnType.typeSignature);
        }
        return returnType;
    }

    @Override
    public List<GenericSignature.TypeSignature> visitThrowsSignatures(List<GenericSignature.TypeSignature> typeSignatures) {
        for (GenericSignature.TypeSignature typeSignature : typeSignatures) {
            this.sb.append("^");
            this.visitTypeSignature(typeSignature);
        }
        return typeSignatures;
    }

    @Override
    public List<GenericSignature.FormalTypeParameter> visitFormalTypeParameters(List<GenericSignature.FormalTypeParameter> formalTypeParameters) {
        if (formalTypeParameters.isEmpty()) {
            return formalTypeParameters;
        }
        this.sb.append("<");
        formalTypeParameters.forEach(this::visitFormalTypeParameter);
        this.sb.append(">");
        return formalTypeParameters;
    }

    @Override
    public GenericSignature.FieldTypeSignature visitClassBound(GenericSignature.FieldTypeSignature fieldSignature) {
        this.sb.append(":");
        if (fieldSignature.hasNoSignature()) {
            return fieldSignature;
        }
        this.printFieldTypeSignature(fieldSignature, false);
        return fieldSignature;
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitInterfaceBounds(List<GenericSignature.FieldTypeSignature> fieldSignatures) {
        fieldSignatures.forEach(this::visitInterfaceBound);
        return fieldSignatures;
    }

    @Override
    public GenericSignature.FieldTypeSignature visitInterfaceBound(GenericSignature.FieldTypeSignature fieldSignature) {
        this.sb.append(":");
        this.printFieldTypeSignature(fieldSignature, false);
        return fieldSignature;
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperClass(GenericSignature.ClassTypeSignature classTypeSignature) {
        this.printFieldTypeSignature(classTypeSignature, false);
        return classTypeSignature;
    }

    @Override
    public List<GenericSignature.ClassTypeSignature> visitSuperInterfaces(List<GenericSignature.ClassTypeSignature> interfaceSignatures) {
        interfaceSignatures.forEach(this::visitSuperInterface);
        return interfaceSignatures;
    }

    @Override
    public GenericSignature.ClassTypeSignature visitSuperInterface(GenericSignature.ClassTypeSignature classTypeSignature) {
        this.printFieldTypeSignature(classTypeSignature, false);
        return classTypeSignature;
    }

    @Override
    public GenericSignature.TypeSignature visitTypeSignature(GenericSignature.TypeSignature typeSignature) {
        if (typeSignature.isBaseTypeSignature()) {
            DexType type = typeSignature.asBaseTypeSignature().type;
            this.sb.append(type.toDescriptorString());
        } else {
            this.printFieldTypeSignature(typeSignature.asFieldTypeSignature(), false);
        }
        return typeSignature;
    }

    @Override
    public GenericSignature.ClassTypeSignature visitEnclosing(GenericSignature.ClassTypeSignature enclosingSignature, GenericSignature.ClassTypeSignature enclosedSignature) {
        this.printFieldTypeSignature(enclosingSignature, true);
        return enclosingSignature;
    }

    @Override
    public List<GenericSignature.FieldTypeSignature> visitTypeArguments(DexType originalType, DexType lookedUpType, List<GenericSignature.FieldTypeSignature> typeArguments) {
        if (typeArguments.isEmpty()) {
            return typeArguments;
        }
        this.sb.append("<");
        for (GenericSignature.FieldTypeSignature typeArgument : typeArguments) {
            GenericSignature.WildcardIndicator wildcardIndicator = typeArgument.getWildcardIndicator();
            if (wildcardIndicator != GenericSignature.WildcardIndicator.NONE) {
                assert (wildcardIndicator != GenericSignature.WildcardIndicator.NOT_AN_ARGUMENT);
                this.sb.append(wildcardIndicator == GenericSignature.WildcardIndicator.POSITIVE ? "+" : "-");
            }
            this.visitTypeSignature(typeArgument);
        }
        this.sb.append(">");
        return typeArguments;
    }

    @Override
    public GenericSignature.FormalTypeParameter visitFormalTypeParameter(GenericSignature.FormalTypeParameter formalTypeParameter) {
        this.sb.append(formalTypeParameter.name);
        return formalTypeParameter.visit(this);
    }

    @Override
    public DexType visitType(DexType type) {
        return type;
    }

    public String toString() {
        return this.sb.toString();
    }
}

