/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.graph.GenericSignatureCorrectnessHelper;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;

public class GenericSignatureValidationDiagnostic
implements Diagnostic {
    private final Origin origin;
    private final Position position;
    private final String message;

    GenericSignatureValidationDiagnostic(Origin origin, Position position, String message) {
        this.origin = origin;
        this.position = position;
        this.message = message;
    }

    static GenericSignatureValidationDiagnostic invalidClassSignature(String signature, String name, Origin origin, GenericSignatureCorrectnessHelper.SignatureEvaluationResult error) {
        return GenericSignatureValidationDiagnostic.invalidSignature(signature, "class", name, origin, error);
    }

    static GenericSignatureValidationDiagnostic invalidMethodSignature(String signature, String name, Origin origin, GenericSignatureCorrectnessHelper.SignatureEvaluationResult error) {
        return GenericSignatureValidationDiagnostic.invalidSignature(signature, "method", name, origin, error);
    }

    static GenericSignatureValidationDiagnostic invalidFieldSignature(String signature, String name, Origin origin, GenericSignatureCorrectnessHelper.SignatureEvaluationResult error) {
        return GenericSignatureValidationDiagnostic.invalidSignature(signature, "field", name, origin, error);
    }

    private static GenericSignatureValidationDiagnostic invalidSignature(String signature, String kind, String name, Origin origin, GenericSignatureCorrectnessHelper.SignatureEvaluationResult error) {
        String message = "Invalid signature '" + signature + "' for " + kind + " " + name + "." + System.lineSeparator() + "Validation error: " + error.getDescription() + "." + System.lineSeparator() + "Signature is ignored and will not be present in the output.";
        return new GenericSignatureValidationDiagnostic(origin, Position.UNKNOWN, message);
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }
}

