/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.optimize.MemberRebindingIdentityLens;
import com.android.tools.r8.optimize.MemberRebindingLens;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class GraphLens {
    private GraphLens() {
    }

    public static GraphLens getIdentityLens() {
        return IdentityGraphLens.getInstance();
    }

    public boolean isSyntheticFinalizationGraphLens() {
        return false;
    }

    public abstract DexType getOriginalType(DexType var1);

    public abstract Iterable<DexType> getOriginalTypes(DexType var1);

    public abstract DexField getOriginalFieldSignature(DexField var1);

    public final DexMember<?, ?> getOriginalMemberSignature(DexMember<?, ?> member) {
        return member.apply(this::getOriginalFieldSignature, this::getOriginalMethodSignature);
    }

    public final DexMethod getOriginalMethodSignature(DexMethod method) {
        return this.getOriginalMethodSignature(method, null);
    }

    public final DexMethod getOriginalMethodSignature(DexMethod method, GraphLens atGraphLens) {
        GraphLens current = this;
        DexMethod original = method;
        while (current.isNonIdentityLens() && current != atGraphLens) {
            NonIdentityGraphLens nonIdentityLens = current.asNonIdentityLens();
            original = nonIdentityLens.getPreviousMethodSignature(original);
            current = nonIdentityLens.getPrevious();
        }
        assert (atGraphLens != null ? current == atGraphLens : current.isIdentityLens());
        return original;
    }

    public final DexField getRenamedFieldSignature(DexField originalField) {
        return this.getRenamedFieldSignature(originalField, null);
    }

    public abstract DexField getRenamedFieldSignature(DexField var1, GraphLens var2);

    public final DexMember<?, ?> getRenamedMemberSignature(DexMember<?, ?> originalMember) {
        return originalMember.isDexField() ? this.getRenamedFieldSignature(originalMember.asDexField()) : this.getRenamedMethodSignature(originalMember.asDexMethod());
    }

    public final DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
        return this.getRenamedMethodSignature(originalMethod, null);
    }

    public abstract DexMethod getRenamedMethodSignature(DexMethod var1, GraphLens var2);

    public DexEncodedMethod mapDexEncodedMethod(DexEncodedMethod originalEncodedMethod, DexDefinitionSupplier definitions) {
        return this.mapDexEncodedMethod(originalEncodedMethod, definitions, null);
    }

    public DexEncodedMethod mapDexEncodedMethod(DexEncodedMethod originalEncodedMethod, DexDefinitionSupplier definitions, GraphLens applied) {
        assert (originalEncodedMethod != DexEncodedMethod.SENTINEL);
        DexMethod newMethod = this.getRenamedMethodSignature((DexMethod)originalEncodedMethod.getReference(), applied);
        DexClass newHolder = definitions.definitionFor(newMethod.holder);
        assert (newHolder != null);
        DexEncodedMethod newEncodedMethod = newHolder.lookupMethod(newMethod);
        assert (newEncodedMethod != null);
        return newEncodedMethod;
    }

    public ProgramMethod mapProgramMethod(ProgramMethod oldMethod, DexDefinitionSupplier definitions) {
        DexMethod newMethod = this.getRenamedMethodSignature((DexMethod)oldMethod.getReference());
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(definitions.definitionForHolder(newMethod));
        return newMethod.lookupOnProgramClass(holder);
    }

    public <T extends DexReference> boolean isSimpleRenaming(T from, T to) {
        assert (from != to);
        return false;
    }

    public abstract String lookupPackageName(String var1);

    public DexType lookupClassType(DexType type) {
        return this.lookupClassType(type, GraphLens.getIdentityLens());
    }

    public abstract DexType lookupClassType(DexType var1, GraphLens var2);

    public DexType lookupType(DexType type) {
        return this.lookupType(type, GraphLens.getIdentityLens());
    }

    public abstract DexType lookupType(DexType var1, GraphLens var2);

    @Deprecated
    public final DexMethod lookupMethod(DexMethod method) {
        assert (this.verifyIsContextFreeForMethod(method));
        return (DexMethod)this.lookupMethod(method, null, null).getReference();
    }

    public final MethodLookupResult lookupInvokeDirect(DexMethod method, ProgramMethod context) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.DIRECT);
    }

    public final MethodLookupResult lookupInvokeDirect(DexMethod method, ProgramMethod context, GraphLens codeLens) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.DIRECT, codeLens);
    }

    public final MethodLookupResult lookupInvokeInterface(DexMethod method, ProgramMethod context) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.INTERFACE);
    }

    public final MethodLookupResult lookupInvokeInterface(DexMethod method, ProgramMethod context, GraphLens codeLens) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.INTERFACE, codeLens);
    }

    public final MethodLookupResult lookupInvokeStatic(DexMethod method, ProgramMethod context) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.STATIC);
    }

    public final MethodLookupResult lookupInvokeStatic(DexMethod method, ProgramMethod context, GraphLens codeLens) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.STATIC, codeLens);
    }

    public final MethodLookupResult lookupInvokeSuper(DexMethod method, ProgramMethod context) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.SUPER);
    }

    public final MethodLookupResult lookupInvokeSuper(DexMethod method, ProgramMethod context, GraphLens codeLens) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.SUPER, codeLens);
    }

    public final MethodLookupResult lookupInvokeVirtual(DexMethod method, ProgramMethod context) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.VIRTUAL);
    }

    public final MethodLookupResult lookupInvokeVirtual(DexMethod method, ProgramMethod context, GraphLens codeLens) {
        return this.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.VIRTUAL, codeLens);
    }

    public final MethodLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        return this.lookupMethod(method, context, type, null);
    }

    public abstract MethodLookupResult lookupMethod(DexMethod var1, DexMethod var2, Invoke.Type var3, GraphLens var4);

    protected abstract MethodLookupResult internalLookupMethod(DexMethod var1, DexMethod var2, Invoke.Type var3, GraphLens var4, LookupMethodContinuation var5);

    public final RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method) {
        return this.lookupPrototypeChangesForMethodDefinition(method, null);
    }

    public abstract RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod var1, GraphLens var2);

    public final DexField lookupField(DexField field) {
        return this.lookupField(field, null);
    }

    public DexField lookupField(DexField field, GraphLens codeLens) {
        return (DexField)this.lookupFieldResult(field, codeLens).getReference();
    }

    public final FieldLookupResult lookupFieldResult(DexField field) {
        return this.lookupFieldResult(field, null);
    }

    public final FieldLookupResult lookupFieldResult(DexField field, GraphLens codeLens) {
        return this.internalLookupField(field, codeLens, x -> x);
    }

    protected abstract FieldLookupResult internalLookupField(DexField var1, GraphLens var2, LookupFieldContinuation var3);

    public DexReference lookupReference(DexReference reference) {
        return reference.apply(this::lookupType, this::lookupField, this::lookupMethod);
    }

    public abstract boolean isContextFreeForMethods();

    public boolean verifyIsContextFreeForMethod(DexMethod method) {
        return this.isContextFreeForMethods();
    }

    public boolean hasCodeRewritings() {
        return true;
    }

    public boolean hasCustomCodeRewritings() {
        return false;
    }

    public boolean isAppliedLens() {
        return false;
    }

    public boolean isArgumentPropagatorGraphLens() {
        return false;
    }

    public boolean isClearCodeRewritingLens() {
        return false;
    }

    public boolean isEnumUnboxerLens() {
        return false;
    }

    public boolean isHorizontalClassMergerGraphLens() {
        return false;
    }

    public abstract boolean isIdentityLens();

    public boolean isMemberRebindingLens() {
        return false;
    }

    public MemberRebindingLens asMemberRebindingLens() {
        return null;
    }

    public boolean isMemberRebindingIdentityLens() {
        return false;
    }

    public MemberRebindingIdentityLens asMemberRebindingIdentityLens() {
        return null;
    }

    public abstract boolean isNonIdentityLens();

    public NonIdentityGraphLens asNonIdentityLens() {
        return null;
    }

    public boolean isVerticalClassMergerLens() {
        return false;
    }

    public GraphLens withCodeRewritingsApplied(DexItemFactory dexItemFactory) {
        if (this.hasCodeRewritings()) {
            return new ClearCodeRewritingGraphLens(dexItemFactory, this);
        }
        return this;
    }

    public <T extends DexDefinition> boolean assertDefinitionsNotModified(Iterable<T> definitions) {
        for (DexDefinition definition : definitions) {
            boolean isBridge;
            DexReference reference = definition.getReference();
            boolean bl = isBridge = definition.isDexEncodedMethod() && definition.asDexEncodedMethod().accessFlags.isBridge();
            assert (isBridge || this.lookupReference(reference) == reference);
        }
        return true;
    }

    public <T extends DexReference> boolean assertPinnedNotModified(KeepInfoCollection keepInfo, InternalOptions options) {
        ArrayList pinnedItems = new ArrayList();
        keepInfo.forEachPinnedType(pinnedItems::add, options);
        keepInfo.forEachPinnedMethod(pinnedItems::add, options);
        keepInfo.forEachPinnedField(pinnedItems::add, options);
        return this.assertReferencesNotModified(pinnedItems);
    }

    public <T extends DexReference> boolean assertReferencesNotModified(Iterable<T> references) {
        for (DexReference reference : references) {
            if (reference.isDexField()) {
                DexField field = reference.asDexField();
                assert (this.getRenamedFieldSignature(field) == field);
                continue;
            }
            if (reference.isDexMethod()) {
                DexMethod method = reference.asDexMethod();
                assert (this.getRenamedMethodSignature(method) == method);
                continue;
            }
            assert (reference.isDexType());
            DexType type = reference.asDexType();
            assert (this.lookupType(type) == type);
        }
        return true;
    }

    public Map<DexCallSite, ProgramMethodSet> rewriteCallSites(Map<DexCallSite, ProgramMethodSet> callSites, DexDefinitionSupplier definitions) {
        IdentityHashMap<DexCallSite, ProgramMethodSet> result = new IdentityHashMap<DexCallSite, ProgramMethodSet>();
        LensCodeRewriterUtils rewriter = new LensCodeRewriterUtils(definitions, this, null);
        callSites.forEach((callSite, contexts) -> {
            for (ProgramMethod context : contexts.rewrittenWithLens(definitions, this)) {
                DexCallSite rewrittenCallSite = rewriter.rewriteCallSite((DexCallSite)callSite, context);
                result.computeIfAbsent(rewrittenCallSite, ignore -> ProgramMethodSet.create()).add(context);
            }
        });
        return result;
    }

    public <T extends DexReference> T rewriteReference(T reference) {
        return this.rewriteReference(reference, null);
    }

    public <T extends DexReference> T rewriteReference(T reference, GraphLens codeLens) {
        return (T)reference.apply(type -> this.lookupType((DexType)type, codeLens), field -> this.getRenamedFieldSignature((DexField)field, codeLens), method -> this.getRenamedMethodSignature((DexMethod)method, codeLens));
    }

    public <T extends DexReference> Set<T> rewriteReferences(Set<T> references) {
        Set result = SetUtils.newIdentityHashSet(references.size());
        for (DexReference reference : references) {
            result.add(this.rewriteReference(reference));
        }
        return result;
    }

    public <R extends DexReference, T> Map<R, T> rewriteReferenceKeys(Map<R, T> map, BiFunction<R, List<T>, T> merge) {
        IdentityHashMap result = new IdentityHashMap();
        IdentityHashMap<DexReference, List> needsMerge = new IdentityHashMap<DexReference, List>();
        map.forEach((reference, value) -> {
            DexReference rewrittenReference = this.rewriteReference(reference);
            List unmergedValues = (List)needsMerge.get(rewrittenReference);
            if (unmergedValues != null) {
                unmergedValues.add(value);
            } else {
                Object existingValue = result.put(rewrittenReference, value);
                if (existingValue != null) {
                    needsMerge.put(rewrittenReference, ListUtils.newArrayList(existingValue, value));
                    result.remove(rewrittenReference);
                }
            }
        });
        needsMerge.forEach((rewrittenReference, unmergedValues) -> {
            Object mergedValue = merge.apply((Object)rewrittenReference, (List)unmergedValues);
            if (mergedValue != null) {
                result.put(rewrittenReference, mergedValue);
            }
        });
        return result;
    }

    public <T extends DexReference> Object2BooleanMap<T> rewriteReferenceKeys(Object2BooleanMap<T> map) {
        Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
        for (Object2BooleanMap.Entry entry : map.object2BooleanEntrySet()) {
            result.put(this.rewriteReference((DexReference)entry.getKey()), entry.getBooleanValue());
        }
        return result;
    }

    public <T> ImmutableMap<DexField, T> rewriteFieldKeys(Map<DexField, T> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((field, value) -> builder.put(this.getRenamedFieldSignature((DexField)field), value));
        return builder.build();
    }

    public ImmutableSet<DexType> rewriteTypes(Set<DexType> types) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (DexType type : types) {
            builder.add(this.lookupType(type));
        }
        return builder.build();
    }

    public <T> Map<DexType, T> rewriteTypeKeys(Map<DexType, T> map, BiFunction<T, T, T> merge) {
        IdentityHashMap newMap = new IdentityHashMap();
        map.forEach((type, value) -> {
            DexType rewrittenType;
            Object previousValue = newMap.get(rewrittenType = this.lookupType((DexType)type));
            newMap.put(rewrittenType, previousValue != null ? merge.apply(value, previousValue) : value);
        });
        return newMap;
    }

    public boolean verifyMappingToOriginalProgram(AppView<?> appView, DexApplication originalApplication) {
        Collection<DexProgramClass> classes = ((AppInfo)appView.appInfo()).classesWithDeterministicOrder();
        Set<DexField> originalFields = Sets.newIdentityHashSet();
        Set<DexMethod> originalMethods = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : originalApplication.classes()) {
            for (DexEncodedField field : clazz.fields()) {
                originalFields.add((DexField)field.getReference());
            }
            for (DexEncodedMethod method : clazz.methods()) {
                originalMethods.add((DexMethod)method.getReference());
            }
        }
        for (DexProgramClass clazz : classes) {
            if (((AppInfo)appView.appInfo()).getSyntheticItems().isSyntheticClass(clazz)) continue;
            for (DexEncodedField field : clazz.fields()) {
                if (field.isD8R8Synthesized()) continue;
                DexField originalField = this.getOriginalFieldSignature((DexField)field.getReference());
                assert (originalFields.contains(originalField)) : "Unable to map field `" + ((DexField)field.getReference()).toSourceString() + "` back to original program";
            }
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.isD8R8Synthesized()) continue;
                DexMethod originalMethod = this.getOriginalMethodSignature((DexMethod)method.getReference());
                assert (originalMethods.contains(originalMethod)) : "Method could not be mapped back: " + method.toSourceString() + ", originalMethod: " + originalMethod.toSourceString();
            }
        }
        return true;
    }

    public static class ClearCodeRewritingGraphLens
    extends NonIdentityGraphLens {
        public ClearCodeRewritingGraphLens(DexItemFactory dexItemFactory, GraphLens previousLens) {
            super(dexItemFactory, previousLens);
        }

        @Override
        public DexType getOriginalType(DexType type) {
            return this.getPrevious().getOriginalType(type);
        }

        @Override
        public Iterable<DexType> getOriginalTypes(DexType type) {
            return this.getPrevious().getOriginalTypes(type);
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            return this.getPrevious().getOriginalFieldSignature(field);
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
            return this != codeLens ? this.getPrevious().getRenamedFieldSignature(originalField) : originalField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
            return this != applied ? this.getPrevious().getRenamedMethodSignature(originalMethod, applied) : originalMethod;
        }

        @Override
        public boolean isClearCodeRewritingLens() {
            return true;
        }

        @Override
        public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
            return ClearCodeRewritingGraphLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
        }

        @Override
        public final DexType internalDescribeLookupClassType(DexType previous) {
            return previous;
        }

        @Override
        protected FieldLookupResult internalLookupField(DexField reference, GraphLens codeLens, LookupFieldContinuation continuation) {
            return ClearCodeRewritingGraphLens.getIdentityLens().internalLookupField(reference, codeLens, continuation);
        }

        @Override
        protected FieldLookupResult internalDescribeLookupField(FieldLookupResult previous) {
            throw new Unreachable();
        }

        @Override
        protected MethodLookupResult internalLookupMethod(DexMethod reference, DexMethod context, Invoke.Type type, GraphLens codeLens, LookupMethodContinuation continuation) {
            assert (codeLens == null || codeLens == this);
            GraphLens identityLens = ClearCodeRewritingGraphLens.getIdentityLens();
            return identityLens.internalLookupMethod(reference, context, type, identityLens, continuation);
        }

        @Override
        public MethodLookupResult internalDescribeLookupMethod(MethodLookupResult previous, DexMethod context) {
            throw new Unreachable();
        }

        @Override
        public DexMethod getPreviousMethodSignature(DexMethod method) {
            return method;
        }

        @Override
        public DexMethod getNextMethodSignature(DexMethod method) {
            return method;
        }

        @Override
        public boolean isContextFreeForMethods() {
            return ClearCodeRewritingGraphLens.getIdentityLens().isContextFreeForMethods();
        }
    }

    private static final class IdentityGraphLens
    extends GraphLens {
        private static IdentityGraphLens INSTANCE = new IdentityGraphLens();

        private IdentityGraphLens() {
        }

        private static IdentityGraphLens getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isIdentityLens() {
            return true;
        }

        @Override
        public boolean isNonIdentityLens() {
            return false;
        }

        @Override
        public DexType getOriginalType(DexType type) {
            return type;
        }

        @Override
        public Iterable<DexType> getOriginalTypes(DexType type) {
            return IterableUtils.singleton(type);
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            return field;
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
            return originalField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
            return originalMethod;
        }

        @Override
        public String lookupPackageName(String pkg) {
            return pkg;
        }

        @Override
        public DexType lookupType(DexType type, GraphLens applied) {
            return type;
        }

        @Override
        public DexType lookupClassType(DexType type, GraphLens applied) {
            assert (type.isClassType());
            return type;
        }

        @Override
        public MethodLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type, GraphLens codeLens) {
            assert (codeLens == null || codeLens.isIdentityLens());
            return ((MethodLookupResult.Builder)MethodLookupResult.builder(this).setReference(method)).setType(type).build();
        }

        @Override
        public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
            return RewrittenPrototypeDescription.none();
        }

        @Override
        protected FieldLookupResult internalLookupField(DexField reference, GraphLens codeLens, LookupFieldContinuation continuation) {
            return continuation.lookupField(((FieldLookupResult.Builder)FieldLookupResult.builder(this).setReference(reference)).build());
        }

        @Override
        protected MethodLookupResult internalLookupMethod(DexMethod reference, DexMethod context, Invoke.Type type, GraphLens codeLens, LookupMethodContinuation continuation) {
            return continuation.lookupMethod(this.lookupMethod(reference, context, type, codeLens));
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }

        @Override
        public boolean hasCodeRewritings() {
            return false;
        }
    }

    public static abstract class NonIdentityGraphLens
    extends GraphLens {
        private final DexItemFactory dexItemFactory;
        private GraphLens previousLens;
        private final Map<DexType, DexType> arrayTypeCache = new ConcurrentHashMap<DexType, DexType>();

        public NonIdentityGraphLens(AppView<?> appView) {
            this(appView.dexItemFactory(), appView.graphLens());
        }

        public NonIdentityGraphLens(DexItemFactory dexItemFactory, GraphLens previousLens) {
            this.dexItemFactory = dexItemFactory;
            this.previousLens = previousLens;
        }

        public final DexItemFactory dexItemFactory() {
            return this.dexItemFactory;
        }

        public final GraphLens getPrevious() {
            return this.previousLens;
        }

        public final <T extends NonIdentityGraphLens> T find(Predicate<NonIdentityGraphLens> predicate) {
            GraphLens current = this;
            while (((GraphLens)current).isNonIdentityLens()) {
                NonIdentityGraphLens nonIdentityGraphLens = ((GraphLens)current).asNonIdentityLens();
                if (predicate.test(nonIdentityGraphLens)) {
                    return (T)nonIdentityGraphLens;
                }
                current = nonIdentityGraphLens.getPrevious();
            }
            return null;
        }

        public final <T extends NonIdentityGraphLens> T findPrevious(Predicate<NonIdentityGraphLens> predicate) {
            GraphLens previous = this.getPrevious();
            return previous.isNonIdentityLens() ? (T)previous.asNonIdentityLens().find(predicate) : null;
        }

        public final <T extends NonIdentityGraphLens> T findPreviousUntil(Predicate<NonIdentityGraphLens> predicate, Predicate<NonIdentityGraphLens> stoppingCriterion) {
            T found = this.findPrevious(predicate.or(stoppingCriterion));
            return found == null || stoppingCriterion.test((NonIdentityGraphLens)found) ? null : (T)found;
        }

        public final void withAlternativeParentLens(GraphLens lens, Action action) {
            GraphLens oldParent = this.getPrevious();
            this.previousLens = lens;
            action.execute();
            this.previousLens = oldParent;
        }

        @Override
        public MethodLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type, GraphLens codeLens) {
            if (method.getHolderType().isArrayType()) {
                assert (this.lookupType(method.getReturnType()) == method.getReturnType());
                assert (method.getParameters().stream().allMatch(parameterType -> this.lookupType((DexType)parameterType) == parameterType));
                return ((MethodLookupResult.Builder)MethodLookupResult.builder(this).setReference(method.withHolder(this.lookupType(method.getHolderType()), this.dexItemFactory))).setType(type).build();
            }
            assert (method.getHolderType().isClassType());
            return this.internalLookupMethod(method, context, type, codeLens, result -> result);
        }

        @Override
        public String lookupPackageName(String pkg) {
            return this.getPrevious().lookupPackageName(pkg);
        }

        @Override
        public final DexType lookupType(DexType type, GraphLens applied) {
            if (this == applied) {
                return type;
            }
            if (type.isPrimitiveType() || type.isVoidType() || type.isNullValueType()) {
                return type;
            }
            if (type.isArrayType()) {
                DexType result = this.arrayTypeCache.get(type);
                if (result == null) {
                    DexType newType;
                    DexType baseType = type.toBaseType(this.dexItemFactory);
                    result = baseType == (newType = this.lookupType(baseType)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                    this.arrayTypeCache.put(type, result);
                }
                return result;
            }
            return this.lookupClassType(type);
        }

        @Override
        public final DexType lookupClassType(DexType type, GraphLens applied) {
            assert (type.isClassType()) : "Expected class type, but was `" + type.toSourceString() + "`";
            if (this == applied) {
                return type;
            }
            return this.internalDescribeLookupClassType(this.getPrevious().lookupClassType(type));
        }

        @Override
        protected FieldLookupResult internalLookupField(DexField reference, GraphLens codeLens, LookupFieldContinuation continuation) {
            if (this == codeLens) {
                return NonIdentityGraphLens.getIdentityLens().internalLookupField(reference, codeLens, continuation);
            }
            return this.previousLens.internalLookupField(reference, codeLens, previous -> continuation.lookupField(this.internalDescribeLookupField(previous)));
        }

        @Override
        protected MethodLookupResult internalLookupMethod(DexMethod reference, DexMethod context, Invoke.Type type, GraphLens codeLens, LookupMethodContinuation continuation) {
            if (this == codeLens) {
                GraphLens identityLens = NonIdentityGraphLens.getIdentityLens();
                return identityLens.internalLookupMethod(reference, context, type, identityLens, continuation);
            }
            return this.previousLens.internalLookupMethod(reference, this.getPreviousMethodSignature(context), type, codeLens, previous -> continuation.lookupMethod(this.internalDescribeLookupMethod(previous, context)));
        }

        protected abstract FieldLookupResult internalDescribeLookupField(FieldLookupResult var1);

        protected abstract MethodLookupResult internalDescribeLookupMethod(MethodLookupResult var1, DexMethod var2);

        protected abstract DexType internalDescribeLookupClassType(DexType var1);

        public abstract DexMethod getPreviousMethodSignature(DexMethod var1);

        public abstract DexMethod getNextMethodSignature(DexMethod var1);

        @Override
        public final boolean isIdentityLens() {
            return false;
        }

        @Override
        public final boolean isNonIdentityLens() {
            return true;
        }

        @Override
        public final NonIdentityGraphLens asNonIdentityLens() {
            return this;
        }
    }

    static interface LookupFieldContinuation {
        public FieldLookupResult lookupField(FieldLookupResult var1);
    }

    static interface LookupMethodContinuation {
        public MethodLookupResult lookupMethod(MethodLookupResult var1);
    }

    public static abstract class Builder {
        protected final MutableBidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        protected final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> methodMap = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();
        protected final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();

        protected Builder() {
        }

        public void map(DexType from, DexType to) {
            if (from == to) {
                return;
            }
            this.typeMap.put(from, to);
        }

        public void move(DexMethod from, DexMethod to) {
            if (from == to) {
                return;
            }
            this.methodMap.put(from, to);
        }

        public void move(DexField from, DexField to) {
            if (from == to) {
                return;
            }
            this.fieldMap.put(from, to);
        }

        public abstract GraphLens build(AppView<?> var1);
    }

    public static class MethodLookupResult
    extends MemberLookupResult<DexMethod> {
        private final Invoke.Type type;
        private final RewrittenPrototypeDescription prototypeChanges;

        public MethodLookupResult(DexMethod reference, DexMethod reboundReference, Invoke.Type type, RewrittenPrototypeDescription prototypeChanges) {
            super(reference, reboundReference, null);
            this.type = type;
            this.prototypeChanges = prototypeChanges;
        }

        public static Builder builder(GraphLens lens) {
            return new Builder(lens);
        }

        public Invoke.Type getType() {
            return this.type;
        }

        public RewrittenPrototypeDescription getPrototypeChanges() {
            return this.prototypeChanges;
        }

        public static class Builder
        extends MemberLookupResult.Builder<DexMethod, Builder> {
            private final GraphLens lens;
            private RewrittenPrototypeDescription prototypeChanges = RewrittenPrototypeDescription.none();
            private Invoke.Type type;

            private Builder(GraphLens lens) {
                this.lens = lens;
            }

            public Builder setPrototypeChanges(RewrittenPrototypeDescription prototypeChanges) {
                this.prototypeChanges = prototypeChanges;
                return this;
            }

            public Builder setType(Invoke.Type type) {
                this.type = type;
                return this;
            }

            public MethodLookupResult build() {
                assert (this.reference != null);
                return new MethodLookupResult((DexMethod)this.reference, (DexMethod)this.reboundReference, this.type, this.prototypeChanges);
            }

            @Override
            public Builder self() {
                return this;
            }
        }
    }

    public static class FieldLookupResult
    extends MemberLookupResult<DexField> {
        private final DexType readCastType;
        private final DexType writeCastType;

        private FieldLookupResult(DexField reference, DexField reboundReference, DexType readCastType, DexType writeCastType) {
            super(reference, reboundReference, null);
            this.readCastType = readCastType;
            this.writeCastType = writeCastType;
        }

        public static Builder builder(GraphLens lens) {
            return new Builder(lens);
        }

        public boolean hasReadCastType() {
            return this.readCastType != null;
        }

        public DexType getReadCastType() {
            return this.readCastType;
        }

        public DexType getRewrittenReadCastType(Function<DexType, DexType> fn) {
            return this.hasReadCastType() ? fn.apply(this.readCastType) : null;
        }

        public boolean hasWriteCastType() {
            return this.writeCastType != null;
        }

        public DexType getWriteCastType() {
            return this.writeCastType;
        }

        public DexType getRewrittenWriteCastType(Function<DexType, DexType> fn) {
            return this.hasWriteCastType() ? fn.apply(this.writeCastType) : null;
        }

        public static class Builder
        extends MemberLookupResult.Builder<DexField, Builder> {
            private DexType readCastType;
            private DexType writeCastType;
            private GraphLens lens;

            private Builder(GraphLens lens) {
                this.lens = lens;
            }

            public Builder setReadCastType(DexType readCastType) {
                this.readCastType = readCastType;
                return this;
            }

            public Builder setWriteCastType(DexType writeCastType) {
                this.writeCastType = writeCastType;
                return this;
            }

            @Override
            public Builder self() {
                return this;
            }

            public FieldLookupResult build() {
                return new FieldLookupResult((DexField)this.reference, (DexField)this.reboundReference, this.readCastType, this.writeCastType);
            }
        }
    }

    static abstract class MemberLookupResult<R extends DexMember<?, R>> {
        private final R reference;
        private final R reboundReference;

        private MemberLookupResult(R reference, R reboundReference) {
            this.reference = reference;
            this.reboundReference = reboundReference;
        }

        /* synthetic */ MemberLookupResult(DexMember x0, DexMember x1, 1 x2) {
            this(x0, x1);
        }

        public R getReference() {
            return this.reference;
        }

        public R getRewrittenReference(BidirectionalManyToOneRepresentativeMap<R, R> rewritings) {
            return (R)((DexMember)rewritings.getOrDefault(this.reference, this.reference));
        }

        public R getRewrittenReference(Map<R, R> rewritings) {
            return (R)((DexMember)rewritings.getOrDefault(this.reference, this.reference));
        }

        public boolean hasReboundReference() {
            return this.reboundReference != null;
        }

        public R getReboundReference() {
            return this.reboundReference;
        }

        public R getRewrittenReboundReference(BidirectionalManyToOneRepresentativeMap<R, R> rewritings) {
            return (R)((DexMember)rewritings.getOrDefault(this.reboundReference, this.reboundReference));
        }

        public R getRewrittenReboundReference(Function<R, R> rewritings) {
            DexMember rewrittenReboundReference = (DexMember)rewritings.apply(this.reboundReference);
            return (R)(rewrittenReboundReference != null ? rewrittenReboundReference : this.reboundReference);
        }

        static abstract class Builder<R extends DexMember<?, R>, Self extends Builder<R, Self>> {
            R reference;
            R reboundReference;

            Builder() {
            }

            public Self setReference(R reference) {
                this.reference = reference;
                return this.self();
            }

            public Self setReboundReference(R reboundReference) {
                this.reboundReference = reboundReference;
                return this.self();
            }

            public abstract Self self();
        }
    }
}

