/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class InnerClassAttribute {
    private final int access;
    private final DexType inner;
    private final DexType outer;
    private final DexString innerName;

    public static InnerClassAttribute createUnknownNamedInnerClass(DexType inner, DexType outer) {
        return new InnerClassAttribute(0, inner, outer, DexItemFactory.unknownTypeName);
    }

    public InnerClassAttribute(int access, DexType inner, DexType outer, DexString innerName) {
        assert (inner != null);
        this.access = access;
        this.inner = inner;
        this.outer = outer;
        this.innerName = innerName;
    }

    public static List<InnerClassAttribute> emptyList() {
        return Collections.emptyList();
    }

    public void forEachType(Consumer<DexType> consumer) {
        if (this.inner != null) {
            consumer.accept(this.inner);
        }
        if (this.outer != null) {
            consumer.accept(this.outer);
        }
    }

    public boolean isNamed() {
        return this.innerName != null;
    }

    public boolean isAnonymous() {
        return this.innerName == null;
    }

    public int getAccess() {
        return this.access;
    }

    public DexType getInner() {
        return this.inner;
    }

    public DexType getOuter() {
        return this.outer;
    }

    public DexString getInnerName() {
        return this.innerName;
    }

    public void write(ClassWriter writer, NamingLens lens, InternalOptions options) {
        String internalName = lens.lookupInternalName(this.inner);
        writer.visitInnerClass(internalName, this.outer == null ? null : lens.lookupInternalName(this.outer), this.innerName == null ? null : lens.lookupInnerName(this, options).toString(), this.access);
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.inner.collectIndexedItems(indexedItems);
        if (this.outer != null) {
            this.outer.collectIndexedItems(indexedItems);
        }
        if (this.innerName != null) {
            this.innerName.collectIndexedItems(indexedItems);
        }
    }

    public DexType getLiveContext(AppView<? extends AppInfoWithLiveness> appView) {
        DexClass inner;
        DexType context = this.getOuter();
        if (context == null && (inner = appView.definitionFor(this.getInner())) != null && inner.getEnclosingMethodAttribute() != null) {
            EnclosingMethodAttribute enclosingMethodAttribute = inner.getEnclosingMethodAttribute();
            if (enclosingMethodAttribute.getEnclosingClass() != null) {
                context = enclosingMethodAttribute.getEnclosingClass();
            } else {
                DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
                if (!appView.appInfo().isLiveMethod(enclosingMethod)) {
                    return null;
                }
                context = enclosingMethod.holder;
            }
        }
        return context;
    }

    public String toString() {
        return "[access : " + Integer.toHexString(this.access) + ", inner: " + this.inner.toDescriptorString() + ", outer: " + (this.outer == null ? "null" : this.outer.toDescriptorString()) + ", innerName: " + (this.innerName == null ? "(anonymous)" : this.innerName.toString()) + "]";
    }
}

