/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.ApplicationReaderMap;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.desugar.records.RecordDesugaring;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class JarApplicationReader {
    public final InternalOptions options;
    private final ConcurrentHashMap<String, Type> asmObjectTypeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Type> asmTypeCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DexString> stringCache = new ConcurrentHashMap();
    private final ApplicationReaderMap applicationReaderMap;
    private boolean hasReadRecordReferenceFromProgramClass = false;

    public JarApplicationReader(InternalOptions options) {
        this.options = options;
        this.applicationReaderMap = ApplicationReaderMap.getInstance(options);
    }

    private static String getShortyDescriptor(String descriptor) {
        if (descriptor.length() == 1) {
            return descriptor;
        }
        assert (descriptor.charAt(0) == 'L' || descriptor.charAt(0) == '[');
        return "L";
    }

    private boolean isValidDescriptor(String desc) {
        return this.getAsmType(desc).getDescriptor().equals(desc);
    }

    private boolean isValidInternalName(String name) {
        return this.getAsmObjectType(name).getInternalName().equals(name);
    }

    public Type getAsmObjectType(String name) {
        return this.asmObjectTypeCache.computeIfAbsent(name, Type::getObjectType);
    }

    public Type getAsmType(String name) {
        return this.asmTypeCache.computeIfAbsent(name, Type::getType);
    }

    public DexItemFactory getFactory() {
        return this.options.itemFactory;
    }

    public DexString getString(String string) {
        return this.stringCache.computeIfAbsent(string, this.options.itemFactory::createString);
    }

    public DexType getType(Type type) {
        return this.getTypeFromDescriptor(type.getDescriptor());
    }

    public DexType getTypeFromName(String name) {
        assert (this.isValidInternalName(name));
        return this.getType(this.getAsmObjectType(name));
    }

    public DexType getTypeFromDescriptor(String desc) {
        assert (this.isValidDescriptor(desc));
        String actualDesc = this.applicationReaderMap.getDescriptor(desc);
        return this.options.itemFactory.createType(this.getString(actualDesc));
    }

    public DexTypeList getTypeListFromNames(String[] names) {
        if (names.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = this.getTypeFromName(names[i]);
        }
        return new DexTypeList(types);
    }

    public DexTypeList getTypeListFromDescriptors(String[] descriptors) {
        if (descriptors.length == 0) {
            return DexTypeList.empty();
        }
        DexType[] types = new DexType[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            types[i] = this.getTypeFromDescriptor(descriptors[i]);
        }
        return new DexTypeList(types);
    }

    public DexField getField(String owner, String name, String desc) {
        return this.getField(this.getTypeFromName(owner), name, desc);
    }

    public DexField getField(DexType owner, String name, String desc) {
        return this.options.itemFactory.createField(owner, this.getTypeFromDescriptor(desc), this.getString(name));
    }

    public DexMethod getMethod(String owner, String name, String desc) {
        return this.getMethod(this.getTypeFromName(owner), name, desc);
    }

    public DexMethod getMethod(DexType owner, String name, String desc) {
        return this.options.itemFactory.createMethod(owner, this.getProto(desc), this.getString(name));
    }

    public DexCallSite getCallSite(String methodName, String methodProto, DexMethodHandle bootstrapMethod, List<DexValue> bootstrapArgs) {
        return this.options.itemFactory.createCallSite(this.getString(methodName), this.getProto(methodProto), bootstrapMethod, bootstrapArgs);
    }

    public DexMethodHandle getMethodHandle(DexMethodHandle.MethodHandleType type, DexMember<? extends DexItem, ? extends DexMember<?, ?>> fieldOrMethod, boolean isInterface) {
        return this.options.itemFactory.createMethodHandle(type, fieldOrMethod, isInterface);
    }

    public DexProto getProto(String desc) {
        assert (this.isValidDescriptor(desc));
        String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(desc);
        String[] argumentDescriptors = DescriptorUtils.getArgumentTypeDescriptors(desc);
        StringBuilder shortyDescriptor = new StringBuilder();
        shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(returnTypeDescriptor));
        for (int i = 0; i < argumentDescriptors.length; ++i) {
            shortyDescriptor.append(JarApplicationReader.getShortyDescriptor(argumentDescriptors[i]));
        }
        DexProto proto = this.options.itemFactory.createProto(this.getTypeFromDescriptor(returnTypeDescriptor), this.getTypeListFromDescriptors(argumentDescriptors), this.getString(shortyDescriptor.toString()));
        return proto;
    }

    public Type getReturnType(String methodDescriptor) {
        return this.getAsmType(DescriptorUtils.getReturnTypeDescriptor(methodDescriptor));
    }

    public void setHasReadRecordReferenceFromProgramClass() {
        this.hasReadRecordReferenceFromProgramClass = true;
    }

    public boolean hasReadRecordReferenceFromProgramClass() {
        return this.hasReadRecordReferenceFromProgramClass;
    }

    public void checkFieldForRecord(DexField dexField) {
        if (this.options.shouldDesugarRecords() && RecordDesugaring.refersToRecord(dexField, this.getFactory())) {
            this.setHasReadRecordReferenceFromProgramClass();
        }
    }

    public void checkMethodForRecord(DexMethod dexMethod) {
        if (this.options.shouldDesugarRecords() && RecordDesugaring.refersToRecord(dexMethod, this.getFactory())) {
            this.setHasReadRecordReferenceFromProgramClass();
        }
    }
}

