/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexApplicationReadFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.Timing;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LazyLoadedDexApplication
extends DexApplication {
    private final ProgramClassCollection programClasses;
    private final ClasspathClassCollection classpathClasses;
    private final LibraryClassCollection libraryClasses;

    private LazyLoadedDexApplication(ClassNameMapper proguardMap, DexApplicationReadFlags flags, ProgramClassCollection programClasses, ImmutableList<DataResourceProvider> dataResourceProviders, ClasspathClassCollection classpathClasses, LibraryClassCollection libraryClasses, InternalOptions options, DexString highestSortingString, Timing timing) {
        super(proguardMap, flags, dataResourceProviders, options, highestSortingString, timing);
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    private <T extends DexClass> boolean addClassToBuilderIfNotNull(T clazz, Consumer<T> adder) {
        if (clazz != null) {
            adder.accept(clazz);
            return true;
        }
        return false;
    }

    private static <T extends DexClass> ImmutableMap<DexType, T> fillPrioritizedClasses(Map<DexType, T> classCollection, Function<DexType, DexClass> getExisting, InternalOptions options) {
        if (classCollection != null) {
            Set<DexType> javaLibraryOverride = Sets.newIdentityHashSet();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            classCollection.forEach((type, clazz) -> {
                DexClass other = (DexClass)getExisting.apply((DexType)type);
                if (other == null) {
                    builder.put(type, clazz);
                } else if (type.getPackageName().startsWith("java.") && (clazz.isLibraryClass() || other.isLibraryClass())) {
                    javaLibraryOverride.add((DexType)type);
                }
            });
            if (!javaLibraryOverride.isEmpty()) {
                LazyLoadedDexApplication.warnJavaLibraryOverride(options, javaLibraryOverride);
            }
            return builder.build();
        }
        return ImmutableMap.of();
    }

    private static void warnJavaLibraryOverride(InternalOptions options, Set<DexType> javaLibraryOverride) {
        if (options.ignoreJavaLibraryOverride) {
            return;
        }
        String joined = javaLibraryOverride.stream().sorted().map(DexType::toString).collect(Collectors.joining(", "));
        String message = "The following library types, prefixed by java., are present both as library and non library classes: " + joined + ". " + (options.lookupLibraryBeforeProgram ? "Non library" : "Library") + " classes will be ignored.";
        options.reporter.warning(message);
    }

    List<DexProgramClass> programClasses() {
        this.programClasses.forceLoad(t -> true);
        return this.programClasses.getAllClasses();
    }

    @Override
    public void forEachProgramType(Consumer<DexType> consumer) {
        this.programClasses.getAllTypes().forEach(consumer);
    }

    @Override
    public void forEachLibraryType(Consumer<DexType> consumer) {
        this.libraryClasses.getAllClassProviderTypes().forEach(consumer);
    }

    @Override
    public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
        ClassResolutionResult.Builder builder;
        block6: {
            block5: {
                builder = ClassResolutionResult.builder();
                if (this.libraryClasses != null) {
                    this.addClassToBuilderIfNotNull((DexLibraryClass)this.libraryClasses.get(type), builder::add);
                }
                if (this.programClasses == null) break block5;
                if (this.addClassToBuilderIfNotNull((DexProgramClass)this.programClasses.get(type), builder::add)) break block6;
            }
            if (this.classpathClasses != null) {
                this.addClassToBuilderIfNotNull((DexClasspathClass)this.classpathClasses.get(type), builder::add);
            }
        }
        return builder.build();
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        DexClass clazz = null;
        if (this.options.lookupLibraryBeforeProgram) {
            if (this.libraryClasses != null) {
                clazz = (DexClass)this.libraryClasses.get(type);
            }
            if (clazz == null) {
                clazz = (DexClass)this.programClasses.get(type);
            }
            if (clazz == null && this.classpathClasses != null) {
                clazz = (DexClass)this.classpathClasses.get(type);
            }
        } else {
            clazz = (DexClass)this.programClasses.get(type);
            if (clazz == null && this.classpathClasses != null) {
                clazz = (DexClass)this.classpathClasses.get(type);
            }
            if (clazz == null && this.libraryClasses != null) {
                clazz = (DexClass)this.libraryClasses.get(type);
            }
        }
        return clazz;
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        return (DexProgramClass)this.programClasses.get(type);
    }

    public DexLibraryClass libraryDefinitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup library definition for type: " + type;
        return (DexLibraryClass)this.libraryClasses.get(type);
    }

    public AllClasses loadAllClasses() {
        return new AllClasses(this.libraryClasses, this.classpathClasses, this.programClasses, this.options);
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return new DirectMappedDexApplication.Builder(this).build().asDirect();
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public String toString() {
        return "Application (" + this.programClasses + "; " + this.classpathClasses + "; " + this.libraryClasses + ")";
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private ClasspathClassCollection classpathClasses;
        private LibraryClassCollection libraryClasses;
        private final ApplicationReader.ProgramClassConflictResolver resolver;

        Builder(ApplicationReader.ProgramClassConflictResolver resolver, InternalOptions options, Timing timing) {
            super(options, timing);
            this.resolver = resolver;
            this.classpathClasses = ClasspathClassCollection.empty();
            this.libraryClasses = null;
        }

        private Builder(LazyLoadedDexApplication application) {
            super(application);
            this.resolver = ProgramClassCollection.defaultConflictResolver(application.options.reporter);
            this.classpathClasses = application.classpathClasses;
            this.libraryClasses = application.libraryClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setClasspathClassCollection(ClasspathClassCollection classes) {
            this.classpathClasses = classes;
            return this;
        }

        public Builder setLibraryClassCollection(LibraryClassCollection classes) {
            this.libraryClasses = classes;
            return this;
        }

        @Override
        public void addProgramClassPotentiallyOverridingNonProgramClass(DexProgramClass clazz) {
            this.addProgramClass(clazz);
            this.classpathClasses.clearType(clazz.type);
            this.libraryClasses.clearType(clazz.type);
        }

        @Override
        public LazyLoadedDexApplication build() {
            return new LazyLoadedDexApplication(this.proguardMap, this.flags, ProgramClassCollection.create(this.getProgramClasses(), this.resolver), ImmutableList.copyOf(this.dataResourceProviders), this.classpathClasses, this.libraryClasses, this.options, this.highestSortingString, this.timing);
        }
    }

    static class AllClasses {
        private final ImmutableMap<DexType, DexProgramClass> programClasses;
        private final ImmutableMap<DexType, DexClasspathClass> classpathClasses;
        private final ImmutableMap<DexType, DexLibraryClass> libraryClasses;

        AllClasses(LibraryClassCollection libraryClassesLoader, ClasspathClassCollection classpathClassesLoader, ProgramClassCollection programClassesLoader, InternalOptions options) {
            ImmutableMap<Object, Object> allClasspathClasses;
            ImmutableMap<Object, Object> allLibraryClasses;
            if (libraryClassesLoader != null) {
                libraryClassesLoader.forceLoad(type -> true);
                allLibraryClasses = libraryClassesLoader.getAllClassesInMap();
            } else {
                allLibraryClasses = ImmutableMap.of();
            }
            assert (programClassesLoader != null);
            assert (programClassesLoader.isFullyLoaded());
            programClassesLoader.forceLoad(type -> true);
            ImmutableMap allProgramClasses = programClassesLoader.getAllClassesInMap();
            if (classpathClassesLoader != null) {
                classpathClassesLoader.forceLoad(type -> true);
                allClasspathClasses = classpathClassesLoader.getAllClassesInMap();
            } else {
                allClasspathClasses = ImmutableMap.of();
            }
            if (options.loadAllClassDefinitions) {
                this.libraryClasses = allLibraryClasses;
                this.programClasses = allProgramClasses;
                this.classpathClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allClasspathClasses, this.programClasses::get, options);
            } else if (options.lookupLibraryBeforeProgram) {
                this.libraryClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allLibraryClasses, type -> null, options);
                this.programClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allProgramClasses, this.libraryClasses::get, options);
                this.classpathClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allClasspathClasses, type -> {
                    DexLibraryClass clazz = this.libraryClasses.get(type);
                    return clazz != null ? clazz : (DexClass)this.programClasses.get(type);
                }, options);
            } else {
                this.programClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allProgramClasses, type -> null, options);
                this.classpathClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allClasspathClasses, this.programClasses::get, options);
                this.libraryClasses = LazyLoadedDexApplication.fillPrioritizedClasses(allLibraryClasses, type -> {
                    DexProgramClass clazz = this.programClasses.get(type);
                    return clazz != null ? clazz : (DexClass)this.classpathClasses.get(type);
                }, options);
            }
        }

        public ImmutableMap<DexType, DexProgramClass> getProgramClasses() {
            return this.programClasses;
        }

        public ImmutableMap<DexType, DexClasspathClass> getClasspathClasses() {
            return this.classpathClasses;
        }

        public ImmutableMap<DexType, DexLibraryClass> getLibraryClasses() {
            return this.libraryClasses;
        }
    }
}

