/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LookupResult;
import com.android.tools.r8.graph.PinnedPredicate;
import com.android.tools.r8.utils.WorkList;
import java.util.Set;

public class LookupCompletenessHelper {
    private final PinnedPredicate pinnedPredicate;
    private Set<DexType> pinnedInstantiations;
    private Set<DexMethod> pinnedMethods;

    LookupCompletenessHelper(PinnedPredicate pinnedPredicate) {
        this.pinnedPredicate = pinnedPredicate;
    }

    private boolean isMethodKeptInSuperTypeOrIsLibrary(WorkList<DexType> workList, DexMethod method, AppInfoWithClassHierarchy appInfo) {
        while (workList.hasNext()) {
            DexClass parent = appInfo.definitionFor(workList.next());
            if (parent == null) continue;
            DexEncodedMethod methodInClass = parent.lookupVirtualMethod(method);
            if (methodInClass != null && (parent.isNotProgramClass() || this.pinnedPredicate.isPinned(methodInClass))) {
                return true;
            }
            if (parent.superType != null) {
                workList.addIfNotSeen(parent.superType);
            }
            workList.addIfNotSeen((DexType[])parent.interfaces.values);
        }
        return false;
    }

    void checkClass(DexClass clazz) {
        if (this.pinnedPredicate.isPinned(clazz)) {
            if (this.pinnedInstantiations == null) {
                this.pinnedInstantiations = Sets.newIdentityHashSet();
            }
            this.pinnedInstantiations.add(clazz.type);
        }
    }

    void checkMethod(DexEncodedMethod method) {
        if (this.pinnedPredicate.isPinned(method)) {
            if (this.pinnedMethods == null) {
                this.pinnedMethods = Sets.newIdentityHashSet();
            }
            this.pinnedMethods.add((DexMethod)method.getReference());
        }
    }

    void checkDexClassAndMethod(DexClassAndMethod classAndMethod) {
        this.checkClass(classAndMethod.getHolder());
        this.checkMethod((DexEncodedMethod)classAndMethod.getDefinition());
    }

    LookupResult.LookupResultSuccess.LookupResultCollectionState computeCollectionState(DexMethod method, AppInfoWithClassHierarchy appInfo) {
        assert (this.pinnedInstantiations == null || !this.pinnedInstantiations.isEmpty());
        if (this.pinnedInstantiations == null) {
            return LookupResult.LookupResultSuccess.LookupResultCollectionState.Complete;
        }
        if (this.pinnedMethods != null) {
            return LookupResult.LookupResultSuccess.LookupResultCollectionState.Incomplete;
        }
        WorkList<DexType> workList = WorkList.newIdentityWorkList(this.pinnedInstantiations);
        while (workList.hasNext()) {
            if (!this.isMethodKeptInSuperTypeOrIsLibrary(workList, method, appInfo)) continue;
            return LookupResult.LookupResultSuccess.LookupResultCollectionState.Incomplete;
        }
        return LookupResult.LookupResultSuccess.LookupResultCollectionState.Complete;
    }
}

