/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.LookupLambdaTarget;
import com.android.tools.r8.graph.LookupTarget;
import com.android.tools.r8.utils.collections.DexClassAndMethodSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class LookupResult {
    public static LookupResultSuccess createResult(DexClassAndMethodSet methodTargets, List<LookupLambdaTarget> lambdaTargets, List<DexEncodedMethod> methodsCausingFailure, LookupResultSuccess.LookupResultCollectionState state) {
        return new LookupResultSuccess(methodTargets, lambdaTargets, methodsCausingFailure, state);
    }

    public static LookupResultFailure createFailedResult() {
        return LookupResultFailure.INSTANCE;
    }

    public static LookupResultSuccess getIncompleteEmptyResult() {
        return LookupResultSuccess.EMPTY_INSTANCE;
    }

    public boolean isLookupResultFailure() {
        return false;
    }

    public boolean isLookupResultSuccess() {
        return false;
    }

    public LookupResultFailure asLookupResultFailure() {
        return null;
    }

    public LookupResultSuccess asLookupResultSuccess() {
        return null;
    }

    public final void forEach(Consumer<? super LookupTarget> onTarget) {
        this.forEach(onTarget, onTarget);
    }

    public abstract void forEach(Consumer<? super DexClassAndMethod> var1, Consumer<? super LookupLambdaTarget> var2);

    public abstract void forEachFailureDependency(Consumer<? super DexEncodedMethod> var1);

    public static class LookupResultFailure
    extends LookupResult {
        private static final LookupResultFailure INSTANCE = new LookupResultFailure();

        private LookupResultFailure() {
        }

        @Override
        public LookupResultFailure asLookupResultFailure() {
            return this;
        }

        @Override
        public boolean isLookupResultFailure() {
            return true;
        }

        @Override
        public void forEach(Consumer<? super DexClassAndMethod> onMethodTarget, Consumer<? super LookupLambdaTarget> onLambdaTarget) {
        }

        @Override
        public void forEachFailureDependency(Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
        }
    }

    public static class LookupResultSuccess
    extends LookupResult {
        private static final LookupResultSuccess EMPTY_INSTANCE = new LookupResultSuccess(DexClassAndMethodSet.empty(), Collections.emptyList(), Collections.emptyList(), LookupResultCollectionState.Incomplete);
        private final DexClassAndMethodSet methodTargets;
        private final List<LookupLambdaTarget> lambdaTargets;
        private final List<DexEncodedMethod> methodsCausingFailure;
        private LookupResultCollectionState state;

        private LookupResultSuccess(DexClassAndMethodSet methodTargets, List<LookupLambdaTarget> lambdaTargets, List<DexEncodedMethod> methodsCausingFailure, LookupResultCollectionState state) {
            this.methodTargets = methodTargets;
            this.lambdaTargets = lambdaTargets;
            this.methodsCausingFailure = methodsCausingFailure;
            this.state = state;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean isEmpty() {
            return this.methodTargets.isEmpty() && this.lambdaTargets.isEmpty();
        }

        public boolean hasMethodTargets() {
            return !this.methodTargets.isEmpty();
        }

        public boolean hasLambdaTargets() {
            return !this.lambdaTargets.isEmpty();
        }

        @Override
        public void forEach(Consumer<? super DexClassAndMethod> onMethodTarget, Consumer<? super LookupLambdaTarget> onLambdaTarget) {
            this.methodTargets.forEach(onMethodTarget);
            this.lambdaTargets.forEach(onLambdaTarget);
        }

        @Override
        public void forEachFailureDependency(Consumer<? super DexEncodedMethod> methodCausingFailureConsumer) {
            this.methodsCausingFailure.forEach(methodCausingFailureConsumer);
        }

        public boolean contains(DexEncodedMethod method) {
            return this.methodTargets.contains(method);
        }

        @Override
        public LookupResultSuccess asLookupResultSuccess() {
            return this;
        }

        @Override
        public boolean isLookupResultSuccess() {
            return true;
        }

        public boolean isIncomplete() {
            return this.state == LookupResultCollectionState.Incomplete;
        }

        public boolean isComplete() {
            return this.state == LookupResultCollectionState.Complete;
        }

        public void setIncomplete() {
            this.state = LookupResultCollectionState.Incomplete;
        }

        public LookupTarget getSingleLookupTarget() {
            if (this.isIncomplete() || this.methodTargets.size() + this.lambdaTargets.size() > 1) {
                return null;
            }
            if (this.methodTargets.size() == 1) {
                return (LookupTarget)this.methodTargets.iterator().next();
            }
            if (this.lambdaTargets.size() == 1) {
                return this.lambdaTargets.get(0);
            }
            return null;
        }

        public static class Builder {
            private final DexClassAndMethodSet methodTargets = DexClassAndMethodSet.create();
            private final List<LookupLambdaTarget> lambdaTargets = new ArrayList<LookupLambdaTarget>();
            private final List<DexEncodedMethod> methodsCausingFailure = new ArrayList<DexEncodedMethod>();
            private LookupResultCollectionState state;

            public Builder addMethodTarget(DexClassAndMethod methodTarget) {
                this.methodTargets.add(methodTarget);
                return this;
            }

            public Builder addLambdaTarget(LookupLambdaTarget lambdaTarget) {
                this.lambdaTargets.add(lambdaTarget);
                return this;
            }

            public Builder addMethodCausingFailure(DexEncodedMethod methodCausingFailure) {
                this.methodsCausingFailure.add(methodCausingFailure);
                return this;
            }

            public Builder setState(LookupResultCollectionState state) {
                this.state = state;
                return this;
            }

            public LookupResultSuccess build() {
                return new LookupResultSuccess(this.methodTargets, this.lambdaTargets, this.methodsCausingFailure, this.state);
            }
        }

        public static enum LookupResultCollectionState {
            Complete,
            Incomplete;

        }
    }
}

