/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class MethodCollectionBacking {
    abstract boolean verify();

    abstract String getDescriptionString();

    boolean belongsToDirectPool(DexEncodedMethod method) {
        return method.belongsToDirectPool();
    }

    boolean belongsToVirtualPool(DexEncodedMethod method) {
        return method.belongsToVirtualPool();
    }

    abstract int numberOfDirectMethods();

    abstract int numberOfVirtualMethods();

    abstract int size();

    abstract TraversalContinuation<?> traverse(Function<DexEncodedMethod, TraversalContinuation<?>> var1);

    abstract MethodCollectionBacking map(Function<DexEncodedMethod, DexEncodedMethod> var1);

    void forEachMethod(Consumer<DexEncodedMethod> fn) {
        this.forEachMethod(fn, Predicates.alwaysTrue());
    }

    void forEachMethod(Consumer<DexEncodedMethod> fn, Predicate<DexEncodedMethod> predicate) {
        this.traverse(method -> {
            if (predicate.test((DexEncodedMethod)method)) {
                fn.accept((DexEncodedMethod)method);
            }
            return TraversalContinuation.doContinue();
        });
    }

    void forEachDirectMethod(Consumer<DexEncodedMethod> fn) {
        this.forEachMethod(fn, this::belongsToDirectPool);
    }

    void forEachVirtualMethod(Consumer<DexEncodedMethod> fn) {
        this.forEachMethod(fn, this::belongsToVirtualPool);
    }

    abstract Iterable<DexEncodedMethod> methods();

    abstract Iterable<DexEncodedMethod> directMethods();

    abstract Iterable<DexEncodedMethod> virtualMethods();

    abstract DexEncodedMethod getMethod(DexProto var1, DexString var2);

    abstract DexEncodedMethod getDirectMethod(DexMethod var1);

    abstract DexEncodedMethod getDirectMethod(Predicate<DexEncodedMethod> var1);

    abstract DexEncodedMethod getVirtualMethod(DexMethod var1);

    abstract DexEncodedMethod getVirtualMethod(Predicate<DexEncodedMethod> var1);

    abstract void addMethod(DexEncodedMethod var1);

    abstract void addDirectMethod(DexEncodedMethod var1);

    abstract void addVirtualMethod(DexEncodedMethod var1);

    abstract void addDirectMethods(Collection<DexEncodedMethod> var1);

    abstract void addVirtualMethods(Collection<DexEncodedMethod> var1);

    abstract void clearDirectMethods();

    abstract void clearVirtualMethods();

    abstract DexEncodedMethod removeMethod(DexMethod var1);

    abstract void removeMethods(Set<DexEncodedMethod> var1);

    abstract void setDirectMethods(DexEncodedMethod[] var1);

    abstract void setVirtualMethods(DexEncodedMethod[] var1);

    abstract void replaceMethods(Function<DexEncodedMethod, DexEncodedMethod> var1);

    abstract void replaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> var1);

    abstract void replaceAllDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> var1);

    abstract void replaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> var1);

    abstract void replaceAllVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> var1);

    abstract DexEncodedMethod replaceDirectMethod(DexMethod var1, Function<DexEncodedMethod, DexEncodedMethod> var2);

    abstract DexEncodedMethod replaceVirtualMethod(DexMethod var1, Function<DexEncodedMethod, DexEncodedMethod> var2);

    abstract DexEncodedMethod replaceDirectMethodWithVirtualMethod(DexMethod var1, Function<DexEncodedMethod, DexEncodedMethod> var2);

    abstract void virtualizeMethods(Set<DexEncodedMethod> var1);
}

