/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.MethodCollectionBacking;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class MethodMapBacking
extends MethodCollectionBacking {
    private final boolean isSorted;
    private SortedMap<DexMethodSignature, DexEncodedMethod> methodMap;

    private MethodMapBacking(boolean isSorted, SortedMap<DexMethodSignature, DexEncodedMethod> methodMap) {
        this.isSorted = isSorted;
        this.methodMap = methodMap;
    }

    public static MethodMapBacking createSorted() {
        return new MethodMapBacking(true, MethodMapBacking.createSortedMap());
    }

    public static MethodMapBacking createLinked(int capacity) {
        return new MethodMapBacking(false, MethodMapBacking.createdLinkedMap(capacity));
    }

    private SortedMap<DexMethodSignature, DexEncodedMethod> createMap(int capacity) {
        return this.isSorted ? MethodMapBacking.createSortedMap() : MethodMapBacking.createdLinkedMap(capacity);
    }

    private static SortedMap<DexMethodSignature, DexEncodedMethod> createSortedMap() {
        return new Object2ObjectRBTreeMap<DexMethodSignature, DexEncodedMethod>();
    }

    private static SortedMap<DexMethodSignature, DexEncodedMethod> createdLinkedMap(int capacity) {
        return new Object2ReferenceLinkedOpenHashMap<DexMethodSignature, DexEncodedMethod>(capacity);
    }

    private void replace(DexMethodSignature existingKey, DexEncodedMethod method) {
        if (((DexMethod)method.getReference()).match(existingKey)) {
            this.methodMap.put(existingKey, method);
        } else {
            this.methodMap.remove(existingKey);
            this.methodMap.put(method.getSignature(), method);
        }
    }

    private int numberOfMethodsMatching(Predicate<DexEncodedMethod> predicate) {
        int count = 0;
        for (DexEncodedMethod method : this.methodMap.values()) {
            if (!predicate.test(method)) continue;
            ++count;
        }
        return count;
    }

    private DexEncodedMethod getMethod(Predicate<DexEncodedMethod> predicate) {
        Box found = new Box();
        this.traverse(method -> {
            if (predicate.test((DexEncodedMethod)method)) {
                found.set(method);
                return TraversalContinuation.doBreak();
            }
            return TraversalContinuation.doContinue();
        });
        return (DexEncodedMethod)found.get();
    }

    private DexEncodedMethod replaceMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement, Predicate<DexEncodedMethod> predicate) {
        DexMethodSignature key = method.getSignature();
        DexEncodedMethod existing = (DexEncodedMethod)this.methodMap.get(key);
        if (existing == null || !predicate.test(existing)) {
            return null;
        }
        DexEncodedMethod newMethod = replacement.apply(existing);
        assert (predicate.test(newMethod));
        this.replace(key, newMethod);
        return newMethod;
    }

    private boolean verifyVirtualizedMethods(Set<DexEncodedMethod> methods) {
        for (DexEncodedMethod method : methods) {
            assert (this.belongsToVirtualPool(method));
            assert (this.methodMap.get(method.getSignature()) == method);
        }
        return true;
    }

    @Override
    String getDescriptionString() {
        return "<method-mapbacking/" + (this.isSorted ? "sorted" : "linked") + ">";
    }

    @Override
    boolean verify() {
        this.methodMap.forEach((signature, method) -> {
            assert (((DexMethod)method.getReference()).match((DexMethodSignature)signature));
        });
        return true;
    }

    @Override
    public int numberOfDirectMethods() {
        return this.numberOfMethodsMatching(this::belongsToDirectPool);
    }

    @Override
    public int numberOfVirtualMethods() {
        return this.numberOfMethodsMatching(this::belongsToVirtualPool);
    }

    @Override
    int size() {
        return this.methodMap.size();
    }

    @Override
    TraversalContinuation<?> traverse(Function<DexEncodedMethod, TraversalContinuation<?>> fn) {
        for (Map.Entry<DexMethodSignature, DexEncodedMethod> entry : this.methodMap.entrySet()) {
            TraversalContinuation<?> result = fn.apply(entry.getValue());
            if (!result.shouldBreak()) continue;
            return result;
        }
        return TraversalContinuation.doContinue();
    }

    @Override
    Iterable<DexEncodedMethod> methods() {
        return this.methodMap.values();
    }

    @Override
    Iterable<DexEncodedMethod> directMethods() {
        return () -> IteratorUtils.filter(this.methodMap.values().iterator(), this::belongsToDirectPool);
    }

    @Override
    Iterable<DexEncodedMethod> virtualMethods() {
        return () -> IteratorUtils.filter(this.methodMap.values().iterator(), this::belongsToVirtualPool);
    }

    @Override
    DexEncodedMethod getMethod(DexProto methodProto, DexString methodName) {
        return this.getMethod(DexMethodSignature.create(methodName, methodProto));
    }

    DexEncodedMethod getMethod(DexMethodSignature method) {
        return (DexEncodedMethod)this.methodMap.get(method);
    }

    @Override
    DexEncodedMethod getDirectMethod(DexMethod method) {
        DexEncodedMethod definition = this.getMethod(method.getProto(), method.getName());
        return definition != null && this.belongsToDirectPool(definition) ? definition : null;
    }

    @Override
    DexEncodedMethod getDirectMethod(Predicate<DexEncodedMethod> predicate) {
        Predicate<DexEncodedMethod> isDirect = this::belongsToDirectPool;
        return this.getMethod(isDirect.and(predicate));
    }

    @Override
    DexEncodedMethod getVirtualMethod(DexMethod method) {
        DexEncodedMethod definition = this.getMethod(method.getProto(), method.getName());
        return definition != null && this.belongsToVirtualPool(definition) ? definition : null;
    }

    @Override
    DexEncodedMethod getVirtualMethod(Predicate<DexEncodedMethod> predicate) {
        Predicate<DexEncodedMethod> isVirtual = this::belongsToVirtualPool;
        return this.getMethod(isVirtual.and(predicate));
    }

    @Override
    void addMethod(DexEncodedMethod method) {
        DexMethodSignature key = method.getSignature();
        DexEncodedMethod old = this.methodMap.put(key, method);
        assert (old == null);
    }

    @Override
    void addDirectMethod(DexEncodedMethod method) {
        assert (this.belongsToDirectPool(method));
        this.addMethod(method);
    }

    @Override
    void addVirtualMethod(DexEncodedMethod method) {
        assert (this.belongsToVirtualPool(method));
        this.addMethod(method);
    }

    @Override
    void addDirectMethods(Collection<DexEncodedMethod> methods) {
        for (DexEncodedMethod method : methods) {
            this.addDirectMethod(method);
        }
    }

    @Override
    void addVirtualMethods(Collection<DexEncodedMethod> methods) {
        for (DexEncodedMethod method : methods) {
            this.addVirtualMethod(method);
        }
    }

    @Override
    void clearDirectMethods() {
        this.methodMap.values().removeIf(this::belongsToDirectPool);
    }

    @Override
    void clearVirtualMethods() {
        this.methodMap.values().removeIf(this::belongsToVirtualPool);
    }

    @Override
    DexEncodedMethod removeMethod(DexMethod method) {
        return this.removeMethod(method.getSignature());
    }

    DexEncodedMethod removeMethod(DexMethodSignature method) {
        return (DexEncodedMethod)this.methodMap.remove(method);
    }

    @Override
    void removeMethods(Set<DexEncodedMethod> methods) {
        methods.forEach(method -> {
            DexEncodedMethod cfr_ignored_0 = (DexEncodedMethod)this.methodMap.remove(method.getSignature());
        });
    }

    @Override
    void setDirectMethods(DexEncodedMethod[] methods) {
        if ((methods == null || methods.length == 0) && this.methodMap.isEmpty()) {
            return;
        }
        if (methods == null) {
            methods = DexEncodedMethod.EMPTY_ARRAY;
        }
        SortedMap<DexMethodSignature, DexEncodedMethod> newMap = this.createMap(this.size() + methods.length);
        this.forEachMethod(method -> {
            if (this.belongsToVirtualPool((DexEncodedMethod)method)) {
                newMap.put(method.getSignature(), (DexEncodedMethod)method);
            }
        });
        for (DexEncodedMethod method2 : methods) {
            assert (this.belongsToDirectPool(method2));
            newMap.put(method2.getSignature(), method2);
        }
        this.methodMap = newMap;
    }

    @Override
    void setVirtualMethods(DexEncodedMethod[] methods) {
        if ((methods == null || methods.length == 0) && this.methodMap.isEmpty()) {
            return;
        }
        if (methods == null) {
            methods = DexEncodedMethod.EMPTY_ARRAY;
        }
        SortedMap<DexMethodSignature, DexEncodedMethod> newMap = this.createMap(this.size() + methods.length);
        this.forEachMethod(method -> {
            if (this.belongsToDirectPool((DexEncodedMethod)method)) {
                newMap.put(method.getSignature(), (DexEncodedMethod)method);
            }
        });
        for (DexEncodedMethod method2 : methods) {
            assert (this.belongsToVirtualPool(method2));
            newMap.put(method2.getSignature(), method2);
        }
        this.methodMap = newMap;
    }

    @Override
    void replaceMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        ArrayList<DexEncodedMethod> initialValues = new ArrayList<DexEncodedMethod>(this.methodMap.values());
        for (DexEncodedMethod method : initialValues) {
            DexEncodedMethod newMethod = replacement.apply(method);
            if (newMethod == method) continue;
            DexMethodSignature signature = method.getSignature();
            if (this.getMethod(signature) == method) {
                this.removeMethod(signature);
            }
            this.methodMap.put(newMethod.getSignature(), newMethod);
        }
    }

    @Override
    void replaceDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.replaceMethods(method -> this.belongsToDirectPool((DexEncodedMethod)method) ? (DexEncodedMethod)replacement.apply((DexEncodedMethod)method) : method);
    }

    @Override
    void replaceVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        this.replaceMethods(method -> this.belongsToVirtualPool((DexEncodedMethod)method) ? (DexEncodedMethod)replacement.apply((DexEncodedMethod)method) : method);
    }

    @Override
    void replaceAllDirectMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        ArrayList<DexEncodedMethod> oldMethods = Lists.newArrayList(this.directMethods());
        this.clearDirectMethods();
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(oldMethods.size());
        for (DexEncodedMethod method : oldMethods) {
            newMethods.add(replacement.apply(method));
        }
        this.addDirectMethods(newMethods);
    }

    @Override
    void replaceAllVirtualMethods(Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        ArrayList<DexEncodedMethod> oldMethods = Lists.newArrayList(this.virtualMethods());
        this.clearVirtualMethods();
        ArrayList<DexEncodedMethod> newMethods = new ArrayList<DexEncodedMethod>(oldMethods.size());
        for (DexEncodedMethod method : oldMethods) {
            newMethods.add(replacement.apply(method));
        }
        this.addVirtualMethods(newMethods);
    }

    @Override
    DexEncodedMethod replaceDirectMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        return this.replaceMethod(method, replacement, this::belongsToDirectPool);
    }

    @Override
    DexEncodedMethod replaceVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        return this.replaceMethod(method, replacement, this::belongsToVirtualPool);
    }

    @Override
    DexEncodedMethod replaceDirectMethodWithVirtualMethod(DexMethod method, Function<DexEncodedMethod, DexEncodedMethod> replacement) {
        DexMethodSignature key = method.getSignature();
        DexEncodedMethod existing = (DexEncodedMethod)this.methodMap.get(key);
        if (existing == null || this.belongsToVirtualPool(existing)) {
            return null;
        }
        DexEncodedMethod newMethod = replacement.apply(existing);
        assert (this.belongsToVirtualPool(newMethod));
        this.replace(key, newMethod);
        return newMethod;
    }

    @Override
    void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        assert (this.verifyVirtualizedMethods(privateInstanceMethods));
    }

    @Override
    MethodMapBacking map(Function<DexEncodedMethod, DexEncodedMethod> fn) {
        MethodMapBacking newBacking = new MethodMapBacking(this.isSorted, this.createMap(this.methodMap.size()));
        this.methodMap.forEach((ignore, method) -> newBacking.addMethod((DexEncodedMethod)fn.apply((DexEncodedMethod)method)));
        return newBacking;
    }
}

