/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.collections.BidirectionalManyToManyRepresentativeMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.EmptyBidirectionalOneToOneMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NestedGraphLens
extends GraphLens.NonIdentityGraphLens {
    protected static final EmptyBidirectionalOneToOneMap<DexField, DexField> EMPTY_FIELD_MAP = new EmptyBidirectionalOneToOneMap();
    protected static final EmptyBidirectionalOneToOneMap<DexMethod, DexMethod> EMPTY_METHOD_MAP = new EmptyBidirectionalOneToOneMap();
    protected static final Map<DexType, DexType> EMPTY_TYPE_MAP = Collections.emptyMap();
    protected final BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap;
    protected final Function<DexMethod, DexMethod> methodMap;
    protected final Map<DexType, DexType> typeMap;
    protected BidirectionalManyToManyRepresentativeMap<DexMethod, DexMethod> newMethodSignatures;

    public NestedGraphLens(AppView<?> appView) {
        this(appView, EMPTY_FIELD_MAP, EMPTY_METHOD_MAP, EMPTY_TYPE_MAP);
    }

    public NestedGraphLens(AppView<?> appView, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, BidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap) {
        this(appView, fieldMap, methodMap.getForwardMap(), typeMap, methodMap);
    }

    public NestedGraphLens(AppView<?> appView, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap, BidirectionalManyToManyRepresentativeMap<DexMethod, DexMethod> newMethodSignatures) {
        this(appView, fieldMap, methodMap::get, typeMap, newMethodSignatures);
        assert (!typeMap.isEmpty() || !methodMap.isEmpty() || !fieldMap.isEmpty() || this.isLegitimateToHaveEmptyMappings());
    }

    public NestedGraphLens(AppView<?> appView, BidirectionalManyToOneRepresentativeMap<DexField, DexField> fieldMap, Function<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap, BidirectionalManyToManyRepresentativeMap<DexMethod, DexMethod> newMethodSignatures) {
        super(appView);
        this.fieldMap = fieldMap;
        this.methodMap = methodMap;
        this.typeMap = typeMap;
        this.newMethodSignatures = newMethodSignatures;
    }

    public static Invoke.Type mapVirtualInterfaceInvocationTypes(DexDefinitionSupplier definitions, DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
            DexClass newTargetClass = definitions.definitionFor(newMethod.getHolderType());
            if (newTargetClass == null) {
                return type;
            }
            DexClass originalTargetClass = definitions.definitionFor(originalMethod.getHolderType());
            if (originalTargetClass != null && originalTargetClass.isInterface() ^ type == Invoke.Type.INTERFACE) {
                return newTargetClass.accessFlags.isInterface() ? Invoke.Type.VIRTUAL : Invoke.Type.INTERFACE;
            }
            return newTargetClass.accessFlags.isInterface() ? Invoke.Type.INTERFACE : Invoke.Type.VIRTUAL;
        }
        return type;
    }

    protected boolean isLegitimateToHaveEmptyMappings() {
        return false;
    }

    protected DexType internalGetOriginalType(DexType previous) {
        return previous;
    }

    protected Iterable<DexType> internalGetOriginalTypes(DexType previous) {
        return IterableUtils.singleton(this.internalGetOriginalType(previous));
    }

    @Override
    public DexType getOriginalType(DexType type) {
        return this.getPrevious().getOriginalType(this.internalGetOriginalType(type));
    }

    @Override
    public Iterable<DexType> getOriginalTypes(DexType type) {
        return IterableUtils.flatMap(this.internalGetOriginalTypes(type), this.getPrevious()::getOriginalTypes);
    }

    @Override
    public DexField getOriginalFieldSignature(DexField field) {
        DexField originalField = this.fieldMap.getRepresentativeKeyOrDefault(field, field);
        return this.getPrevious().getOriginalFieldSignature(originalField);
    }

    @Override
    public DexField getRenamedFieldSignature(DexField originalField, GraphLens codeLens) {
        if (this == codeLens) {
            return originalField;
        }
        DexField renamedField = this.getPrevious().getRenamedFieldSignature(originalField);
        return this.internalGetNextFieldSignature(renamedField);
    }

    @Override
    public DexMethod getRenamedMethodSignature(DexMethod originalMethod, GraphLens applied) {
        if (this == applied) {
            return originalMethod;
        }
        DexMethod renamedMethod = this.getPrevious().getRenamedMethodSignature(originalMethod, applied);
        return this.getNextMethodSignature(renamedMethod);
    }

    @Override
    protected DexType internalDescribeLookupClassType(DexType previous) {
        return this.typeMap.getOrDefault(previous, previous);
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        if (previous.hasReboundReference()) {
            DexField rewrittenReboundReference = previous.getRewrittenReboundReference(this.fieldMap);
            DexField rewrittenNonReboundReference = previous.getReference() == previous.getReboundReference() ? rewrittenReboundReference : rewrittenReboundReference.withHolder(this.internalDescribeLookupClassType(((DexField)previous.getReference()).getHolderType()), this.dexItemFactory());
            return ((GraphLens.FieldLookupResult.Builder)((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReboundReference(rewrittenReboundReference)).setReference(rewrittenNonReboundReference)).setReadCastType(previous.getRewrittenReadCastType(this::internalDescribeLookupClassType)).setWriteCastType(previous.getRewrittenWriteCastType(this::internalDescribeLookupClassType)).build();
        }
        DexField rewrittenReference = previous.getRewrittenReference(this.fieldMap);
        return ((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReference(rewrittenReference)).setReadCastType(previous.getRewrittenReadCastType(this::internalDescribeLookupClassType)).setWriteCastType(previous.getRewrittenWriteCastType(this::internalDescribeLookupClassType)).build();
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        if (previous.hasReboundReference()) {
            DexMethod rewrittenReboundReference = previous.getRewrittenReboundReference(this.methodMap);
            DexMethod rewrittenReference = previous.getReference() == previous.getReboundReference() ? rewrittenReboundReference : rewrittenReboundReference.withHolder(this.internalDescribeLookupClassType(((DexMethod)previous.getReference()).getHolderType()), this.dexItemFactory());
            return ((GraphLens.MethodLookupResult.Builder)((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference(rewrittenReference)).setReboundReference(rewrittenReboundReference)).setPrototypeChanges(this.internalDescribePrototypeChanges(previous.getPrototypeChanges(), rewrittenReboundReference)).setType(this.mapInvocationType(rewrittenReboundReference, (DexMethod)previous.getReference(), previous.getType())).build();
        }
        DexMethod newMethod = this.methodMap.apply((DexMethod)previous.getReference());
        if (newMethod == null) {
            newMethod = (DexMethod)previous.getReference();
        }
        RewrittenPrototypeDescription newPrototypeChanges = this.internalDescribePrototypeChanges(previous.getPrototypeChanges(), newMethod);
        if (newMethod == previous.getReference() && newPrototypeChanges == previous.getPrototypeChanges()) {
            return previous;
        }
        return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference(newMethod)).setPrototypeChanges(newPrototypeChanges).setType(this.mapInvocationType(newMethod, (DexMethod)previous.getReference(), previous.getType())).build();
    }

    @Override
    public RewrittenPrototypeDescription lookupPrototypeChangesForMethodDefinition(DexMethod method, GraphLens codeLens) {
        if (this == codeLens) {
            return NestedGraphLens.getIdentityLens().lookupPrototypeChangesForMethodDefinition(method, codeLens);
        }
        DexMethod previous = this.getPreviousMethodSignature(method);
        RewrittenPrototypeDescription lookup = this.getPrevious().lookupPrototypeChangesForMethodDefinition(previous, codeLens);
        return this.internalDescribePrototypeChanges(lookup, method);
    }

    protected RewrittenPrototypeDescription internalDescribePrototypeChanges(RewrittenPrototypeDescription prototypeChanges, DexMethod method) {
        return prototypeChanges;
    }

    protected DexField internalGetNextFieldSignature(DexField field) {
        return this.fieldMap.getOrDefault(field, field);
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return this.newMethodSignatures.getRepresentativeKeyOrDefault(method, method);
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return this.newMethodSignatures.getRepresentativeValueOrDefault(method, method);
    }

    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        return type;
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.getPrevious().isContextFreeForMethods();
    }

    @Override
    public boolean verifyIsContextFreeForMethod(DexMethod method) {
        assert (this.getPrevious().verifyIsContextFreeForMethod(method));
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.typeMap.forEach((from, to) -> builder.append(from.getTypeName()).append(" -> ").append(to.getTypeName()).append(System.lineSeparator()));
        this.fieldMap.forEachManyToOneMapping((fromSet, to) -> {
            builder.append(fromSet.stream().map(DexField::toSourceString).collect(Collectors.joining("," + System.lineSeparator())));
            builder.append(" -> ");
            builder.append(to.toSourceString()).append(System.lineSeparator());
        });
        builder.append(this.getPrevious().toString());
        return builder.toString();
    }
}

