/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.InitClassLens;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitorWithStringTable;
import com.android.tools.r8.utils.structural.CompareToVisitorWithTypeTable;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ObjectToOffsetMapping {
    private static final int NOT_FOUND = -1;
    private static final int NOT_SET = -2;
    private final int lazyDexStringsCount;
    private final AppView<?> appView;
    private final GraphLens graphLens;
    private final NamingLens namingLens;
    private final InitClassLens initClassLens;
    private final LensCodeRewriterUtils lensCodeRewriter;
    private final DexProgramClass[] classes;
    private final Reference2IntLinkedOpenHashMap<DexProto> protos;
    private final Reference2IntLinkedOpenHashMap<DexType> types;
    private final Reference2IntLinkedOpenHashMap<DexMethod> methods;
    private final Reference2IntLinkedOpenHashMap<DexField> fields;
    private Reference2IntLinkedOpenHashMap<DexString> strings;
    private final Reference2IntLinkedOpenHashMap<DexCallSite> callSites;
    private final Reference2IntLinkedOpenHashMap<DexMethodHandle> methodHandles;
    private DexString firstJumboString;
    private final CompareToVisitor compareToVisitor;

    public ObjectToOffsetMapping(AppView<?> appView, NamingLens namingLens, LensCodeRewriterUtils lensCodeRewriter, Collection<DexProgramClass> classes, Collection<DexProto> protos, Collection<DexType> types, Collection<DexMethod> methods, Collection<DexField> fields, Collection<DexString> strings, Collection<DexCallSite> callSites, Collection<DexMethodHandle> methodHandles, int lazyDexStringsCount, Timing timing) {
        assert (appView != null);
        assert (classes != null);
        assert (protos != null);
        assert (types != null);
        assert (methods != null);
        assert (fields != null);
        assert (strings != null);
        assert (callSites != null);
        assert (methodHandles != null);
        this.lazyDexStringsCount = lazyDexStringsCount;
        this.appView = appView;
        this.graphLens = appView.graphLens();
        this.namingLens = namingLens;
        this.initClassLens = appView.initClassLens();
        this.lensCodeRewriter = lensCodeRewriter;
        timing.begin("Sort strings");
        this.strings = this.createSortedMap(strings, DexString::compareTo, this::setFirstJumboString, lazyDexStringsCount);
        CompareToVisitorWithStringTable visitor = new CompareToVisitorWithStringTable(namingLens, this.strings::getInt);
        timing.end();
        timing.begin("Sort types");
        this.types = this.createSortedMap(types, this.compare(visitor), this::failOnOverflow);
        visitor = new CompareToVisitorWithTypeTable(namingLens, this.strings::getInt, this.types::getInt);
        timing.end();
        timing.begin("Sort classes");
        this.classes = ObjectToOffsetMapping.sortClasses(appView.appInfo(), classes, namingLens);
        timing.end();
        timing.begin("Sort protos");
        this.protos = this.createSortedMap(protos, this.compare(visitor), this::failOnOverflow);
        timing.end();
        timing.begin("Sort methods");
        this.methods = this.createSortedMap(methods, this.compare(visitor), this::failOnOverflow);
        timing.end();
        timing.begin("Sort fields");
        this.fields = this.createSortedMap(fields, this.compare(visitor), this::failOnOverflow);
        timing.end();
        timing.begin("Sort call-sites");
        this.callSites = this.createSortedMap(callSites, this.compare(visitor), this::failOnOverflow);
        timing.end();
        timing.begin("Sort method handles");
        this.methodHandles = this.createSortedMap(methodHandles, this.compare(visitor), this::failOnOverflow);
        timing.end();
        final ObjectToOffsetMapping mapping = this;
        this.compareToVisitor = new CompareToVisitorWithTypeTable(namingLens, this.strings::getInt, this.types::getInt){

            @Override
            public int visitDexField(DexField field1, DexField field2) {
                return Integer.compare(mapping.fields.getInt(field1), mapping.fields.getInt(field2));
            }

            @Override
            public int visitDexMethod(DexMethod method1, DexMethod method2) {
                return Integer.compare(mapping.methods.getInt(method1), mapping.methods.getInt(method2));
            }
        };
    }

    private <T extends StructuralItem<T>> Comparator<T> compare(CompareToVisitor visitor) {
        return (a, b) -> a.acceptCompareTo(b, visitor);
    }

    private void setFirstJumboString(DexString string) {
        assert (this.firstJumboString == null);
        this.firstJumboString = string;
    }

    private void failOnOverflow(DexItem item) {
        throw new CompilationError("Index overflow for " + item.getClass());
    }

    private <T> Reference2IntLinkedOpenHashMap<T> createSortedMap(Collection<T> items, Comparator<T> comparator, Consumer<T> onUInt16Overflow) {
        return this.createSortedMap(items, comparator, onUInt16Overflow, 0);
    }

    private <T> Reference2IntLinkedOpenHashMap<T> createSortedMap(Collection<T> items, Comparator<T> comparator, Consumer<T> onUInt16Overflow, int reservedIndicesBeforeOverflow) {
        if (items.isEmpty()) {
            return new Reference2IntLinkedOpenHashMap();
        }
        ArrayList<T> sorted2 = new ArrayList<T>(items);
        sorted2.sort(comparator);
        Reference2IntLinkedOpenHashMap<T> map = new Reference2IntLinkedOpenHashMap<T>(items.size());
        map.defaultReturnValue(-1);
        int index = 0;
        for (T item : sorted2) {
            if (index + reservedIndicesBeforeOverflow == 65536) {
                onUInt16Overflow.accept(item);
            }
            map.put(item, index++);
        }
        return map;
    }

    private static DexProgramClass[] sortClasses(AppInfo appInfo, Collection<DexProgramClass> classes, NamingLens namingLens) {
        ProgramClassDepthsMemoized classDepths = new ProgramClassDepthsMemoized(appInfo);
        List<DexProgramClass> sortedClasses = classes.stream().sorted((x, y) -> {
            int dy;
            int dx = classDepths.getDepth((DexProgramClass)x);
            return dx != (dy = classDepths.getDepth((DexProgramClass)y)) ? dx - dy : x.type.compareToWithNamingLens(y.type, namingLens);
        }).collect(Collectors.toList());
        return sortedClasses.toArray(DexProgramClass.EMPTY_ARRAY);
    }

    private static <T> Collection<T> keysOrEmpty(Reference2IntLinkedOpenHashMap<T> map) {
        return map == null ? Collections.emptyList() : map.keySet();
    }

    private <T extends IndexedDexItem> int getOffsetFor(T item, Reference2IntMap<T> map) {
        int index = map.getInt(item);
        assert (index != -2) : "Index was not set: " + item;
        assert (index != -1) : "Missing dependency: " + item;
        return index;
    }

    public void computeAndReindexForLazyDexStrings(List<DexString> forcedStrings) {
        assert (this.lazyDexStringsCount == forcedStrings.size());
        if (forcedStrings.isEmpty()) {
            return;
        }
        for (DexString forcedString : forcedStrings) {
            if (forcedString == null) continue;
            this.strings.put(forcedString, -1);
        }
        Box newJumboString = new Box();
        this.strings = this.createSortedMap(this.strings.keySet(), DexString::compareTo, newJumboString::set);
        assert (!this.hasJumboStrings() || ((DexString)newJumboString.get()).isGreaterThanOrEqualTo(this.getFirstJumboString()));
    }

    public CompareToVisitor getCompareToVisitor() {
        return this.compareToVisitor;
    }

    public DexItemFactory dexItemFactory() {
        return this.appView.dexItemFactory();
    }

    public GraphLens getGraphLens() {
        return this.graphLens;
    }

    public NamingLens getNamingLens() {
        return this.namingLens;
    }

    public LensCodeRewriterUtils getLensCodeRewriter() {
        return this.lensCodeRewriter;
    }

    public Collection<DexMethod> getMethods() {
        return ObjectToOffsetMapping.keysOrEmpty(this.methods);
    }

    public DexProgramClass[] getClasses() {
        return this.classes;
    }

    public Collection<DexType> getTypes() {
        return ObjectToOffsetMapping.keysOrEmpty(this.types);
    }

    public Collection<DexProto> getProtos() {
        return ObjectToOffsetMapping.keysOrEmpty(this.protos);
    }

    public Collection<DexField> getFields() {
        return ObjectToOffsetMapping.keysOrEmpty(this.fields);
    }

    public Collection<DexString> getStrings() {
        return ObjectToOffsetMapping.keysOrEmpty(this.strings);
    }

    public Collection<DexCallSite> getCallSites() {
        return ObjectToOffsetMapping.keysOrEmpty(this.callSites);
    }

    public Collection<DexMethodHandle> getMethodHandles() {
        return ObjectToOffsetMapping.keysOrEmpty(this.methodHandles);
    }

    public boolean hasJumboStrings() {
        return this.firstJumboString != null;
    }

    public DexString getFirstJumboString() {
        return this.firstJumboString;
    }

    public DexString getFirstString() {
        for (Reference2IntMap.Entry dexStringEntry : this.strings.reference2IntEntrySet()) {
            if (dexStringEntry.getIntValue() != 0) continue;
            return (DexString)dexStringEntry.getKey();
        }
        return null;
    }

    public int getOffsetFor(DexProto proto) {
        return this.getOffsetFor(proto, this.protos);
    }

    public int getOffsetFor(DexField field) {
        return this.getOffsetFor(field, this.fields);
    }

    public int getOffsetFor(DexMethod method) {
        return this.getOffsetFor(method, this.methods);
    }

    public int getOffsetFor(DexString string) {
        return this.getOffsetFor(string, this.strings);
    }

    public int getOffsetFor(DexType type) {
        return this.getOffsetFor(type, this.types);
    }

    public int getOffsetFor(DexCallSite callSite) {
        return this.getOffsetFor(callSite, this.callSites);
    }

    public int getOffsetFor(DexMethodHandle methodHandle) {
        return this.getOffsetFor(methodHandle, this.methodHandles);
    }

    public DexField getClinitField(DexType type) {
        return this.initClassLens.getInitClassField(type);
    }

    private static class ProgramClassDepthsMemoized {
        private static final int UNKNOWN_DEPTH = -1;
        private final AppInfo appInfo;
        private final Reference2IntMap<DexProgramClass> depthOfClasses = new Reference2IntOpenHashMap<DexProgramClass>();

        ProgramClassDepthsMemoized(AppInfo appInfo) {
            this.appInfo = appInfo;
            this.depthOfClasses.defaultReturnValue(-1);
        }

        int getDepth(DexProgramClass programClass) {
            int depth = this.depthOfClasses.getInt(programClass);
            if (depth == -1) {
                int maxDepth;
                DexType superType = programClass.superType;
                if (superType == null) {
                    maxDepth = 0;
                } else {
                    maxDepth = 1;
                    DexProgramClass superClass = this.appInfo.programDefinitionFor(superType, programClass);
                    if (superClass != null) {
                        maxDepth = this.getDepth(superClass);
                    }
                }
                for (DexType inf : programClass.interfaces.values) {
                    DexProgramClass infClass = this.appInfo.programDefinitionFor(inf, programClass);
                    maxDepth = Math.max(maxDepth, infClass == null ? 1 : this.getDepth(infClass));
                }
                depth = maxDepth + 1;
                this.depthOfClasses.put(programClass, depth);
            }
            return depth;
        }
    }
}

