/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ParameterAnnotationsList
extends DexItem
implements StructuralItem<ParameterAnnotationsList> {
    private static final ParameterAnnotationsList EMPTY_PARAMETER_ANNOTATIONS_LIST = new ParameterAnnotationsList();
    private final DexAnnotationSet[] values;
    private final int missingParameterAnnotations;

    private static void specify(StructuralSpecification<ParameterAnnotationsList, ?> spec) {
        ((StructuralSpecification)spec.withItemArray(a -> a.values)).withInt(a -> a.missingParameterAnnotations);
    }

    public static ParameterAnnotationsList empty() {
        return EMPTY_PARAMETER_ANNOTATIONS_LIST;
    }

    private ParameterAnnotationsList() {
        this.values = DexAnnotationSet.EMPTY_ARRAY;
        this.missingParameterAnnotations = 0;
    }

    private ParameterAnnotationsList(DexAnnotationSet[] values2, int missingParameterAnnotations) {
        assert (values2 != null);
        assert (values2.length > 0);
        assert (!ParameterAnnotationsList.isAllEmpty(values2));
        this.values = values2;
        this.missingParameterAnnotations = missingParameterAnnotations;
    }

    public static ParameterAnnotationsList create(DexAnnotationSet[] values2) {
        return ParameterAnnotationsList.create(values2, 0);
    }

    public static ParameterAnnotationsList create(DexAnnotationSet[] values2, int missingParameterAnnotations) {
        return ArrayUtils.isEmpty(values2) || ParameterAnnotationsList.isAllEmpty(values2) ? ParameterAnnotationsList.empty() : new ParameterAnnotationsList(values2, missingParameterAnnotations);
    }

    private static boolean isAllEmpty(DexAnnotationSet[] values2) {
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ParameterAnnotationsList self() {
        return this;
    }

    @Override
    public StructuralMapping<ParameterAnnotationsList> getStructuralMapping() {
        return ParameterAnnotationsList::specify;
    }

    public int getAnnotableParameterCount() {
        return this.size();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ParameterAnnotationsList) {
            return Arrays.equals(this.values, ((ParameterAnnotationsList)other).values);
        }
        return false;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        for (DexAnnotationSet value : this.values) {
            value.collectIndexedItems(indexedItems);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        ParameterAnnotationsList.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.values);
        mixedItems.add(this);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        for (DexAnnotationSet parameterAnnotations : this.values) {
            for (DexAnnotation annotation : parameterAnnotations.annotations) {
                consumer.accept(annotation);
            }
        }
    }

    public int size() {
        return this.missingParameterAnnotations + this.values.length;
    }

    public int countNonMissing() {
        return this.values.length;
    }

    public boolean isMissing(int i) {
        assert (i >= 0);
        return i < this.missingParameterAnnotations;
    }

    public DexAnnotationSet get(int i) {
        assert (i >= 0);
        int adjustedIndex = i - this.missingParameterAnnotations;
        return 0 <= adjustedIndex && adjustedIndex < this.values.length ? this.values[adjustedIndex] : DexAnnotationSet.empty();
    }

    public ParameterAnnotationsList withParameterCount(int parameterCount) {
        if (this == EMPTY_PARAMETER_ANNOTATIONS_LIST || parameterCount == this.size()) {
            return this;
        }
        if (parameterCount < this.size()) {
            DexAnnotationSet[] trimmedValues = new DexAnnotationSet[parameterCount];
            System.arraycopy(this.values, 0, trimmedValues, 0, parameterCount);
            return new ParameterAnnotationsList(trimmedValues, 0);
        }
        return new ParameterAnnotationsList(this.values, parameterCount - this.values.length);
    }

    public ParameterAnnotationsList withFakeThisParameter() {
        if (this.isEmpty()) {
            return this;
        }
        DexAnnotationSet[] newValues = new DexAnnotationSet[this.size() + 1];
        System.arraycopy(this.values, 0, newValues, 1, this.size());
        newValues[0] = DexAnnotationSet.empty();
        return new ParameterAnnotationsList(newValues, 0);
    }

    public ParameterAnnotationsList keepIf(Predicate<DexAnnotation> filter) {
        DexAnnotationSet[] filtered = null;
        boolean allEmpty = true;
        for (int i = 0; i < this.values.length; ++i) {
            DexAnnotationSet updated = this.values[i].keepIf(filter);
            if (updated != this.values[i]) {
                if (filtered == null) {
                    filtered = (DexAnnotationSet[])this.values.clone();
                }
                filtered[i] = updated;
            }
            if (updated.isEmpty()) continue;
            allEmpty = false;
        }
        if (filtered == null) {
            return this;
        }
        if (allEmpty) {
            return ParameterAnnotationsList.empty();
        }
        return new ParameterAnnotationsList(filtered, this.missingParameterAnnotations);
    }

    public ParameterAnnotationsList rewrite(Function<DexAnnotation, DexAnnotation> mapper) {
        if (this.isEmpty()) {
            return this;
        }
        DexAnnotationSet[] rewritten = ArrayUtils.map(this.values, annotations -> annotations.rewrite(mapper), DexAnnotationSet.EMPTY_ARRAY);
        return rewritten != this.values ? ParameterAnnotationsList.create(rewritten, this.missingParameterAnnotations) : this;
    }
}

