/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ProgramPackage
implements Iterable<DexProgramClass> {
    private final String packageDescriptor;
    private final Set<DexProgramClass> classes;

    public ProgramPackage(String packageDescriptor) {
        this(packageDescriptor, Sets::newIdentityHashSet);
    }

    protected ProgramPackage(String packageDescriptor, Supplier<Set<DexProgramClass>> backingFactory) {
        this.packageDescriptor = packageDescriptor;
        this.classes = backingFactory.get();
    }

    public boolean add(DexProgramClass clazz) {
        assert (clazz.getType().getPackageDescriptor().equals(this.packageDescriptor));
        return this.classes.add(clazz);
    }

    public boolean contains(DexProgramClass clazz) {
        return this.classes.contains(clazz);
    }

    public String getLastPackageName() {
        int index = this.packageDescriptor.lastIndexOf(47);
        if (index >= 0) {
            return this.packageDescriptor.substring(index + 1);
        }
        return this.packageDescriptor;
    }

    public String getPackageDescriptor() {
        return this.packageDescriptor;
    }

    public String getPackageName() {
        return DescriptorUtils.getJavaTypeFromBinaryName(this.packageDescriptor);
    }

    public void forEachClass(Consumer<DexProgramClass> consumer) {
        this.forEach(consumer);
    }

    public void forEachField(Consumer<ProgramField> consumer) {
        this.forEach(clazz -> clazz.forEachProgramField(consumer));
    }

    public void forEachMethod(Consumer<ProgramMethod> consumer) {
        this.forEach(clazz -> clazz.forEachProgramMethod(consumer));
    }

    public Set<DexProgramClass> classesInPackage() {
        return ImmutableSet.copyOf(this.classes);
    }

    @Override
    public Iterator<DexProgramClass> iterator() {
        return this.classes.iterator();
    }

    public String toString() {
        return "ProgramPackage(" + this.getPackageName() + ")";
    }
}

