/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;

public class SubtypingInfo {
    private static final int ROOT_LEVEL = 0;
    private static final int UNKNOWN_LEVEL = -1;
    private static final int INTERFACE_LEVEL = -2;
    private static final Set<DexType> NO_DIRECT_SUBTYPE = ImmutableSet.of();
    private final Map<DexType, Set<DexType>> subtypeMap;
    private final Map<DexType, TypeInfo> typeInfo;
    private final DexItemFactory factory;

    private SubtypingInfo(Map<DexType, TypeInfo> typeInfo, Map<DexType, Set<DexType>> subtypeMap, DexItemFactory factory) {
        this.typeInfo = typeInfo;
        this.subtypeMap = subtypeMap;
        this.factory = factory;
    }

    public static SubtypingInfo create(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return SubtypingInfo.create(appView.appInfo());
    }

    public static SubtypingInfo create(AppInfoWithClassHierarchy appInfo) {
        DirectMappedDexApplication directApp = appInfo.app().asDirect();
        return SubtypingInfo.create(Iterables.concat(directApp.programClasses(), directApp.classpathClasses(), directApp.libraryClasses()), appInfo);
    }

    public static SubtypingInfo create(Iterable<? extends DexClass> classes, DexDefinitionSupplier definitions) {
        ConcurrentHashMap<DexType, TypeInfo> typeInfo = new ConcurrentHashMap<DexType, TypeInfo>();
        IdentityHashMap<DexType, Set<DexType>> subtypeMap = new IdentityHashMap<DexType, Set<DexType>>();
        SubtypingInfo.populateSubtypeMap(classes, subtypeMap, typeInfo, definitions);
        return new SubtypingInfo(typeInfo, subtypeMap, definitions.dexItemFactory());
    }

    private static void populateSuperType(Map<DexType, Set<DexType>> map, Map<DexType, TypeInfo> typeInfo, DexType superType, DexClass baseClass, DexDefinitionSupplier definitionSupplier) {
        Set set;
        if (superType != null && (set = map.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            SubtypingInfo.populateAllSuperTypes(map, typeInfo, superType, baseClass, definitionSupplier);
        }
    }

    private TypeInfo getTypeInfo(DexType type) {
        return SubtypingInfo.getTypeInfo(type, this.typeInfo);
    }

    private static TypeInfo getTypeInfo(DexType type, Map<DexType, TypeInfo> typeInfo) {
        assert (type != null);
        return typeInfo.computeIfAbsent(type, TypeInfo::new);
    }

    private static void populateAllSuperTypes(Map<DexType, Set<DexType>> map, Map<DexType, TypeInfo> typeInfo, DexType holder, DexClass baseClass, DexDefinitionSupplier definitionSupplier) {
        DexClass holderClass = definitionSupplier.contextIndependentDefinitionFor(holder);
        TypeInfo typeInfoHere = SubtypingInfo.getTypeInfo(holder, typeInfo);
        if (holderClass != null) {
            holderClass.forEachImmediateSupertype((superType, isInterface) -> {
                SubtypingInfo.populateSuperType(map, typeInfo, superType, baseClass, definitionSupplier);
                TypeInfo superTypeInfo = SubtypingInfo.getTypeInfo(superType, typeInfo);
                if (isInterface.booleanValue()) {
                    superTypeInfo.addInterfaceSubtype(holder);
                } else {
                    superTypeInfo.addDirectSubtype(typeInfoHere);
                }
            });
            if (holderClass.isInterface()) {
                typeInfoHere.tagAsInterface();
            }
        } else {
            DexType objectType = definitionSupplier.dexItemFactory().objectType;
            if (holder != objectType) {
                SubtypingInfo.getTypeInfo(objectType, typeInfo).addDirectSubtype(typeInfoHere);
            }
        }
    }

    private static void populateSubtypeMap(Iterable<? extends DexClass> classes, Map<DexType, Set<DexType>> map, Map<DexType, TypeInfo> typeInfo, DexDefinitionSupplier definitionSupplier) {
        SubtypingInfo.getTypeInfo(definitionSupplier.dexItemFactory().objectType, typeInfo).tagAsSubtypeRoot();
        for (DexClass dexClass : classes) {
            SubtypingInfo.populateAllSuperTypes(map, typeInfo, dexClass.type, dexClass, definitionSupplier);
        }
        map.replaceAll((k, v) -> ImmutableSet.copyOf(v));
        assert (SubtypingInfo.validateLevelsAreCorrect(typeInfo, definitionSupplier));
    }

    private static boolean validateLevelsAreCorrect(Map<DexType, TypeInfo> typeInfo, DexDefinitionSupplier definitionSupplier) {
        Set<DexType> seenTypes = Sets.newIdentityHashSet();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        DexType objectType = definitionSupplier.dexItemFactory().objectType;
        worklist.add(objectType);
        while (!worklist.isEmpty()) {
            DexType next = (DexType)worklist.pop();
            DexClass nextHolder = definitionSupplier.contextIndependentDefinitionFor(next);
            DexType superType = nextHolder == null ? (next == objectType ? null : objectType) : nextHolder.superType;
            assert (!seenTypes.contains(next));
            seenTypes.add(next);
            TypeInfo nextInfo = SubtypingInfo.getTypeInfo(next, typeInfo);
            if (superType == null) {
                assert (nextInfo.hierarchyLevel == 0);
            } else {
                TypeInfo superInfo = SubtypingInfo.getTypeInfo(superType, typeInfo);
                assert (superInfo.hierarchyLevel == nextInfo.hierarchyLevel - 1 || superInfo.hierarchyLevel == 0 && nextInfo.hierarchyLevel == -2);
                assert (superInfo.directSubtypes.contains(next));
            }
            if (nextInfo.hierarchyLevel != -2) {
                worklist.addAll(nextInfo.directSubtypes);
                continue;
            }
            if (nextHolder == null) continue;
            for (DexType iface : nextHolder.interfaces.values) {
                TypeInfo ifaceInfo = SubtypingInfo.getTypeInfo(iface, typeInfo);
                assert (ifaceInfo.directSubtypes.contains(next));
                assert (ifaceInfo.hierarchyLevel == -2);
            }
        }
        return true;
    }

    public Set<DexType> subtypes(DexType type) {
        assert (type.isClassType());
        Set<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    public DexType getSingleDirectSubtype(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.directSubtypes.size() == 1) {
            return Iterables.getFirst(info.directSubtypes, null);
        }
        return null;
    }

    public void forAllImmediateExtendsSubtypes(DexType type, Consumer<DexType> f) {
        this.allImmediateExtendsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allImmediateExtendsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        assert (info.hierarchyLevel != -1);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, t -> this.getTypeInfo((DexType)t).isInterface());
        }
        if (info.hierarchyLevel == 0) {
            return Iterables.filter(info.directSubtypes, t -> !this.getTypeInfo((DexType)t).isInterface());
        }
        return info.directSubtypes;
    }

    public void forAllImmediateImplementsSubtypes(DexType type, Consumer<DexType> f) {
        this.allImmediateImplementsSubtypes(type).forEach(f);
    }

    public Iterable<DexType> allImmediateImplementsSubtypes(DexType type) {
        TypeInfo info = this.getTypeInfo(type);
        if (info.hierarchyLevel == -2) {
            return Iterables.filter(info.directSubtypes, subtype -> !this.getTypeInfo((DexType)subtype).isInterface());
        }
        return ImmutableList.of();
    }

    public void forAllInterfaceRoots(Consumer<DexType> fn) {
        Iterables.filter(this.getTypeInfo((DexType)this.factory.objectType).directSubtypes, subtype -> this.getTypeInfo((DexType)subtype).isInterface()).forEach(fn);
    }

    public Set<DexType> allImmediateSubtypes(DexType type) {
        return this.getTypeInfo((DexType)type).directSubtypes;
    }

    public boolean isUnknown(DexType type) {
        return this.getTypeInfo(type).isUnknown();
    }

    public boolean hasSubtypes(DexType type) {
        return !this.getTypeInfo((DexType)type).directSubtypes.isEmpty();
    }

    void registerNewType(DexType newType, DexType superType) {
        this.getTypeInfo(superType).addDirectSubtype(this.getTypeInfo(newType));
    }

    private static class TypeInfo {
        private final DexType type;
        int hierarchyLevel = -1;
        Set<DexType> directSubtypes = SubtypingInfo.access$000();

        TypeInfo(DexType type) {
            this.type = type;
        }

        private void ensureDirectSubTypeSet() {
            if (this.directSubtypes == NO_DIRECT_SUBTYPE) {
                this.directSubtypes = new ConcurrentSkipListSet<DexType>(StructuralItem::compareTo);
            }
        }

        private void setLevel(int level) {
            if (level == this.hierarchyLevel) {
                return;
            }
            if (this.hierarchyLevel == -2) {
                assert (level == 1);
            } else if (level == -2) {
                assert (this.hierarchyLevel == 1 || this.hierarchyLevel == -1);
                this.hierarchyLevel = -2;
            } else {
                assert (this.hierarchyLevel == -1);
                this.hierarchyLevel = level;
            }
        }

        public int hashCode() {
            return Objects.hash(this.type, this.directSubtypes);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeInfo)) {
                return false;
            }
            TypeInfo other = (TypeInfo)obj;
            return other.type == this.type && other.directSubtypes.equals(this.directSubtypes);
        }

        public String toString() {
            return "TypeInfo{" + this.type + ", level:" + this.hierarchyLevel + "}";
        }

        synchronized void addDirectSubtype(TypeInfo subtypeInfo) {
            assert (this.hierarchyLevel != -1);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(subtypeInfo.type);
            subtypeInfo.setLevel(this.hierarchyLevel + 1);
        }

        void tagAsSubtypeRoot() {
            this.setLevel(0);
        }

        void tagAsInterface() {
            this.setLevel(-2);
        }

        public boolean isInterface() {
            assert (this.hierarchyLevel != -1) : "Program class missing: " + this;
            assert (this.type.isClassType());
            return this.hierarchyLevel == -2;
        }

        public boolean isUnknown() {
            return this.hierarchyLevel == -1;
        }

        synchronized void addInterfaceSubtype(DexType type) {
            this.setLevel(-2);
            this.ensureDirectSubTypeSet();
            this.directSubtypes.add(type);
        }
    }
}

