/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassHierarchyTraversal;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;

public class TopDownClassHierarchyTraversal<T extends DexClass>
extends ClassHierarchyTraversal<T, TopDownClassHierarchyTraversal<T>> {
    private TopDownClassHierarchyTraversal(AppView<? extends AppInfoWithClassHierarchy> appView, ClassHierarchyTraversal.Scope scope) {
        super(appView, scope);
    }

    public static TopDownClassHierarchyTraversal<DexClass> forAllClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new TopDownClassHierarchyTraversal<DexClass>(appView, ClassHierarchyTraversal.Scope.ALL_CLASSES);
    }

    public static TopDownClassHierarchyTraversal<DexLibraryClass> forLibraryClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new TopDownClassHierarchyTraversal<DexLibraryClass>(appView, ClassHierarchyTraversal.Scope.ONLY_LIBRARY_CLASSES);
    }

    public static TopDownClassHierarchyTraversal<DexClass> forLibraryAndClasspathClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new TopDownClassHierarchyTraversal<DexClass>(appView, ClassHierarchyTraversal.Scope.ONLY_LIBRARY_AND_CLASSPATH_CLASSES);
    }

    public static TopDownClassHierarchyTraversal<DexProgramClass> forProgramClasses(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return new TopDownClassHierarchyTraversal<DexProgramClass>(appView, ClassHierarchyTraversal.Scope.ONLY_PROGRAM_CLASSES);
    }

    private boolean shouldTraverseUpwardsFrom(DexClass clazz) {
        switch (this.scope) {
            case ALL_CLASSES: 
            case ONLY_LIBRARY_CLASSES: 
            case ONLY_LIBRARY_AND_CLASSPATH_CLASSES: {
                return true;
            }
            case ONLY_PROGRAM_CLASSES: {
                return clazz.isProgramClass();
            }
        }
        throw new Unreachable();
    }

    @Override
    TopDownClassHierarchyTraversal<T> self() {
        return this;
    }

    @Override
    void addDependentsToWorklist(DexClass clazz) {
        DexClass definition;
        if (this.excludeInterfaces && clazz.isInterface()) {
            return;
        }
        if (this.visited.contains(clazz)) {
            return;
        }
        if (this.scope.shouldBePassedToVisitor(clazz)) {
            DexClass clazzWithTypeT = clazz;
            this.worklist.addFirst(clazzWithTypeT);
        }
        if (clazz.superType != null && (definition = this.definitionSupplier.contextIndependentDefinitionFor(clazz.superType)) != null && this.shouldTraverseUpwardsFrom(definition)) {
            this.addDependentsToWorklist(definition);
        }
        if (!this.excludeInterfaces) {
            for (DexType interfaceType : clazz.interfaces.values) {
                DexClass definition2 = this.definitionSupplier.contextIndependentDefinitionFor(interfaceType);
                if (definition2 == null || !this.shouldTraverseUpwardsFrom(definition2)) continue;
                this.addDependentsToWorklist(definition2);
            }
        }
    }
}

