/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.NestHostClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class TreeFixerBase {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final Map<DexType, DexProgramClass> programClassCache = new IdentityHashMap<DexType, DexProgramClass>();
    private final Map<DexType, DexProgramClass> synthesizedFromClasses = new IdentityHashMap<DexType, DexProgramClass>();
    private final Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

    public TreeFixerBase(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private DexProgramClass recordClassChange(DexProgramClass from, DexProgramClass to) {
        this.recordClassChange(from.getType(), to.getType());
        return to;
    }

    private DexEncodedField recordFieldChange(DexEncodedField from, DexEncodedField to) {
        this.recordFieldChange((DexField)from.getReference(), (DexField)to.getReference());
        return to;
    }

    private DexProgramClass fixupClass(DexProgramClass clazz) {
        DexProgramClass newClass = new DexProgramClass(this.fixupType(clazz.getType()), clazz.getOriginKind(), clazz.getOrigin(), clazz.getAccessFlags(), clazz.superType == null ? null : this.fixupType(clazz.superType), this.fixupTypeList(clazz.interfaces), clazz.getSourceFile(), this.fixupNestHost(clazz.getNestHostClassAttribute()), this.fixupNestMemberAttributes(clazz.getNestMembersClassAttributes()), this.fixupEnclosingMethodAttribute(clazz.getEnclosingMethodAttribute()), this.fixupInnerClassAttributes(clazz.getInnerClasses()), clazz.getClassSignature(), clazz.annotations(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, newHolder -> clazz.getMethodCollection().fixup(newHolder, this::fixupMethod), this.dexItemFactory.getSkipNameValidationForTesting(), clazz.getChecksumSupplier());
        newClass.setInstanceFields(this.fixupFields(clazz.instanceFields()));
        newClass.setStaticFields(this.fixupFields(clazz.staticFields()));
        if (clazz.hasClassFileVersion()) {
            newClass.setInitialClassFileVersion(clazz.getInitialClassFileVersion());
        }
        if (clazz.isDeprecated()) {
            newClass.setDeprecated();
        }
        if (clazz.getKotlinInfo() != null) {
            newClass.setKotlinInfo(clazz.getKotlinInfo());
        }
        if (newClass.getType() != clazz.getType()) {
            return this.recordClassChange(clazz, newClass);
        }
        return newClass;
    }

    private DexEncodedField fixupField(DexEncodedField field, Consumer<DexEncodedField.Builder> consumer) {
        DexField fieldReference = (DexField)field.getReference();
        DexField newFieldReference = this.fixupFieldReference(fieldReference);
        if (newFieldReference != fieldReference) {
            return this.recordFieldChange(field, field.toTypeSubstitutedField(this.appView, newFieldReference, consumer));
        }
        return field;
    }

    private Collection<DexProgramClass> fixupSynthesizedFrom(Collection<DexProgramClass> synthesizedFrom) {
        if (synthesizedFrom.isEmpty()) {
            return synthesizedFrom;
        }
        boolean changed = false;
        ArrayList<DexProgramClass> newSynthesizedFrom = new ArrayList<DexProgramClass>(synthesizedFrom.size());
        for (DexProgramClass clazz : synthesizedFrom) {
            Map<DexType, DexProgramClass> classes = ((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(clazz.getType()) != null ? this.programClassCache : this.synthesizedFromClasses;
            DexProgramClass newClass = classes.computeIfAbsent(clazz.getType(), ignore -> this.fixupClass(clazz));
            newSynthesizedFrom.add(newClass);
            changed |= newClass != clazz;
        }
        return changed ? newSynthesizedFrom : synthesizedFrom;
    }

    private DexType fixupTypeOrNull(DexType type) {
        return type != null ? this.fixupType(type) : null;
    }

    private DexType[] fixupTypes(DexType[] types) {
        boolean changed = false;
        DexType[] newTypes = new DexType[types.length];
        for (int i = 0; i < newTypes.length; ++i) {
            DexType newType;
            DexType type = types[i];
            newTypes[i] = newType = this.fixupType(types[i]);
            changed |= newType != type;
        }
        return changed ? newTypes : types;
    }

    private DexTypeList fixupTypeList(DexTypeList types) {
        DexType[] newTypes = this.fixupTypes(types.values);
        return newTypes != types.values ? new DexTypeList(newTypes) : types;
    }

    public abstract DexType mapClassType(DexType var1);

    public abstract void recordFieldChange(DexField var1, DexField var2);

    public abstract void recordMethodChange(DexMethod var1, DexMethod var2);

    public abstract void recordClassChange(DexType var1, DexType var2);

    public void recordFailedResolutionChanges() {
        if (!((AppInfo)this.appView.appInfo()).hasLiveness()) {
            return;
        }
        AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)this.appView.appInfo()).withLiveness();
        appInfoWithLiveness.getFailedFieldResolutionTargets().forEach(field -> {
            DexField fixedUpField = this.fixupFieldReference((DexField)field);
            if (field != fixedUpField) {
                this.recordFieldChange((DexField)field, fixedUpField);
            }
        });
        appInfoWithLiveness.getFailedMethodResolutionTargets().forEach(method -> {
            DexMethod fixedUpMethod = this.fixupMethodReference((DexMethod)method);
            if (method != fixedUpMethod) {
                this.recordMethodChange((DexMethod)method, fixedUpMethod);
            }
        });
    }

    public DexEncodedMethod recordMethodChange(DexEncodedMethod from, DexEncodedMethod to) {
        this.recordMethodChange((DexMethod)from.getReference(), (DexMethod)to.getReference());
        return to;
    }

    public List<DexProgramClass> fixupClasses(Collection<DexProgramClass> classes) {
        ArrayList<DexProgramClass> newProgramClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            newProgramClasses.add(this.programClassCache.computeIfAbsent(clazz.getType(), ignore -> this.fixupClass(clazz)));
        }
        return newProgramClasses;
    }

    protected EnclosingMethodAttribute fixupEnclosingMethodAttribute(EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute == null) {
            return null;
        }
        DexType enclosingClassType = enclosingMethodAttribute.getEnclosingClass();
        if (enclosingClassType != null) {
            DexType newEnclosingClassType = this.fixupType(enclosingClassType);
            return newEnclosingClassType != enclosingClassType ? new EnclosingMethodAttribute(newEnclosingClassType) : enclosingMethodAttribute;
        }
        DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
        assert (enclosingMethod != null);
        DexMethod newEnclosingMethod = this.fixupMethodReference(enclosingMethodAttribute.getEnclosingMethod());
        return newEnclosingMethod != enclosingMethod ? new EnclosingMethodAttribute(newEnclosingMethod) : enclosingMethodAttribute;
    }

    public DexEncodedField[] fixupFields(List<DexEncodedField> fields) {
        return this.fixupFields(fields, ConsumerUtils.emptyConsumer());
    }

    public DexEncodedField[] fixupFields(List<DexEncodedField> fields, Consumer<DexEncodedField.Builder> consumer) {
        if (fields == null) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        DexEncodedField[] newFields = new DexEncodedField[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            newFields[i] = this.fixupField(fields.get(i), consumer);
        }
        return newFields;
    }

    public DexField fixupFieldReference(DexField field) {
        DexType newType = this.fixupType(field.type);
        DexType newHolder = this.fixupType(field.holder);
        return this.dexItemFactory.createField(newHolder, newType, field.name);
    }

    protected List<InnerClassAttribute> fixupInnerClassAttributes(List<InnerClassAttribute> innerClassAttributes) {
        if (innerClassAttributes.isEmpty()) {
            return innerClassAttributes;
        }
        boolean changed = false;
        ArrayList<InnerClassAttribute> newInnerClassAttributes = new ArrayList<InnerClassAttribute>();
        for (InnerClassAttribute innerClassAttribute : innerClassAttributes) {
            boolean innerClassAttributeChanged;
            DexType innerClassType = innerClassAttribute.getInner();
            DexType newInnerClassType = this.fixupTypeOrNull(innerClassType);
            DexType outerClassType = innerClassAttribute.getOuter();
            DexType newOuterClassType = this.fixupTypeOrNull(outerClassType);
            DexString newInnerName = innerClassAttribute.getInnerName();
            boolean bl = innerClassAttributeChanged = newInnerClassType != innerClassType || newOuterClassType != outerClassType;
            if (innerClassAttributeChanged && innerClassType != null && outerClassType != null && innerClassAttribute.getInnerName() != null) {
                String innerClassName = DescriptorUtils.getInnerClassName(newOuterClassType.toDescriptorString(), newInnerClassType.toDescriptorString());
                if (innerClassName != null) {
                    newInnerName = this.dexItemFactory.createString(innerClassName);
                } else {
                    assert (!this.appView.options().isTreeShakingEnabled());
                    assert (((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(newOuterClassType) == null);
                }
            }
            newInnerClassAttributes.add(new InnerClassAttribute(innerClassAttribute.getAccess(), newInnerClassType, newOuterClassType, newInnerName));
            changed |= innerClassAttributeChanged;
        }
        return changed ? newInnerClassAttributes : innerClassAttributes;
    }

    public DexEncodedMethod fixupMethod(DexEncodedMethod method) {
        DexMethod methodReference = (DexMethod)method.getReference();
        DexMethod newMethodReference = this.fixupMethodReference(methodReference);
        if (newMethodReference != methodReference) {
            return this.recordMethodChange(method, method.toTypeSubstitutedMethod(newMethodReference));
        }
        return method;
    }

    public DexMethod fixupMethodReference(DexMethod method) {
        return this.dexItemFactory.createMethod(this.fixupType(method.holder), this.fixupProto(method.proto), method.name);
    }

    protected NestHostClassAttribute fixupNestHost(NestHostClassAttribute nestHostClassAttribute) {
        return nestHostClassAttribute != null ? new NestHostClassAttribute(this.fixupType(nestHostClassAttribute.getNestHost())) : null;
    }

    protected List<NestMemberClassAttribute> fixupNestMemberAttributes(List<NestMemberClassAttribute> nestMemberAttributes) {
        if (nestMemberAttributes.isEmpty()) {
            return nestMemberAttributes;
        }
        boolean changed = false;
        ArrayList<NestMemberClassAttribute> newNestMemberAttributes = new ArrayList<NestMemberClassAttribute>(nestMemberAttributes.size());
        for (NestMemberClassAttribute nestMemberAttribute : nestMemberAttributes) {
            DexType nestMemberType = nestMemberAttribute.getNestMember();
            DexType newNestMemberType = this.fixupType(nestMemberType);
            newNestMemberAttributes.add(new NestMemberClassAttribute(newNestMemberType));
            changed |= newNestMemberType != nestMemberType;
        }
        return changed ? newNestMemberAttributes : nestMemberAttributes;
    }

    public DexProto fixupProto(DexProto proto) {
        DexProto result = this.protoFixupCache.get(proto);
        if (result == null) {
            DexType returnType = this.fixupType(proto.returnType);
            DexType[] arguments = this.fixupTypes(proto.parameters.values);
            result = this.dexItemFactory.createProto(returnType, arguments);
            this.protoFixupCache.put(proto, result);
        }
        return result;
    }

    public DexType fixupType(DexType type) {
        if (type.isArrayType()) {
            DexType fixed;
            DexType base = type.toBaseType(this.dexItemFactory);
            if (base == (fixed = this.fixupType(base))) {
                return type;
            }
            return type.replaceBaseType(fixed, this.dexItemFactory);
        }
        if (type.isClassType()) {
            return this.mapClassType(type);
        }
        return type;
    }

    public DexMethodSignature fixupMethodSignature(DexMethodSignature signature) {
        return signature.withProto(this.fixupProto(signature.getProto()));
    }
}

