/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.code.CfOrDexInstanceFieldRead;
import com.android.tools.r8.code.CfOrDexInstruction;
import com.android.tools.r8.code.CfOrDexStaticFieldRead;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Definition;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ListIterator;

public abstract class UseRegistry<T extends Definition> {
    private final AppView<?> appView;
    private final T context;
    private TraversalContinuation<?> continuation = TraversalContinuation.doContinue();

    public UseRegistry(AppView<?> appView, T context) {
        this.appView = appView;
        this.context = context;
    }

    public final void accept(ProgramMethod method) {
        method.registerCodeReferences(this);
    }

    public DexItemFactory dexItemFactory() {
        return this.appView.dexItemFactory();
    }

    public void doBreak() {
        assert (this.continuation.shouldContinue());
        this.continuation = TraversalContinuation.doBreak();
    }

    public GraphLens getCodeLens() {
        assert (this.context.isMethod());
        return ((DexEncodedMethod)this.getMethodContext().getDefinition()).getCode().getCodeLens(this.appView);
    }

    public final T getContext() {
        return this.context;
    }

    public final DexClassAndMethod getMethodContext() {
        assert (this.context.isMethod());
        return this.context.asMethod();
    }

    public TraversalContinuation<?> getTraversalContinuation() {
        return this.continuation;
    }

    public void registerRecordFieldValues(DexField[] fields) {
        this.registerTypeReference(this.appView.dexItemFactory().objectArrayType);
    }

    public abstract void registerInitClass(DexType var1);

    public abstract void registerInvokeVirtual(DexMethod var1);

    public abstract void registerInvokeDirect(DexMethod var1);

    public void registerInvokeSpecial(DexMethod method, boolean itf) {
        this.registerInvokeSpecial(method);
    }

    public void registerInvokeSpecial(DexMethod method) {
        DexClassAndMethod context = this.getMethodContext();
        Invoke.Type type = Invoke.Type.fromInvokeSpecial(method, context, this.appView, this.getCodeLens());
        if (type.isDirect()) {
            this.registerInvokeDirect(method);
        } else {
            assert (type.isSuper());
            this.registerInvokeSuper(method);
        }
    }

    public abstract void registerInvokeStatic(DexMethod var1);

    public abstract void registerInvokeInterface(DexMethod var1);

    public abstract void registerInvokeSuper(DexMethod var1);

    public abstract void registerInstanceFieldRead(DexField var1);

    public void registerInstanceFieldReadInstruction(CfOrDexInstanceFieldRead instruction) {
        this.registerInstanceFieldRead(instruction.getField());
    }

    public void registerInstanceFieldReadFromMethodHandle(DexField field) {
        this.registerInstanceFieldRead(field);
    }

    public abstract void registerInstanceFieldWrite(DexField var1);

    public void registerInstanceFieldWriteFromMethodHandle(DexField field) {
        this.registerInstanceFieldWrite(field);
    }

    public void registerInvokeStatic(DexMethod method, boolean itf) {
        this.registerInvokeStatic(method);
    }

    public void registerNewInstance(DexType type) {
        this.registerTypeReference(type);
    }

    public void registerNewUnboxedEnumInstance(DexType type) {
        this.registerTypeReference(type);
    }

    public abstract void registerStaticFieldRead(DexField var1);

    public void registerStaticFieldReadInstruction(CfOrDexStaticFieldRead instruction) {
        this.registerStaticFieldRead(instruction.getField());
    }

    public void registerStaticFieldReadFromMethodHandle(DexField field) {
        this.registerStaticFieldRead(field);
    }

    public abstract void registerStaticFieldWrite(DexField var1);

    public void registerStaticFieldWriteFromMethodHandle(DexField field) {
        this.registerStaticFieldWrite(field);
    }

    public abstract void registerTypeReference(DexType var1);

    public void registerInstanceOf(DexType type) {
        this.registerTypeReference(type);
    }

    public void registerConstClass(DexType type, ListIterator<? extends CfOrDexInstruction> iterator2, boolean ignoreCompatRules) {
        this.registerTypeReference(type);
    }

    public void registerCheckCast(DexType type, boolean ignoreCompatRules) {
        this.registerTypeReference(type);
    }

    public void registerSafeCheckCast(DexType type) {
        this.registerCheckCast(type, true);
    }

    public void registerExceptionGuard(DexType guard) {
        this.registerTypeReference(guard);
    }

    public void registerMethodHandle(DexMethodHandle methodHandle, MethodHandleUse use) {
        switch (methodHandle.type) {
            case INSTANCE_GET: {
                this.registerInstanceFieldReadFromMethodHandle(methodHandle.asField());
                break;
            }
            case INSTANCE_PUT: {
                this.registerInstanceFieldWriteFromMethodHandle(methodHandle.asField());
                break;
            }
            case STATIC_GET: {
                this.registerStaticFieldReadFromMethodHandle(methodHandle.asField());
                break;
            }
            case STATIC_PUT: {
                this.registerStaticFieldWriteFromMethodHandle(methodHandle.asField());
                break;
            }
            case INVOKE_INSTANCE: {
                this.registerInvokeVirtual(methodHandle.asMethod());
                break;
            }
            case INVOKE_STATIC: {
                this.registerInvokeStatic(methodHandle.asMethod());
                break;
            }
            case INVOKE_CONSTRUCTOR: {
                DexMethod method = methodHandle.asMethod();
                this.registerNewInstance(method.holder);
                this.registerInvokeDirect(method);
                break;
            }
            case INVOKE_INTERFACE: {
                this.registerInvokeInterface(methodHandle.asMethod());
                break;
            }
            case INVOKE_SUPER: {
                this.registerInvokeSuper(methodHandle.asMethod());
                break;
            }
            case INVOKE_DIRECT: {
                this.registerInvokeDirect(methodHandle.asMethod());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    protected void registerCallSiteExceptBootstrapArgs(DexCallSite callSite) {
        boolean isLambdaMetaFactory = this.dexItemFactory().isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
        if (!isLambdaMetaFactory) {
            this.registerMethodHandle(callSite.bootstrapMethod, MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY);
        }
        this.registerTypeReference(callSite.methodProto.returnType);
    }

    protected void registerCallSiteBootstrapArgs(DexCallSite callSite, int start, int end) {
        boolean isLambdaMetaFactory = this.appView.dexItemFactory().isLambdaMetafactoryMethod(callSite.bootstrapMethod.asMethod());
        assert (start >= 0);
        assert (end <= callSite.bootstrapArgs.size());
        block5: for (int i = start; i < end; ++i) {
            DexValue arg = callSite.bootstrapArgs.get(i);
            switch (arg.getValueKind()) {
                case METHOD_HANDLE: {
                    DexMethodHandle handle = (DexMethodHandle)arg.asDexValueMethodHandle().value;
                    MethodHandleUse use = isLambdaMetaFactory ? MethodHandleUse.ARGUMENT_TO_LAMBDA_METAFACTORY : MethodHandleUse.NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;
                    this.registerMethodHandle(handle, use);
                    continue block5;
                }
                case METHOD_TYPE: {
                    this.registerProto((DexProto)arg.asDexValueMethodType().value);
                    continue block5;
                }
                case TYPE: {
                    this.registerTypeReference((DexType)arg.asDexValueType().value);
                    continue block5;
                }
                default: {
                    assert (arg.isDexValueInt() || arg.isDexValueLong() || arg.isDexValueFloat() || arg.isDexValueDouble() || arg.isDexValueString());
                    continue block5;
                }
            }
        }
    }

    public void registerCallSite(DexCallSite callSite) {
        this.registerCallSiteExceptBootstrapArgs(callSite);
        this.registerCallSiteBootstrapArgs(callSite, 0, callSite.bootstrapArgs.size());
    }

    public void registerProto(DexProto proto) {
        this.registerTypeReference(proto.returnType);
        for (DexType type : proto.parameters.values) {
            this.registerTypeReference(type);
        }
    }

    public static enum MethodHandleUse {
        ARGUMENT_TO_LAMBDA_METAFACTORY,
        NOT_ARGUMENT_TO_LAMBDA_METAFACTORY;

    }
}

