/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.analysis;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.LookupTarget;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.shaking.DefaultEnqueuerUseRegistry;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;

public class ApiModelAnalysis
extends EnqueuerAnalysis {
    private final AppView<?> appView;
    private final AndroidApiLevelCompute apiCompute;
    private final ComputedApiLevel minApiLevel;

    public ApiModelAnalysis(AppView<?> appView) {
        this.appView = appView;
        this.apiCompute = appView.apiLevelCompute();
        this.minApiLevel = appView.computedMinApiLevel();
    }

    private void computeAndSetApiLevelForDefinition(DexClassAndMember<?, ?> member) {
        ((DexEncodedMember)member.getDefinition()).setApiLevelForDefinition(this.apiCompute.computeApiLevelForDefinition((DexMember<?, ?>)member.getReference(), this.appView.dexItemFactory(), this.apiCompute.getPlatformApiLevelOrUnknown(this.appView)));
    }

    @Override
    public void processNewlyLiveField(ProgramField field, ProgramDefinition context, EnqueuerWorklist worklist) {
        this.computeAndSetApiLevelForDefinition(field);
    }

    @Override
    public void processNewlyLiveMethod(ProgramMethod method, ProgramDefinition context, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        this.computeAndSetApiLevelForDefinition(method);
    }

    @Override
    public void processTracedCode(ProgramMethod method, DefaultEnqueuerUseRegistry registry, EnqueuerWorklist worklist) {
        assert (registry.getMaxApiReferenceLevel().isGreaterThanOrEqualTo(this.minApiLevel));
        if (this.appView.options().apiModelingOptions().tracedMethodApiLevelCallback != null) {
            this.appView.options().apiModelingOptions().tracedMethodApiLevelCallback.accept(method.getMethodReference(), registry.getMaxApiReferenceLevel());
        }
        this.computeAndSetApiLevelForDefinition(method);
        ((DexEncodedMethod)method.getDefinition()).setApiLevelForCode(registry.getMaxApiReferenceLevel());
    }

    @Override
    public void notifyMarkMethodAsTargeted(ProgramMethod method, EnqueuerWorklist worklist) {
        this.computeAndSetApiLevelForDefinition(method);
    }

    @Override
    public void notifyMarkFieldAsReachable(ProgramField field, EnqueuerWorklist worklist) {
        this.computeAndSetApiLevelForDefinition(field);
    }

    @Override
    public void notifyMarkVirtualDispatchTargetAsLive(LookupTarget target, EnqueuerWorklist worklist) {
        target.accept(this::computeAndSetApiLevelForDefinition, lookupLambdaTarget -> {});
    }

    @Override
    public void notifyFailedMethodResolutionTarget(DexEncodedMethod method, EnqueuerWorklist worklist) {
        method.setApiLevelForCode(ComputedApiLevel.unknown());
    }
}

