/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.analysis;

import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfLogicalBinop;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.graph.analysis.EnqueuerFieldAccessAnalysis;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import java.util.List;
import java.util.stream.Collectors;

public class ClassInitializerAssertionEnablingAnalysis
extends EnqueuerAnalysis
implements EnqueuerFieldAccessAnalysis {
    private static List<Class<?>> javacInstructionSequence = ImmutableList.of(CfIf.class, CfConstNumber.class, CfGoto.class, CfConstNumber.class, CfStaticFieldWrite.class);
    private static List<Class<?>> r8InstructionSequence = ImmutableList.of(CfConstNumber.class, CfLogicalBinop.class, CfStaticFieldWrite.class);
    private static List<Class<?>> jacocoInstructionSequence = ImmutableList.of(CfLoad.class, CfConstNumber.class, CfConstNumber.class, CfArrayStore.class);
    private final DexItemFactory dexItemFactory;
    private final OptimizationFeedback feedback;
    private final DexString kotlinAssertionsEnabled;
    private final AssertionConfigurationWithDefault assertionsConfiguration;
    private final List<DexMethod> assertionHandlers;

    public ClassInitializerAssertionEnablingAnalysis(AppView<?> appView, OptimizationFeedback feedback) {
        this.dexItemFactory = appView.dexItemFactory();
        this.feedback = feedback;
        this.kotlinAssertionsEnabled = this.dexItemFactory.createString("ENABLED");
        this.assertionsConfiguration = appView.options().assertionsConfiguration;
        this.assertionHandlers = this.assertionsConfiguration.getAllAssertionHandlers().stream().map(this.dexItemFactory::createMethod).collect(Collectors.toList());
    }

    private boolean isUsingJavaAssertionsDisabledField(DexField field) {
        return field.getName() == this.dexItemFactory.assertionsDisabled && field.getType() == this.dexItemFactory.booleanType;
    }

    private boolean isUsingKotlinAssertionsEnabledField(DexField field) {
        return field == this.dexItemFactory.kotlin.assertions.enabledField;
    }

    private boolean hasJavacClinitAssertionCode(CfCode code) {
        for (int i = 0; i < code.getInstructions().size(); ++i) {
            CfInvoke invoke;
            CfInstruction instruction = code.getInstructions().get(i);
            if (instruction.isInvoke() && (invoke = instruction.asInvoke()).getOpcode() == 182 && invoke.getMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus) {
                CfFieldInstruction fieldInstruction = this.isJavacInstructionSequence(code, i + 1);
                if (fieldInstruction == null) {
                    fieldInstruction = this.isR8InstructionSequence(code, i + 1);
                }
                if (fieldInstruction != null) {
                    return fieldInstruction.getOpcode() == 179 && fieldInstruction.getField().name == this.dexItemFactory.assertionsDisabled;
                }
            }
            if (!instruction.isJump()) continue;
            return false;
        }
        return false;
    }

    private boolean hasKotlincClinitAssertionCode(ProgramMethod method) {
        if (method.getHolderType() == this.dexItemFactory.kotlin.assertions.type) {
            CfCode code = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
            List<CfInstruction> instructions = code.getInstructions();
            for (int i = 1; i < instructions.size(); ++i) {
                CfFieldInstruction fieldInstruction;
                CfInvoke invoke;
                CfInstruction instruction = instructions.get(i - 1);
                if (instruction.isInvoke() && (invoke = instruction.asInvoke()).getOpcode() == 182 && invoke.getMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus && instructions.get(i).isFieldInstruction() && (fieldInstruction = instructions.get(i).asFieldInstruction()).getOpcode() == 179 && fieldInstruction.getField().name == this.kotlinAssertionsEnabled) {
                    return true;
                }
                if (!instruction.isJump()) continue;
                return false;
            }
        }
        return false;
    }

    private boolean skipSequence(List<Class<?>> sequence, CfCode code, int fromIndex) {
        int i;
        for (i = fromIndex; i < code.getInstructions().size() && i - fromIndex < sequence.size(); ++i) {
            CfInstruction instruction = code.getInstructions().get(i);
            if (instruction.getClass() == sequence.get(i - fromIndex)) continue;
            return false;
        }
        return i - fromIndex == sequence.size();
    }

    private CfFieldInstruction isJavacInstructionSequence(CfCode code, int fromIndex) {
        List<Class<?>> sequence = javacInstructionSequence;
        int nextExpectedInstructionIndex = 0;
        CfInstruction instruction = null;
        for (int i = fromIndex; i < code.getInstructions().size() && nextExpectedInstructionIndex < sequence.size(); ++i) {
            instruction = code.getInstructions().get(i);
            if (instruction.isLabel() || instruction.isFrame() || instruction.isPosition()) continue;
            if (instruction.getClass() != sequence.get(nextExpectedInstructionIndex)) {
                if (instruction.getClass() == jacocoInstructionSequence.get(0) && this.skipSequence(jacocoInstructionSequence, code, i)) {
                    if ((i += jacocoInstructionSequence.size()) >= code.getInstructions().size()) break;
                    instruction = code.getInstructions().get(i);
                }
                if (instruction.isLabel() || instruction.isFrame() || instruction.isPosition()) continue;
                if (instruction.getClass() != sequence.get(nextExpectedInstructionIndex)) break;
            }
            ++nextExpectedInstructionIndex;
        }
        return nextExpectedInstructionIndex == sequence.size() ? instruction.asFieldInstruction() : null;
    }

    private CfFieldInstruction isR8InstructionSequence(CfCode code, int fromIndex) {
        List<Class<?>> sequence = r8InstructionSequence;
        int nextExpectedInstructionIndex = 0;
        CfInstruction instruction = null;
        for (int i = fromIndex; i < code.getInstructions().size() && nextExpectedInstructionIndex < sequence.size(); ++i) {
            instruction = code.getInstructions().get(i);
            if (instruction.isStore() || instruction.isLoad()) continue;
            if (instruction.getClass() != sequence.get(nextExpectedInstructionIndex)) break;
            ++nextExpectedInstructionIndex;
        }
        return nextExpectedInstructionIndex == sequence.size() ? instruction.asFieldInstruction() : null;
    }

    @Override
    public void traceStaticFieldRead(DexField field, FieldResolutionResult resolutionResult, ProgramMethod context, EnqueuerWorklist worklist) {
        if (this.isUsingJavaAssertionsDisabledField(field) || this.isUsingKotlinAssertionsEnabledField(field)) {
            this.assertionHandlers.forEach(assertionHandler -> worklist.enqueueTraceInvokeStaticAction((DexMethod)assertionHandler, context));
        }
    }

    @Override
    public void processNewlyLiveMethod(ProgramMethod method, ProgramDefinition context, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (!definition.hasCode() || !definition.getCode().isCfCode()) {
            return;
        }
        CfCode code = definition.getCode().asCfCode();
        if (definition.isClassInitializer() && (this.hasJavacClinitAssertionCode(code) || this.hasKotlincClinitAssertionCode(method))) {
            this.feedback.setInitializerEnablingJavaVmAssertions(definition);
        }
    }
}

