/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.analysis;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerFieldAccessAnalysis;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerWorklist;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;

public class GetArrayOfMissingTypeVerifyErrorWorkaround
implements EnqueuerFieldAccessAnalysis {
    private final DexItemFactory dexItemFactory;
    private final Enqueuer enqueuer;
    private final AndroidApiLevelCompute apiLevelCompute;

    public GetArrayOfMissingTypeVerifyErrorWorkaround(AppView<? extends AppInfoWithClassHierarchy> appView, Enqueuer enqueuer) {
        this.dexItemFactory = appView.dexItemFactory();
        this.enqueuer = enqueuer;
        this.apiLevelCompute = appView.apiLevelCompute();
    }

    public static void register(AppView<? extends AppInfoWithClassHierarchy> appView, Enqueuer enqueuer) {
        if (!GetArrayOfMissingTypeVerifyErrorWorkaround.isNoop(appView)) {
            enqueuer.registerFieldAccessAnalysis(new GetArrayOfMissingTypeVerifyErrorWorkaround(appView, enqueuer));
        }
    }

    private static boolean isNoop(AppView<? extends AppInfoWithClassHierarchy> appView) {
        InternalOptions options = appView.options();
        return options.isGeneratingDex() && options.getMinApiLevel().isGreaterThanOrEqualTo(AndroidApiLevel.L);
    }

    private boolean isUnsafeToUseFieldOnDalvik(DexField field) {
        DexType fieldType = field.getType();
        if (!fieldType.isArrayType()) {
            return false;
        }
        DexType baseType = fieldType.toBaseType(this.dexItemFactory);
        if (!baseType.isClassType()) {
            return false;
        }
        ComputedApiLevel baseTypeApiLevel = this.apiLevelCompute.computeApiLevelForLibraryReference(baseType, ComputedApiLevel.unknown());
        return !baseTypeApiLevel.isKnownApiLevel() || baseTypeApiLevel.asKnownApiLevel().getApiLevel().isGreaterThanOrEqualTo(AndroidApiLevel.L);
    }

    @Override
    public void traceInstanceFieldRead(DexField field, FieldResolutionResult resolutionResult, ProgramMethod context, EnqueuerWorklist worklist) {
        if (this.isUnsafeToUseFieldOnDalvik(field)) {
            this.enqueuer.getKeepInfo().joinMethod(context, KeepInfo.Joiner::disallowOptimization);
        }
    }

    @Override
    public void traceStaticFieldRead(DexField field, FieldResolutionResult resolutionResult, ProgramMethod context, EnqueuerWorklist worklist) {
        if (this.isUnsafeToUseFieldOnDalvik(field)) {
            this.enqueuer.getKeepInfo().joinMethod(context, KeepInfo.Joiner::disallowOptimization);
        }
    }

    @Override
    public void traceInstanceFieldWrite(DexField field, FieldResolutionResult resolutionResult, ProgramMethod context, EnqueuerWorklist worklist) {
    }

    @Override
    public void traceStaticFieldWrite(DexField field, FieldResolutionResult resolutionResult, ProgramMethod context, EnqueuerWorklist worklist) {
    }
}

