/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph.analysis;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.analysis.EnqueuerInvokeAnalysis;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepInfo;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.InternalOptions;

public class InvokeVirtualToInterfaceVerifyErrorWorkaround
implements EnqueuerInvokeAnalysis {
    private final DexType androidHardwareCamera2CameraDeviceType;
    private final Enqueuer enqueuer;
    private final InternalOptions options;

    public InvokeVirtualToInterfaceVerifyErrorWorkaround(AppView<? extends AppInfoWithClassHierarchy> appView, Enqueuer enqueuer) {
        this.androidHardwareCamera2CameraDeviceType = appView.dexItemFactory().createType("Landroid/hardware/camera2/CameraDevice;");
        this.enqueuer = enqueuer;
        this.options = appView.options();
    }

    public static void register(AppView<? extends AppInfoWithClassHierarchy> appView, Enqueuer enqueuer) {
        if (!InvokeVirtualToInterfaceVerifyErrorWorkaround.isNoop(appView)) {
            enqueuer.registerInvokeAnalysis(new InvokeVirtualToInterfaceVerifyErrorWorkaround(appView, enqueuer));
        }
    }

    private static boolean isNoop(AppView<? extends AppInfoWithClassHierarchy> appView) {
        return appView.options().getMinApiLevel().isGreaterThanOrEqualTo(AndroidApiLevel.L);
    }

    private boolean isInterfaceInSomeApiLevel(DexType type) {
        return type == this.androidHardwareCamera2CameraDeviceType && (this.options.isGeneratingClassFiles() || this.options.getMinApiLevel().isLessThan(AndroidApiLevel.L));
    }

    @Override
    public void traceInvokeVirtual(DexMethod invokedMethod, ProgramMethod context) {
        if (this.isInterfaceInSomeApiLevel(invokedMethod.getHolderType())) {
            this.enqueuer.getKeepInfo().joinMethod(context, KeepInfo.Joiner::disallowOptimization);
        }
    }

    @Override
    public void traceInvokeDirect(DexMethod invokedMethod, ProgramMethod context) {
    }

    @Override
    public void traceInvokeInterface(DexMethod invokedMethod, ProgramMethod context) {
    }

    @Override
    public void traceInvokeStatic(DexMethod invokedMethod, ProgramMethod context) {
    }

    @Override
    public void traceInvokeSuper(DexMethod invokedMethod, ProgramMethod context) {
    }
}

